use strict;
#use warnings;

my %hash=();
open(RF, "risk.txt") or die $!;
while(my $line=<RF>){
	chomp($line);
	my @arr=split(/\t/, $line);
	$hash{$arr[0]}=$arr[$#arr];
}
close(RF);

my %fieldHash=();
my $lineCount=0;
open(RF, "input.maf") or die $!;
open(LOW, ">low.maf") or die $!;
open(HIGH, ">high.maf") or die $!;
while(my $line=<RF>){
	#my @samp1e=(localtime(time));
	
	
	
	
	next if($line=~/^\n/);
	next if($line=~/^\#/);
	$lineCount++;
	chomp($line);
	my @arr=split(/\t/,$line);                                                                                                                      
	if($lineCount==1){
		for(my $i=0;$i<=$#arr;$i++){
			$fieldHash{$arr[$i]}=$i;
		}
		print LOW $line . "\n";
		print HIGH $line . "\n";
		next;
	}
	
	#ȥûиı
	if($arr[$fieldHash{"Amino_acids"}] eq ""){
		next;
	}
	if($arr[$fieldHash{"Variant_Classification"}] eq "Silent"){
		next;
	}
	if($arr[$fieldHash{"Variant_Classification"}] eq "Splice_Region"){
		next;
	}
	
	my $sampleName=$arr[$fieldHash{"Tumor_Sample_Barcode"}];
	my @sampleArr=split(/\-/, $sampleName);
	my $subSampleName="$sampleArr[0]-$sampleArr[1]-$sampleArr[2]";
	if(exists $hash{$subSampleName}){
		if($hash{$subSampleName} eq "high"){
			$arr[$fieldHash{"Tumor_Sample_Barcode"}]=$subSampleName;
			print HIGH join("\t", @arr) . "\n";
		}
		if($hash{$subSampleName} eq "low"){
			$arr[$fieldHash{"Tumor_Sample_Barcode"}]=$subSampleName;
			print LOW join("\t", @arr) . "\n";
		}
	}
}
close(HIGH);
close(LOW);
close(RF);





=pod
[[[Data Format description]]]
Hugo_Symbol	Entrez_Gene_Id	Center	NCBI_Build	Chromosome	Start_Position	End_Position	Strand	Variant_Classification	Variant_Type	Reference_Allele	Tumor_Seq_Allele1	Tumor_Seq_Allele2	dbSNP_RS	dbSNP_Val_Status	Tumor_Sample_Barcode	Matched_Norm_Sample_Barcode	Match_Norm_Seq_Allele1	Match_Norm_Seq_Allele2	Tumor_Validation_Allele1	Tumor_Validation_Allele2	Match_Norm_Validation_Allele1	Match_Norm_Validation_Allele2	Verification_Status	Validation_Status	Mutation_Status	Sequencing_Phase	Sequence_Source	Validation_Method	Score	BAM_File	Sequencer	Tumor_Sample_UUID	Matched_Norm_Sample_UUID	HGVSc	HGVSp	HGVSp_Short	Transcript_ID	Exon_Number	t_depth	t_ref_count	t_alt_count	n_depth	n_ref_count	n_alt_count	all_effects	Allele	Gene	Feature	Feature_type	One_Consequence	Consequence	cDNA_position	CDS_position	Protein_position	Amino_acids	Codons	Existing_variation	ALLELE_NUM	DISTANCE	TRANSCRIPT_STRAND	SYMBOL	SYMBOL_SOURCE	HGNC_ID	BIOTYPE	CANONICAL	CCDS	ENSP	SWISSPROT	TREMBL	UNIPARC	RefSeq	SIFT	PolyPhen	EXON	INTRON	DOMAINS	GMAF	AFR_MAF	AMR_MAF	ASN_MAF	EAS_MAF	EUR_MAF	SAS_MAF	AA_MAF	EA_MAF	CLIN_SIG	SOMATIC	PUBMED	MOTIF_NAME	MOTIF_POS	HIGH_INF_POS	MOTIF_SCORE_CHANGE	IMPACT	PICK	VARIANT_CLASS	TSL	HGVS_OFFSET	PHENO	MINIMISED	ExAC_AF	ExAC_AF_Adj	ExAC_AF_AFR	ExAC_AF_AMR	ExAC_AF_EAS	ExAC_AF_FIN	ExAC_AF_NFE	ExAC_AF_OTH	ExAC_AF_SAS	GENE_PHENO	FILTER	CONTEXT	src_vcf_id	tumor_bam_uuid	normal_bam_uuid	case_id	GDC_FILTER	COSMIC	MC3_Overlap	GDC_Validation_Status
CLSTN1	22883	BI	GRCh38	chr1	9735506	9735506	+	Missense_Mutation	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1844C>T	p.Thr615Met	p.T615M	ENST00000377298	13/19	209	183	26	244			CLSTN1,missense_variant,p.T615M,ENST00000377298,NM_001009566.1,c.1844C>T,MODERATE,YES,deleterious(0),probably_damaging(0.999),-1;CLSTN1,missense_variant,p.T605M,ENST00000361311,NM_014944.3,c.1814C>T,MODERATE,,deleterious(0),probably_damaging(1),-1;CLSTN1,missense_variant,p.T416M,ENST00000435891,,c.1247C>T,MODERATE,,deleterious(0),probably_damaging(0.999),-1;CLSTN1,upstream_gene_variant,,ENST00000477264,,,MODIFIER,,,,-1	A	ENSG00000171603	ENST00000377298	Transcript	missense_variant	missense_variant	2637/5221	1844/2946	615/981	T/M	aCg/aTg		1		-1	CLSTN1	HGNC	HGNC:17447	protein_coding	YES	CCDS30580.1	ENSP00000366513	O94985			NM_001009566.1	deleterious(0)	probably_damaging(0.999)	13/19																			MODERATE	1	SNV	1			1											PASS	CGGGCGTGGGG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4010803	True	Unknown
PNRC2	55629	BI	GRCh38	chr1	23961806	23961807	+	Frame_Shift_Ins	INS	-	-	T	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.352dupT	p.Ser118PhefsTer3	p.S118Ffs*3	ENST00000334351	3/3	35	27	8	22			PNRC2,frameshift_variant,p.S118Ffs*3,ENST00000334351,NM_017761.3,c.352dupT,HIGH,YES,,,1;PNRC2,frameshift_variant,p.S118Ffs*3,ENST00000374468,,c.352dupT,HIGH,,,,1;SRSF10,downstream_gene_variant,,ENST00000344989,NM_006625.4,,MODIFIER,,,,-1;SRSF10,downstream_gene_variant,,ENST00000453840,NM_001191007.1,,MODIFIER,,,,-1;PNRC2,downstream_gene_variant,,ENST00000471915,,,MODIFIER,,,,1;PNRC2,downstream_gene_variant,,ENST00000579103,,,MODIFIER,,,,1;SRSF10,downstream_gene_variant,,ENST00000341154,,,MODIFIER,,,,-1	T	ENSG00000189266	ENST00000334351	Transcript	frameshift_variant	frameshift_variant	760-761/2416	349-350/420	117/139	V/VX	gtt/gTtt		1		1	PNRC2	HGNC	HGNC:23158	protein_coding	YES	CCDS246.1	ENSP00000334840	Q9NPJ4	A0A024RAC2		NM_017761.3			3/3																			HIGH	1	insertion	1	3		1											PASS	TCCCTGTTTCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			False	Unknown
AGBL4	84871	BI	GRCh38	chr1	48586947	48586947	+	Intron	SNP	T	T	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1267+57A>G			ENST00000371839		14	7	7	14			AGBL4,missense_variant,p.S288G,ENST00000416121,,c.861A>G,MODERATE,,tolerated_low_confidence(1),benign(0),-1;AGBL4,intron_variant,,ENST00000371839,NM_032785.3,c.1267+57A>G,MODIFIER,YES,,,-1;AGBL4,intron_variant,,ENST00000334103,,c.634+57A>G,MODIFIER,,,,-1	C	ENSG00000186094	ENST00000371839	Transcript	intron_variant	intron_variant	-/2947	-/1512	-/503				1		-1	AGBL4	HGNC	HGNC:25892	protein_coding	YES	CCDS44137.1	ENSP00000360905	Q5VU57		UPI00002042F9	NM_032785.3				11/13																		MODIFIER	1	SNV	2			1											PASS	CAGACTTGGAT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			False	Unknown
LRRIQ3	127255	BI	GRCh38	chr1	74182744	74182744	+	Missense_Mutation	SNP	T	T	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.367A>C	p.Thr123Pro	p.T123P	ENST00000354431	3/8	71	33	38	80			LRRIQ3,missense_variant,p.T123P,ENST00000354431,NM_001105659.1,c.367A>C,MODERATE,YES,deleterious(0.01),benign(0.032),-1;LRRIQ3,missense_variant,p.T123P,ENST00000395089,,c.367A>C,MODERATE,,deleterious(0.01),benign(0.032),-1;LRRIQ3,missense_variant,p.T123P,ENST00000370911,,c.367A>C,MODERATE,,deleterious(0.02),benign(0.012),-1;LRRIQ3,intron_variant,,ENST00000370909,,c.249+692A>C,MODIFIER,,,,-1;LRRIQ3,intron_variant,,ENST00000444984,,c.76+692A>C,MODIFIER,,,,-1;LRRIQ3,upstream_gene_variant,,ENST00000495179,,,MODIFIER,,,,-1;LRRIQ3,missense_variant,p.T123P,ENST00000415760,,c.367A>C,MODERATE,,deleterious(0.02),benign(0.113),-1;LRRIQ3,non_coding_transcript_exon_variant,,ENST00000463724,,n.1093A>C,MODIFIER,,,,-1	G	ENSG00000162620	ENST00000354431	Transcript	missense_variant	missense_variant	559/2849	367/1875	123/624	T/P	Acc/Ccc		1		-1	LRRIQ3	HGNC	HGNC:28318	protein_coding	YES	CCDS41350.1	ENSP00000346414	A6PVS8		UPI000155D493	NM_001105659.1	deleterious(0.01)	benign(0.032)	3/8		Superfamily_domains:SSF52058																	MODERATE	1	SNV	5			1											PASS	GAGGGTTGGAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4009831	True	Unknown
TNNI3K	51086	BI	GRCh38	chr1	74492115	74492115	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2200A>C	p.Ser734Arg	p.S734R	ENST00000326637	23/25	220	184	36	260			TNNI3K,missense_variant,p.S734R,ENST00000326637,NM_015978.2,c.2200A>C,MODERATE,YES,tolerated_low_confidence(0.13),benign(0.157),1;FPGT-TNNI3K,missense_variant,p.S848R,ENST00000557284,NM_001112808.2,c.2542A>C,MODERATE,YES,tolerated_low_confidence(0.09),benign(0.382),1;LRRC53,intron_variant,,ENST00000294635,,c.-26-8740T>G,MODIFIER,YES,,,-1	C	ENSG00000116783	ENST00000326637	Transcript	missense_variant	missense_variant	2251/3001	2200/2508	734/835	S/R	Agt/Cgt		1		1	TNNI3K	HGNC	HGNC:19661	protein_coding	YES	CCDS664.1	ENSP00000322251	Q59H18		UPI0000035B8F	NM_015978.2	tolerated_low_confidence(0.13)	benign(0.157)	23/25		Low_complexity_(Seg):Seg																	MODERATE	1	SNV	1			1											PASS	CATCAAGTAAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4009849	True	Unknown
ADGRL4	64123	BI	GRCh38	chr1	78939214	78939214	+	Missense_Mutation	SNP	C	C	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.370G>T	p.Ala124Ser	p.A124S	ENST00000370742	4/15	28	18	10	28			ADGRL4,missense_variant,p.A124S,ENST00000370742,NM_022159.3,c.370G>T,MODERATE,YES,tolerated(0.28),benign(0.01),-1	A	ENSG00000162618	ENST00000370742	Transcript	missense_variant	missense_variant	434/3527	370/2073	124/690	A/S	Gca/Tca		1		-1	ADGRL4	HGNC	HGNC:20822	protein_coding	YES	CCDS41352.1	ENSP00000359778	Q9HBW9		UPI00004561FF	NM_022159.3	tolerated(0.28)	benign(0.01)	4/15																			MODERATE	1	SNV	1			1											PASS	ATTTGCAGCTA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4010077	True	Unknown
FLG2	388698	BI	GRCh38	chr1	152351257	152351257	+	Missense_Mutation	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.6529A>G	p.Arg2177Gly	p.R2177G	ENST00000388718	3/3	371	323	48	301			FLG2,missense_variant,p.R2177G,ENST00000388718,NM_001014342.2,c.6529A>G,MODERATE,YES,,benign(0.017),-1;FLG-AS1,intron_variant,,ENST00000392688,,n.1406+10047T>C,MODIFIER,YES,,,1;FLG-AS1,intron_variant,,ENST00000445097,,n.151+10047T>C,MODIFIER,,,,1;FLG-AS1,intron_variant,,ENST00000629331,,n.62-12730T>C,MODIFIER,,,,1	C	ENSG00000143520	ENST00000388718	Transcript	missense_variant	missense_variant	6602/9124	6529/7176	2177/2391	R/G	Aga/Gga		1		-1	FLG2	HGNC	HGNC:33276	protein_coding	YES	CCDS30861.1	ENSP00000373370	Q5D862		UPI00004E1DE5	NM_001014342.2		benign(0.017)	3/3		Low_complexity_(Seg):Seg;PROSITE_profiles:PS50315;PROSITE_profiles:PS50316																	MODERATE		SNV	5			1											PASS	AGATCTTTGTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4022486	True	Unknown
CD1C	911	BI	GRCh38	chr1	158291387	158291387	+	Missense_Mutation	SNP	A	A	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.315A>T	p.Gln105His	p.Q105H	ENST00000368170	2/6	116	102	13	88			CD1C,missense_variant,p.Q105H,ENST00000368170,NM_001765.2,c.315A>T,MODERATE,YES,deleterious(0.05),benign(0.028),1;CD1C,missense_variant,p.Q40H,ENST00000443761,,c.118A>T,MODERATE,,tolerated(0.06),benign(0.149),1	T	ENSG00000158481	ENST00000368170	Transcript	missense_variant	missense_variant	594/1435	315/1002	105/333	Q/H	caA/caT		1		1	CD1C	HGNC	HGNC:1636	protein_coding	YES	CCDS1175.1	ENSP00000357152	P29017		UPI000013DF78	NM_001765.2	deleterious(0.05)	benign(0.028)	2/6		Superfamily_domains:SSF54452																	MODERATE	1	SNV	1			1											PASS	AGTCAAGATTA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4023658	True	Unknown
CADM3	57863	BI	GRCh38	chr1	159200941	159200941	+	3'UTR	SNP	T	T	G	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.*19T>G			ENST00000368125	9/9	36	21	15	39			CADM3,3_prime_UTR_variant,,ENST00000368125,NM_001127173.1,c.*19T>G,MODIFIER,,,,1;CADM3,3_prime_UTR_variant,,ENST00000368124,NM_021189.3,c.*19T>G,MODIFIER,YES,,,1;ACKR1,upstream_gene_variant,,ENST00000537147,,,MODIFIER,,,,1;ACKR1,upstream_gene_variant,,ENST00000368122,NM_002036.3,,MODIFIER,,,,1;ACKR1,upstream_gene_variant,,ENST00000368121,NM_001122951.2,,MODIFIER,YES,,,1;CADM3,downstream_gene_variant,,ENST00000416746,,,MODIFIER,,,,1;ACKR1,upstream_gene_variant,,ENST00000435307,,,MODIFIER,,,,1;CADM3-AS1,non_coding_transcript_exon_variant,,ENST00000415675,,n.944A>C,MODIFIER,YES,,,-1;CADM3-AS1,downstream_gene_variant,,ENST00000609696,,,MODIFIER,,,,-1	G	ENSG00000162706	ENST00000368125	Transcript	3_prime_UTR_variant	3_prime_UTR_variant	1373/3745	-/1197	-/398				1		1	CADM3	HGNC	HGNC:17601	protein_coding		CCDS44251.1	ENSP00000357107	Q8N126		UPI0000031579	NM_001127173.1			9/9																			MODIFIER		SNV	1			1											PASS	CTTCCTGCGCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
DUSP23	54935	BI	GRCh38	chr1	159782321	159782321	+	Missense_Mutation	SNP	T	T	G	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.436T>G	p.Tyr146Asp	p.Y146D	ENST00000368107	2/2	47	35	12	58			DUSP23,missense_variant,p.Y146D,ENST00000368107,,c.436T>G,MODERATE,YES,tolerated(0.07),benign(0.297),1;DUSP23,missense_variant,p.Y146D,ENST00000368109,,c.436T>G,MODERATE,,tolerated(0.07),benign(0.297),1;DUSP23,missense_variant,p.Y146D,ENST00000368108,NM_017823.3,c.436T>G,MODERATE,,tolerated(0.07),benign(0.297),1	G	ENSG00000158716	ENST00000368107	Transcript	missense_variant	missense_variant	534/756	436/453	146/150	Y/D	Tac/Gac		1		1	DUSP23	HGNC	HGNC:21480	protein_coding	YES	CCDS1187.1	ENSP00000357087	Q9BVJ7		UPI00000373FA		tolerated(0.07)	benign(0.297)	2/2		SMART_domains:SM00195;SMART_domains:SM00404;Superfamily_domains:SSF52799																	MODERATE	1	SNV	1			1											PASS	AGTTCTACCAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
NR5A2	2494	BI	GRCh38	chr1	200120893	200120893	+	Missense_Mutation	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1316G>A	p.Arg439His	p.R439H	ENST00000367362	7/8	121	102	19	102			NR5A2,missense_variant,p.R439H,ENST00000367362,NM_205860.2,c.1316G>A,MODERATE,YES,tolerated(0.53),benign(0.014),1;NR5A2,missense_variant,p.R367H,ENST00000544748,NM_001276464.1,c.1100G>A,MODERATE,,tolerated(0.76),benign(0.014),1;NR5A2,missense_variant,p.R393H,ENST00000236914,NM_003822.4,c.1178G>A,MODERATE,,tolerated(0.7),benign(0.006),1	A	ENSG00000116833	ENST00000367362	Transcript	missense_variant	missense_variant	1562/5086	1316/1626	439/541	R/H	cGt/cAt		1		1	NR5A2	HGNC	HGNC:7984	protein_coding	YES	CCDS1401.1	ENSP00000356331	O00482		UPI0000130482	NM_205860.2	tolerated(0.53)	benign(0.014)	7/8		Pfam_domain:PF00104;SMART_domains:SM00430;Superfamily_domains:SSF48508;PIRSF_domain:PIRSF002530																	MODERATE	1	SNV	1			1											PASS	ACTTCGTTCTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM1337668	True	Unknown
IGFN1	91156	BI	GRCh38	chr1	201216567	201216567	+	Missense_Mutation	SNP	G	G	A	rs367699515	byCluster;byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2038G>A	p.Val680Met	p.V680M	ENST00000295591	17/25	28	18	10	25			IGFN1,missense_variant,p.V3137M,ENST00000335211,NM_001164586.1,c.9409G>A,MODERATE,YES,,possibly_damaging(0.559),1;IGFN1,missense_variant,p.V680M,ENST00000295591,,c.2038G>A,MODERATE,,tolerated(0.14),benign(0.033),1;IGFN1,missense_variant,p.V555M,ENST00000412892,,c.1661G>A,MODERATE,,tolerated(0.14),benign(0.131),1;IGFN1,3_prime_UTR_variant,,ENST00000437879,,c.*275G>A,MODIFIER,,,,1;IGFN1,non_coding_transcript_exon_variant,,ENST00000473483,,n.1513G>A,MODIFIER,,,,1	A	ENSG00000163395	ENST00000295591	Transcript	missense_variant	missense_variant	2168/4439	2038/3756	680/1251	V/M	Gtg/Atg	rs367699515	1		1	IGFN1	HGNC	HGNC:24607	protein_coding			ENSP00000295591	Q86VF2		UPI00017BE784		tolerated(0.14)	benign(0.033)	17/25		Pfam_domain:PF00041;PROSITE_profiles:PS50853;SMART_domains:SM00060;Superfamily_domains:SSF49265																	MODERATE		SNV	5			1	4.119e-05	4.338e-05	0	0.0001793	0.0002407	0	1.582e-05	0	0		PASS	GCTACGTGGTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM2212079;COSM2212080	True	Unknown
C4BPA	722	BI	GRCh38	chr1	207144572	207144572	+	Missense_Mutation	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1649T>C	p.Leu550Pro	p.L550P	ENST00000367070	12/12	124	72	51	58			C4BPA,missense_variant,p.L550P,ENST00000367070,NM_000715.3,c.1649T>C,MODERATE,YES,tolerated(0.11),possibly_damaging(0.762),1	C	ENSG00000123838	ENST00000367070	Transcript	missense_variant	missense_variant	1843/2243	1649/1794	550/597	L/P	cTc/cCc		1		1	C4BPA	HGNC	HGNC:1325	protein_coding	YES	CCDS1477.1	ENSP00000356037	P04003		UPI0000126C28	NM_000715.3	tolerated(0.11)	possibly_damaging(0.762)	12/12																			MODERATE	1	SNV	1			1											PASS	AGTGCTCACAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4027595	True	Unknown
HHIPL2	79802	BI	GRCh38	chr1	222547819	222547819	+	Missense_Mutation	SNP	G	G	A	rs375371391	byCluster;byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.226C>T	p.Arg76Cys	p.R76C	ENST00000343410	1/9	100	87	13	62			HHIPL2,missense_variant,p.R76C,ENST00000343410,NM_024746.3,c.226C>T,MODERATE,YES,tolerated(0.06),benign(0.011),-1	A	ENSG00000143512	ENST00000343410	Transcript	missense_variant	missense_variant	285/2575	226/2175	76/724	R/C	Cgc/Tgc	rs375371391	1		-1	HHIPL2	HGNC	HGNC:25842	protein_coding	YES	CCDS1530.2	ENSP00000342118	Q6UWX4		UPI000004C60D	NM_024746.3	tolerated(0.06)	benign(0.011)	1/9		Pfam_domain:PF03024								0	0.0001								MODERATE	1	SNV	1			1	8.274e-06	8.291e-06	0	8.643e-05	0	0	0	0	0		PASS	GCGGCGGTCCT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	gdc_pon	COSM4028506	True	Unknown
LBR	3930	BI	GRCh38	chr1	225404616	225404628	+	Splice_Site	DEL	CAATACTTACGTG	CAATACTTACGTG	-	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1562_1564+10delCACGTAAGTATTG		p.X521_splice	ENST00000272163	12/14	45	36	9	24			LBR,splice_donor_variant,p.X521_splice,ENST00000338179,NM_194442.2,c.1562_1564+10delCACGTAAGTATTG,HIGH,YES,,,-1;LBR,splice_donor_variant,p.X521_splice,ENST00000272163,NM_002296.3,c.1562_1564+10delCACGTAAGTATTG,HIGH,,,,-1;LBR,upstream_gene_variant,,ENST00000441022,,,MODIFIER,,,,-1;LBR,downstream_gene_variant,,ENST00000424022,,,MODIFIER,,,,-1	-	ENSG00000143815	ENST00000272163	Transcript	splice_donor_variant	splice_donor_variant;coding_sequence_variant;intron_variant	1658-?/3745	1562-?/1848	521-?/615				1		-1	LBR	HGNC	HGNC:6518	protein_coding		CCDS1545.1	ENSP00000272163	Q14739		UPI000012E256	NM_002296.3			12/14	12/13																		HIGH		deletion	1			1											PASS	ATAAATCAATACTTACGTGCAAGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
OR2B11	127623	BI	GRCh38	chr1	247451515	247451515	+	Silent	SNP	G	G	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.468C>A	p.=	p.G156G	ENST00000318749	1/1	44	23	21	50			OR2B11,synonymous_variant,p.G156G,ENST00000318749,NM_001004492.1,c.468C>A,LOW,YES,,,-1;NLRP3,downstream_gene_variant,,ENST00000366497,NM_001127461.2,,MODIFIER,,,,1;NLRP3,downstream_gene_variant,,ENST00000336119,NM_001243133.1&NM_004895.4,,MODIFIER,YES,,,1;NLRP3,downstream_gene_variant,,ENST00000366496,,,MODIFIER,,,,1;NLRP3,downstream_gene_variant,,ENST00000391828,NM_001079821.2,,MODIFIER,,,,1;NLRP3,downstream_gene_variant,,ENST00000348069,NM_183395.2,,MODIFIER,,,,1;NLRP3,downstream_gene_variant,,ENST00000391827,NM_001127462.2,,MODIFIER,,,,1;NLRP3,downstream_gene_variant,,ENST00000532083,,,MODIFIER,,,,1	T	ENSG00000177535	ENST00000318749	Transcript	synonymous_variant	synonymous_variant	468/954	468/954	156/317	G	ggC/ggA		1		-1	OR2B11	HGNC	HGNC:31249	protein_coding	YES	CCDS31090.1	ENSP00000325682	Q5JQS5		UPI0000418F50	NM_001004492.1			1/1		Transmembrane_helices:Tmhmm;Pfam_domain:PF00001;Pfam_domain:PF10323;PROSITE_profiles:PS50262;Superfamily_domains:SSF81321																	LOW		SNV				1											PASS	CCGAAGCCACT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4030549	True	Unknown
OR14A16	284532	BI	GRCh38	chr1	247815197	247815197	+	Missense_Mutation	SNP	T	T	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.533A>T	p.Asp178Val	p.D178V	ENST00000357627	1/1	79	46	33	71			OR14A16,missense_variant,p.D178V,ENST00000357627,NM_001001966.1,c.533A>T,MODERATE,YES,deleterious(0),probably_damaging(0.993),-1	A	ENSG00000196772	ENST00000357627	Transcript	missense_variant	missense_variant	533/930	533/930	178/309	D/V	gAc/gTc		1		-1	OR14A16	HGNC	HGNC:15022	protein_coding	YES	CCDS31097.1	ENSP00000350248	Q8NHC5		UPI0000041CE2	NM_001001966.1	deleterious(0)	probably_damaging(0.993)	1/1		Pfam_domain:PF00001;Prints_domain:PR00245;PROSITE_profiles:PS50262;Superfamily_domains:SSF81321																	MODERATE	1	SNV				1											PASS	GAATGTCACAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4030610	True	Unknown
OR2M5	127059	BI	GRCh38	chr1	248145595	248145595	+	Missense_Mutation	SNP	A	A	G	rs761884640	byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.448A>G	p.Ile150Val	p.I150V	ENST00000366476	1/1	324	289	35	248			OR2M5,missense_variant,p.I150V,ENST00000366476,NM_001004690.1,c.448A>G,MODERATE,YES,tolerated(0.4),benign(0.042),1	G	ENSG00000162727	ENST00000366476	Transcript	missense_variant	missense_variant	448/939	448/939	150/312	I/V	Atc/Gtc	rs761884640	1		1	OR2M5	HGNC	HGNC:19576	protein_coding	YES	CCDS31105.1	ENSP00000355432	A3KFT3		UPI00001612E2	NM_001004690.1	tolerated(0.4)	benign(0.042)	1/1		Transmembrane_helices:Tmhmm;Pfam_domain:PF00001;Pfam_domain:PF10320;PROSITE_profiles:PS50262;Superfamily_domains:SSF81321																	MODERATE	1	SNV				1	2.471e-05	2.471e-05	0	0	0	0	4.495e-05	0	0		PASS	CCTGGATCCTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4030693	True	Unknown
OR2T1	26696	BI	GRCh38	chr1	248406325	248406325	+	Missense_Mutation	SNP	T	T	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.331T>G	p.Phe111Val	p.F111V	ENST00000366474	1/1	169	110	59	158			OR2T1,missense_variant,p.F111V,ENST00000366474,NM_030904.1,c.331T>G,MODERATE,YES,deleterious(0.01),probably_damaging(0.999),1	G	ENSG00000175143	ENST00000366474	Transcript	missense_variant	missense_variant	331/1110	331/1110	111/369	F/V	Ttc/Gtc		1		1	OR2T1	HGNC	HGNC:8277	protein_coding	YES	CCDS31115.1	ENSP00000355430	O43869		UPI00003B2872	NM_030904.1	deleterious(0.01)	probably_damaging(0.999)	1/1		Pfam_domain:PF00001;Transmembrane_helices:Tmhmm;Prints_domain:PR00237;PROSITE_profiles:PS50262;Superfamily_domains:SSF81321																	MODERATE	1	SNV				1											PASS	TGTACTTCCTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4030762	True	Unknown
KIDINS220	57498	BI	GRCh38	chr2	8779134	8779134	+	Silent	SNP	T	T	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2376A>G	p.=	p.R792R	ENST00000256707	19/30	60	50	10	72			KIDINS220,synonymous_variant,p.R792R,ENST00000256707,NM_020738.2,c.2376A>G,LOW,YES,,,-1;KIDINS220,synonymous_variant,p.R792R,ENST00000473731,,c.2376A>G,LOW,,,,-1;KIDINS220,synonymous_variant,p.R793R,ENST00000489024,,c.2379A>G,LOW,,,,-1;KIDINS220,synonymous_variant,p.R793R,ENST00000319688,,c.2379A>G,LOW,,,,-1;KIDINS220,synonymous_variant,p.R539R,ENST00000496383,,c.1617A>G,LOW,,,,-1;KIDINS220,3_prime_UTR_variant,,ENST00000488729,,c.*2436A>G,MODIFIER,,,,-1	C	ENSG00000134313	ENST00000256707	Transcript	synonymous_variant	synonymous_variant	2558/7361	2376/5316	792/1771	R	cgA/cgG		1		-1	KIDINS220	HGNC	HGNC:29508	protein_coding	YES	CCDS42650.1	ENSP00000256707	Q9ULH0		UPI0000208E08	NM_020738.2			19/30		Pfam_domain:PF07693																	LOW	1	SNV	1			1											PASS	AGAACTCGGAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
XDH	7498	BI	GRCh38	chr2	31349779	31349779	+	Missense_Mutation	SNP	T	T	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2876A>C	p.Lys959Thr	p.K959T	ENST00000379416	26/36	84	68	16	102			XDH,missense_variant,p.K959T,ENST00000379416,NM_000379.3,c.2876A>C,MODERATE,YES,tolerated(0.51),benign(0.063),-1	G	ENSG00000158125	ENST00000379416	Transcript	missense_variant	missense_variant	2925/5688	2876/4002	959/1333	K/T	aAg/aCg		1		-1	XDH	HGNC	HGNC:12805	protein_coding	YES	CCDS1775.1	ENSP00000368727	P47989		UPI0000036BC9	NM_000379.3	tolerated(0.51)	benign(0.063)	26/36		Pfam_domain:PF02738;Superfamily_domains:SSF56003;PIRSF_domain:PIRSF000127																	MODERATE	1	SNV	1			1											PASS	CAAGCTTCTGG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM1270556	True	Unknown
BIRC6	57448	BI	GRCh38	chr2	32499652	32499652	+	Silent	SNP	C	C	T	rs550913772	by1000G	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.8574C>T	p.=	p.A2858A	ENST00000421745	46/74	123	103	20	139			BIRC6,synonymous_variant,p.A2858A,ENST00000421745,NM_016252.3,c.8574C>T,LOW,YES,,,1;BIRC6,upstream_gene_variant,,ENST00000497023,,,MODIFIER,,,,1	T	ENSG00000115760	ENST00000421745	Transcript	synonymous_variant	synonymous_variant	8708/15703	8574/14574	2858/4857	A	gcC/gcT	rs550913772	1		1	BIRC6	HGNC	HGNC:13516	protein_coding	YES	CCDS33175.2	ENSP00000393596	Q9NR09		UPI000159689D	NM_016252.3			46/74			0.0002	0.0000	0.0000		0.0000	0.0000	0.0010										LOW	1	SNV	1			1	4.942e-05	4.943e-05	0.0002883	0	0	0	0	0	0.0001817		PASS	TCTGCCGTGAT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4093902;COSM4093903	True	Unknown
PPM1B	5495	BI	GRCh38	chr2	44232440	44232440	+	3'Flank	SNP	C	C	T	rs111545038	by1000G;byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d				ENST00000282412		13	9	4	17			PPM1B,3_prime_UTR_variant,,ENST00000378551,NM_177968.2,c.*95C>T,MODIFIER,,,,1;PPM1B,downstream_gene_variant,,ENST00000409432,NM_001033557.1,,MODIFIER,,,,1;PPM1B,downstream_gene_variant,,ENST00000282412,NM_002706.4,,MODIFIER,YES,,,1;PPM1B,downstream_gene_variant,,ENST00000345249,NM_177969.2,,MODIFIER,,,,1;PPM1B,non_coding_transcript_exon_variant,,ENST00000459690,,n.395C>T,MODIFIER,,,,1;PPM1B,intron_variant,,ENST00000378540,,n.1547-11788C>T,MODIFIER,,,,1;PPM1B,intron_variant,,ENST00000487286,,n.380-11788C>T,MODIFIER,,,,1	T	ENSG00000138032	ENST00000282412	Transcript	downstream_gene_variant	downstream_gene_variant	-/2606	-/1440	-/479			rs111545038	1	968	1	PPM1B	HGNC	HGNC:9276	protein_coding	YES	CCDS1817.1	ENSP00000282412	O75688		UPI0000130FE7	NM_002706.4						0.0006	0.0015	0.0014		0.0000	0.0000	0.0000										MODIFIER	1	SNV	1			1											PASS	TCTTGCGGATT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	gdc_pon		True	Unknown
FSHR	2492	BI	GRCh38	chr2	49154360	49154360	+	Missense_Mutation	SNP	G	G	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.58C>A	p.His20Asn	p.H20N	ENST00000406846	1/10	34	26	8	43			FSHR,missense_variant,p.H20N,ENST00000406846,NM_000145.3,c.58C>A,MODERATE,YES,tolerated(0.27),benign(0.004),-1;FSHR,missense_variant,p.H20N,ENST00000304421,NM_181446.2,c.58C>A,MODERATE,,tolerated(0.27),possibly_damaging(0.772),-1;FSHR,missense_variant,p.H20N,ENST00000454032,,c.58C>A,MODERATE,,deleterious(0.02),benign(0.306),-1;FSHR,missense_variant,p.H20N,ENST00000419927,,c.58C>A,MODERATE,,deleterious_low_confidence(0.01),possibly_damaging(0.781),-1	T	ENSG00000170820	ENST00000406846	Transcript	missense_variant	missense_variant	178/2784	58/2088	20/695	H/N	Cat/Aat		1		-1	FSHR	HGNC	HGNC:3969	protein_coding	YES	CCDS1843.1	ENSP00000384708		A0A0A0MSC5	UPI000013E97A	NM_000145.3	tolerated(0.27)	benign(0.004)	1/10		Pfam_domain:PF01462;Prints_domain:PR01143;SMART_domains:SM00013;Superfamily_domains:SSF52058																	MODERATE	1	SNV	1			1											PASS	CCGATGATGAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4094537	True	Unknown
PROKR1	10887	BI	GRCh38	chr2	68655424	68655424	+	Missense_Mutation	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1030A>G	p.Thr344Ala	p.T344A	ENST00000303786	3/3	53	47	6	79			PROKR1,missense_variant,p.T344A,ENST00000303786,,c.1030A>G,MODERATE,YES,tolerated(0.81),benign(0.001),1;APLF,missense_variant,p.T344A,ENST00000394342,NM_138964.2,c.1030A>G,MODERATE,,tolerated(0.81),benign(0.001),1;APLF,non_coding_transcript_exon_variant,,ENST00000627740,,n.1742A>G,MODIFIER,,,,1	G	ENSG00000169618	ENST00000303786	Transcript	missense_variant	missense_variant	1450/4273	1030/1182	344/393	T/A	Acc/Gcc		1		1	PROKR1	HGNC	HGNC:4524	protein_coding	YES	CCDS1889.1	ENSP00000303775	Q8TCW9		UPI000003EAA7		tolerated(0.81)	benign(0.001)	3/3		Prints_domain:PR00237;Superfamily_domains:SSF81321																	MODERATE	1	SNV	5			1											PASS	TCGTGACCGTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4095225	True	Unknown
IGKC	3514	BI	GRCh38	chr2	88992528	88992528	+	Intron	SNP	T	T	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.351+47696A>G			ENST00000614656		140	115	25	163			IGKC,missense_variant,p.S78G,ENST00000430694,,c.232A>G,MODERATE,,deleterious(0.01),benign(0.028),-1;IGKV1-8,missense_variant,p.S76G,ENST00000377423,,c.226A>G,MODERATE,YES,deleterious(0.01),benign(0.01),-1;IGKV1-8,missense_variant,p.S76G,ENST00000495489,,c.226A>G,MODERATE,,deleterious(0.01),benign(0.045),-1;IGKC,intron_variant,,ENST00000610638,,c.44+27463A>G,MODIFIER,,,,-1;IGKC,intron_variant,,ENST00000614252,,c.373+17424A>G,MODIFIER,,,,-1;IGKC,intron_variant,,ENST00000614656,,c.351+47696A>G,MODIFIER,YES,,,-1;IGKV3-11,intron_variant,,ENST00000611170,,c.341+34647A>G,MODIFIER,YES,,,-1	C	ENSG00000211592	ENST00000614656	Transcript	intron_variant	intron_variant	-/824	-/711	-/236				1		-1	IGKC	HGNC	HGNC:5716	IG_C_gene	YES		ENSP00000478196		A0A087WTX5	UPI0000D611CE					2/3																		MODIFIER		SNV				1											PASS	CCCACTTTGCA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
ST6GAL2	84620	BI	GRCh38	chr2	106843411	106843411	+	Silent	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.567C>T	p.=	p.G189G	ENST00000361686	2/6	50	31	18	79			ST6GAL2,synonymous_variant,p.G189G,ENST00000409382,NM_001142351.1,c.567C>T,LOW,YES,,,-1;ST6GAL2,synonymous_variant,p.G189G,ENST00000361686,NM_032528.2,c.567C>T,LOW,,,,-1;ST6GAL2,synonymous_variant,p.G189G,ENST00000409087,NM_001142352.1,c.567C>T,LOW,,,,-1;ST6GAL2,downstream_gene_variant,,ENST00000419159,,,MODIFIER,,,,-1;AC016994.2,downstream_gene_variant,,ENST00000425419,,,MODIFIER,YES,,,1	A	ENSG00000144057	ENST00000361686	Transcript	synonymous_variant	synonymous_variant	756/6857	567/1590	189/529	G	ggC/ggT		1		-1	ST6GAL2	HGNC	HGNC:10861	protein_coding		CCDS2073.1	ENSP00000355273	Q96JF0			NM_032528.2			2/6																			LOW		SNV	1			1											PASS	TCGTCGCCCTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4084002;COSM4084003	True	Unknown
LRP1B	53353	BI	GRCh38	chr2	141055233	141055233	+	Missense_Mutation	SNP	G	G	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1435C>G	p.Pro479Ala	p.P479A	ENST00000389484	10/91	22	12	10	56			LRP1B,missense_variant,p.P479A,ENST00000389484,NM_018557.2,c.1435C>G,MODERATE,YES,,possibly_damaging(0.539),-1;LRP1B,missense_variant,p.P365A,ENST00000618808,,c.1093C>G,MODERATE,,,possibly_damaging(0.539),-1;LRP1B,intron_variant,,ENST00000434794,,c.206-72957C>G,MODIFIER,,,,-1	C	ENSG00000168702	ENST00000389484	Transcript	missense_variant	missense_variant	2407/16535	1435/13800	479/4599	P/A	Cca/Gca		1		-1	LRP1B	HGNC	HGNC:6693	protein_coding	YES	CCDS2182.1	ENSP00000374135	Q9NZR2		UPI00001B045B	NM_018557.2		possibly_damaging(0.539)	10/91		SMART_domains:SM00181;Superfamily_domains:SSF57184																	MODERATE	1	SNV	1			1											PASS	ATATGGATCGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4085225	True	Unknown
ZEB2	9839	BI	GRCh38	chr2	144396584	144396584	+	Missense_Mutation	SNP	C	C	A	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2895G>T	p.Leu965Phe	p.L965F	ENST00000409487	9/10	28	24	4	25			ZEB2,missense_variant,p.L965F,ENST00000627532,NM_014795.3,c.2895G>T,MODERATE,YES,deleterious(0.03),probably_damaging(0.916),-1;ZEB2,missense_variant,p.L965F,ENST00000409487,,c.2895G>T,MODERATE,,deleterious(0.03),probably_damaging(0.916),-1;ZEB2,missense_variant,p.L941F,ENST00000539609,NM_001171653.1,c.2823G>T,MODERATE,,deleterious(0.03),probably_damaging(0.934),-1;ZEB2,missense_variant,p.L965F,ENST00000558170,,c.2895G>T,MODERATE,,deleterious(0.03),probably_damaging(0.916),-1;ZEB2,missense_variant,p.L964F,ENST00000303660,,c.2892G>T,MODERATE,,deleterious(0.03),possibly_damaging(0.897),-1;ZEB2,intron_variant,,ENST00000419938,,c.655+4615G>T,MODIFIER,,,,-1;ZEB2,downstream_gene_variant,,ENST00000427902,,,MODIFIER,,,,-1;ZEB2,downstream_gene_variant,,ENST00000440875,,,MODIFIER,,,,-1;ZEB2,downstream_gene_variant,,ENST00000392861,,,MODIFIER,,,,-1	A	ENSG00000169554	ENST00000409487	Transcript	missense_variant	missense_variant	3178/5361	2895/3645	965/1214	L/F	ttG/ttT		1		-1	ZEB2	HGNC	HGNC:14881	protein_coding		CCDS2186.1	ENSP00000386854	O60315		UPI00001359A2		deleterious(0.03)	probably_damaging(0.916)	9/10																			MODERATE		SNV	5			1											PASS	TCAAGCAATTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
SCN9A	6335	BI	GRCh38	chr2	166199455	166199455	+	Silent	SNP	T	T	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.5184A>G	p.=	p.G1728G	ENST00000303354	27/27	291	240	51	289			SCN9A,synonymous_variant,p.G1728G,ENST00000303354,,c.5184A>G,LOW,,,,-1;SCN9A,synonymous_variant,p.G1717G,ENST00000409672,NM_002977.3,c.5151A>G,LOW,YES,,,-1;SCN9A,synonymous_variant,p.G1728G,ENST00000409435,,c.5184A>G,LOW,,,,-1;AC010127.3,intron_variant,,ENST00000447809,,n.432-184T>C,MODIFIER,YES,,,1	C	ENSG00000169432	ENST00000303354	Transcript	synonymous_variant	synonymous_variant	5525/9786	5184/5967	1728/1988	G	ggA/ggG		1		-1	SCN9A	HGNC	HGNC:10597	protein_coding			ENSP00000304748	Q15858		UPI0001881757				27/27		Pfam_domain:PF00520;Pfam_domain:PF08016;Superfamily_domains:SSF81324																	LOW		SNV	5			1											PASS	CAGTCTCCTTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
TTN	7273	BI	GRCh38	chr2	178542666	178542666	+	Silent	SNP	A	A	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.92265T>A	p.=	p.I30755I	ENST00000591111	298/313	167	110	56	219			TTN,synonymous_variant,p.I32396I,ENST00000589042,NM_001267550.1,c.97188T>A,LOW,YES,,,-1;TTN,synonymous_variant,p.I30755I,ENST00000591111,,c.92265T>A,LOW,,,,-1;TTN,synonymous_variant,p.I30755I,ENST00000615779,NM_001256850.1,c.92265T>A,LOW,,,,-1;TTN,synonymous_variant,p.I29828I,ENST00000342992,NM_133378.4,c.89484T>A,LOW,,,,-1;TTN,synonymous_variant,p.I23523I,ENST00000342175,NM_133437.3,c.70569T>A,LOW,,,,-1;TTN,synonymous_variant,p.I23456I,ENST00000359218,NM_133432.3,c.70368T>A,LOW,,,,-1;TTN,synonymous_variant,p.I23331I,ENST00000460472,NM_003319.4,c.69993T>A,LOW,,,,-1;TTN-AS1,intron_variant,,ENST00000419746,,n.2043+305A>T,MODIFIER,YES,,,1;TTN-AS1,intron_variant,,ENST00000456053,,n.413+19030A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000627564,,n.377+305A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000585451,,n.198+19030A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000630096,,n.551+13853A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000626954,,n.74+13853A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000590040,,n.486-150A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000586707,,n.345+19030A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000586452,,n.74+13853A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000592689,,n.462+305A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000592600,,n.345+19030A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000590807,,n.74+13853A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000586831,,n.214+305A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000590932,,n.615+305A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000625536,,n.21+4975A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000626138,,n.49+13853A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000592630,,n.433+4975A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000628826,,n.49+13853A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000625480,,n.49+13853A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000592750,,n.345+19030A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000626117,,n.74+13853A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000591332,,n.442+6838A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000628296,,n.49+13853A>T,MODIFIER,,,,1;TTN-AS1,intron_variant,,ENST00000438095,,n.194+305A>T,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000431259,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000588804,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000625661,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000589434,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000589391,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000620591,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000585358,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000585487,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000592182,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000588244,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000450692,,,MODIFIER,,,,1;RP11-65L3.4,downstream_gene_variant,,ENST00000604692,,,MODIFIER,YES,,,1;TTN-AS1,downstream_gene_variant,,ENST00000588716,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000592836,,,MODIFIER,,,,1;TTN-AS1,downstream_gene_variant,,ENST00000415561,,,MODIFIER,,,,1	T	ENSG00000155657	ENST00000591111	Transcript	synonymous_variant	synonymous_variant	92490/104301	92265/103053	30755/34350	I	atT/atA		1		-1	TTN	HGNC	HGNC:12403	protein_coding			ENSP00000465570	Q8WZ42		UPI00025287CD				298/313		Pfam_domain:PF07679;SMART_domains:SM00409;Superfamily_domains:SSF49758;Superfamily_domains:SSF49265;Superfamily_domains:SSF48726;Superfamily_domains:SSF88633;Superfamily_domains:SSF50729;Superfamily_domains:SSF53300;Superfamily_domains:SSF53098;Superfamily_domains:SSF53300;Superfamily_domains:SSF88633																	LOW		SNV	5			1											PASS	CCAAGAATGAT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4087374;COSM4087375;COSM4087376;COSM4087377	True	Unknown
ZDBF2	57683	BI	GRCh38	chr2	206309579	206309579	+	Missense_Mutation	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.5051A>G	p.His1684Arg	p.H1684R	ENST00000374423	5/5	63	40	23	58			ZDBF2,missense_variant,p.H1684R,ENST00000374423,NM_020923.2,c.5051A>G,MODERATE,YES,tolerated(0.13),benign(0),1;ZDBF2,missense_variant,p.H1682R,ENST00000611847,NM_001285549.1,c.5045A>G,MODERATE,,tolerated(0.13),benign(0),1	G	ENSG00000204186	ENST00000374423	Transcript	missense_variant	missense_variant	5437/10286	5051/7065	1684/2354	H/R	cAc/cGc		1		1	ZDBF2	HGNC	HGNC:29313	protein_coding	YES	CCDS46501.1	ENSP00000363545	Q9HCK1	N0DVB2	UPI000022BDE3	NM_020923.2	tolerated(0.13)	benign(0)	5/5																			MODERATE	1	SNV	1			1											PASS	AGCTCACAAAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4090548;COSM4090549	True	Unknown
FANCD2	2177	BI	GRCh38	chr3	10046721	10046721	+	Splice_Region	SNP	T	T	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1276T>C	p.=	p.L426L	ENST00000383807	15/44	47	32	15	56			FANCD2,splice_region_variant,p.L426L,ENST00000287647,NM_033084.3,c.1276T>C,LOW,YES,,,1;FANCD2,splice_region_variant,p.L426L,ENST00000419585,,c.1276T>C,LOW,,,,1;FANCD2,splice_region_variant,p.L426L,ENST00000383807,NM_001018115.1,c.1276T>C,LOW,,,,1;FANCD2,splice_region_variant,,ENST00000483276,,n.360T>C,LOW,,,,1;FANCD2,splice_region_variant,,ENST00000464934,,n.295T>C,LOW,,,,1;FANCD2,upstream_gene_variant,,ENST00000421731,,,MODIFIER,,,,1	C	ENSG00000144554	ENST00000383807	Transcript	splice_region_variant	splice_region_variant;synonymous_variant	1354/5102	1276/4356	426/1451	L	Tta/Cta		1		1	FANCD2	HGNC	HGNC:3585	protein_coding		CCDS33696.1	ENSP00000373318	Q9BXW9	A0A024R2G2	UPI000006CD51	NM_001018115.1			15/44		Superfamily_domains:SSF48371																	LOW		SNV	1			1											PASS	ATTACTTAGTA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
FBLN2	2199	BI	GRCh38	chr3	13618133	13618133	+	Missense_Mutation	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1787T>C	p.Leu596Pro	p.L596P	ENST00000295760	6/17	144	102	42	162			FBLN2,missense_variant,p.L596P,ENST00000404922,NM_001004019.1,c.1787T>C,MODERATE,YES,tolerated(0.27),probably_damaging(0.996),1;FBLN2,missense_variant,p.L596P,ENST00000492059,NM_001165035.1,c.1787T>C,MODERATE,,tolerated(0.27),probably_damaging(0.996),1;FBLN2,missense_variant,p.L596P,ENST00000295760,NM_001998.2,c.1787T>C,MODERATE,,tolerated(0.24),probably_damaging(0.934),1;FBLN2,non_coding_transcript_exon_variant,,ENST00000477845,,n.325T>C,MODIFIER,,,,1	C	ENSG00000163520	ENST00000295760	Transcript	missense_variant	missense_variant	1856/4127	1787/3555	596/1184	L/P	cTg/cCg		1		1	FBLN2	HGNC	HGNC:3601	protein_coding		CCDS46762.1	ENSP00000295760	P98095		UPI000042B0C2	NM_001998.2	tolerated(0.24)	probably_damaging(0.934)	6/17																			MODERATE		SNV	1			1											PASS	CGAGCTGCCGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4113868;COSM4113869	True	Unknown
POMGNT2	84892	BI	GRCh38	chr3	43081317	43081317	+	Missense_Mutation	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.115A>G	p.Ser39Gly	p.S39G	ENST00000344697	2/2	34	30	4	36			POMGNT2,missense_variant,p.S39G,ENST00000344697,NM_032806.5,c.115A>G,MODERATE,YES,tolerated_low_confidence(0.5),benign(0),-1;POMGNT2,missense_variant,p.S39G,ENST00000441964,,c.115A>G,MODERATE,,tolerated_low_confidence(0.5),benign(0),-1	C	ENSG00000144647	ENST00000344697	Transcript	missense_variant	missense_variant	461/2544	115/1743	39/580	S/G	Agc/Ggc		1		-1	POMGNT2	HGNC	HGNC:25902	protein_coding	YES	CCDS2709.1	ENSP00000344125	Q8NAT1	A0A024R2P4	UPI0000037921	NM_032806.5	tolerated_low_confidence(0.5)	benign(0)	2/2		Low_complexity_(Seg):Seg																	MODERATE	1	SNV	1			1											PASS	TCGGCTGAGGG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4117684	True	Unknown
GRM2	2912	BI	GRCh38	chr3	51713043	51713043	+	Missense_Mutation	SNP	C	C	T	rs534825087	by1000G	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1021C>T	p.Arg341Trp	p.R341W	ENST00000395052	3/6	22	14	8	35			GRM2,missense_variant,p.R341W,ENST00000395052,NM_000839.3,c.1021C>T,MODERATE,YES,deleterious(0.01),probably_damaging(1),1;GRM2,missense_variant,p.R341W,ENST00000442933,,c.1021C>T,MODERATE,,deleterious(0.01),benign(0.243),1;GRM2,downstream_gene_variant,,ENST00000419928,,,MODIFIER,,,,1;GRM2,non_coding_transcript_exon_variant,,ENST00000496661,,n.1019C>T,MODIFIER,,,,1;GRM2,intron_variant,,ENST00000475478,,n.79-2019C>T,MODIFIER,,,,1;GRM2,downstream_gene_variant,,ENST00000477330,,,MODIFIER,,,,1;GRM2,missense_variant,p.R341W,ENST00000296479,,c.1021C>T,MODERATE,,deleterious(0.01),benign(0.216),1;GRM2,non_coding_transcript_exon_variant,,ENST00000464585,,n.2700C>T,MODIFIER,,,,1	T	ENSG00000164082	ENST00000395052	Transcript	missense_variant	missense_variant	1255/3151	1021/2619	341/872	R/W	Cgg/Tgg	rs534825087	1		1	GRM2	HGNC	HGNC:4594	protein_coding	YES	CCDS2834.1	ENSP00000378492	Q14416		UPI000013E346	NM_000839.3	deleterious(0.01)	probably_damaging(1)	3/6		Pfam_domain:PF01094;Superfamily_domains:SSF53822		0.0000	0.0000		0.0000	0.0000	0.0010										MODERATE	1	SNV	2			1	6.592e-05	6.686e-05	0	0	0	0	4.595e-05	0	0.0003029		PASS	ACAGCCGGAAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4118886	True	Unknown
PXK	54899	BI	GRCh38	chr3	58397056	58397056	+	Silent	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.840T>C	p.=	p.H280H	ENST00000356151	10/18	94	56	38	87			PXK,synonymous_variant,p.H280H,ENST00000383716,NM_001289098.1,c.840T>C,LOW,,,,1;PXK,synonymous_variant,p.H247H,ENST00000463280,NM_001289101.1&NM_001289100.1,c.741T>C,LOW,,,,1;PXK,synonymous_variant,p.H263H,ENST00000479241,NM_001289095.1,c.789T>C,LOW,,,,1;PXK,synonymous_variant,p.H280H,ENST00000356151,NM_001289099.1&NM_001289096.1&NM_017771.4,c.840T>C,LOW,YES,,,1;PXK,synonymous_variant,p.H280H,ENST00000484288,,c.840T>C,LOW,,,,1;PXK,synonymous_variant,p.H280H,ENST00000302779,,c.840T>C,LOW,,,,1;PXK,synonymous_variant,p.H35H,ENST00000479134,,c.104T>C,LOW,,,,1;PXK,synonymous_variant,p.H263H,ENST00000383715,,c.789T>C,LOW,,,,1;PXK,upstream_gene_variant,,ENST00000459676,,,MODIFIER,,,,1;PXK,3_prime_UTR_variant,,ENST00000468776,,c.*383T>C,MODIFIER,,,,1;PXK,3_prime_UTR_variant,,ENST00000477308,,c.*187T>C,MODIFIER,,,,1	C	ENSG00000168297	ENST00000356151	Transcript	synonymous_variant	synonymous_variant	949/2037	840/1737	280/578	H	caT/caC		1		1	PXK	HGNC	HGNC:23326	protein_coding	YES	CCDS2889.1	ENSP00000348472	Q7Z7A4		UPI000004A035	NM_001289099.1;NM_001289096.1;NM_017771.4			10/18		Pfam_domain:PF00069;Pfam_domain:PF07714;PROSITE_profiles:PS50011;Superfamily_domains:SSF56112																	LOW	1	SNV	1			1											PASS	CTTCATGACAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4119664	True	Unknown
ROBO1	6091	BI	GRCh38	chr3	79125477	79125477	+	Missense_Mutation	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.151G>A	p.Asp51Asn	p.D51N	ENST00000464233	3/31	31	24	7	38			ROBO1,missense_variant,p.D51N,ENST00000464233,NM_002941.3,c.151G>A,MODERATE,YES,tolerated_low_confidence(0.2),possibly_damaging(0.483),-1	T	ENSG00000169855	ENST00000464233	Transcript	missense_variant	missense_variant	265/6742	151/4956	51/1651	D/N	Gac/Aac		1		-1	ROBO1	HGNC	HGNC:10249	protein_coding	YES	CCDS54611.1	ENSP00000420321	Q9Y6N7		UPI00000713D9	NM_002941.3	tolerated_low_confidence(0.2)	possibly_damaging(0.483)	3/31																			MODERATE	1	SNV	5			1											PASS	ATTGTCATCGT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4120391;COSM4120392;COSM4120393	True	Unknown
IMPG2	50939	BI	GRCh38	chr3	101232966	101232966	+	Silent	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.3048T>C	p.=	p.F1016F	ENST00000193391	15/19	100	68	32	68			IMPG2,synonymous_variant,p.F1016F,ENST00000193391,NM_016247.3,c.3048T>C,LOW,YES,,,-1	G	ENSG00000081148	ENST00000193391	Transcript	synonymous_variant	synonymous_variant	3236/8337	3048/3726	1016/1241	F	ttT/ttC		1		-1	IMPG2	HGNC	HGNC:18362	protein_coding	YES	CCDS2940.1	ENSP00000193391	Q9BZV3	F1T0J3	UPI000013C605	NM_016247.3			15/19		PROSITE_profiles:PS50026																	LOW	1	SNV	1			1											PASS	GCCTGAAACTT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4111838	True	Unknown
NXPE3	91775	BI	GRCh38	chr3	101821810	101821810	+	Missense_Mutation	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1536G>A	p.Met512Ile	p.M512I	ENST00000273347	8/8	166	133	33	151			NXPE3,missense_variant,p.M512I,ENST00000422132,,c.1536G>A,MODERATE,YES,tolerated(0.33),probably_damaging(0.985),1;NXPE3,missense_variant,p.M512I,ENST00000491511,NM_001134456.1,c.1536G>A,MODERATE,,tolerated(0.33),probably_damaging(0.985),1;NXPE3,missense_variant,p.M512I,ENST00000273347,NM_145037.2,c.1536G>A,MODERATE,,tolerated(0.33),probably_damaging(0.985),1;NXPE3,missense_variant,p.M512I,ENST00000477909,,c.1536G>A,MODERATE,,tolerated(0.33),probably_damaging(0.985),1;NXPE3,3_prime_UTR_variant,,ENST00000616286,,c.*401G>A,MODIFIER,,,,1;RP11-49I4.3,downstream_gene_variant,,ENST00000490324,,,MODIFIER,YES,,,-1	A	ENSG00000144815	ENST00000273347	Transcript	missense_variant	missense_variant	2128/3941	1536/1680	512/559	M/I	atG/atA		1		1	NXPE3	HGNC	HGNC:28238	protein_coding		CCDS2945.1	ENSP00000273347	Q969Y0			NM_145037.2	tolerated(0.33)	probably_damaging(0.985)	8/8																			MODERATE		SNV	1			1											PASS	AGGATGTTCTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4111940	True	Unknown
KIAA1407	57577	BI	GRCh38	chr3	114042810	114042810	+	Missense_Mutation	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.308T>C	p.Leu103Pro	p.L103P	ENST00000295878	4/17	121	99	22	75			KIAA1407,missense_variant,p.L103P,ENST00000295878,NM_020817.1,c.308T>C,MODERATE,YES,deleterious(0),probably_damaging(0.996),-1;KIAA1407,missense_variant,p.L90P,ENST00000491000,,c.269T>C,MODERATE,,deleterious(0),probably_damaging(0.992),-1;KIAA1407,missense_variant,p.L67P,ENST00000483766,,c.200T>C,MODERATE,,deleterious(0),probably_damaging(0.995),-1;QTRTD1,intron_variant,,ENST00000472599,,c.22-22427A>G,MODIFIER,,,,1;KIAA1407,non_coding_transcript_exon_variant,,ENST00000480588,,n.443T>C,MODIFIER,,,,-1;KIAA1407,3_prime_UTR_variant,,ENST00000460813,,c.*18T>C,MODIFIER,,,,-1;KIAA1407,3_prime_UTR_variant,,ENST00000463695,,c.*10T>C,MODIFIER,,,,-1;KIAA1407,non_coding_transcript_exon_variant,,ENST00000481358,,n.200T>C,MODIFIER,,,,-1	G	ENSG00000163617	ENST00000295878	Transcript	missense_variant	missense_variant	455/3976	308/2811	103/936	L/P	cTt/cCt		1		-1	KIAA1407	HGNC	HGNC:29272	protein_coding	YES	CCDS2977.1	ENSP00000295878	Q8NCU4		UPI00000732E9	NM_020817.1	deleterious(0)	probably_damaging(0.996)	4/17																			MODERATE	1	SNV	1			1											PASS	GCTTAAGTTTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4112388	True	Unknown
FSTL1	11167	BI	GRCh38	chr3	120396982	120396982	+	Missense_Mutation	SNP	C	C	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.897G>T	p.Lys299Asn	p.K299N	ENST00000295633	11/11	183	131	52	129			FSTL1,missense_variant,p.K299N,ENST00000295633,NM_007085.4,c.897G>T,MODERATE,YES,deleterious_low_confidence(0.04),benign(0.027),-1;FSTL1,missense_variant,p.K264N,ENST00000424703,,c.792G>T,MODERATE,,deleterious_low_confidence(0.04),benign(0.062),-1;FSTL1,intron_variant,,ENST00000480823,,c.57-9G>T,MODIFIER,,,,-1;FSTL1,non_coding_transcript_exon_variant,,ENST00000488318,,n.222G>T,MODIFIER,,,,-1	A	ENSG00000163430	ENST00000295633	Transcript	missense_variant	missense_variant	1254/5943	897/927	299/308	K/N	aaG/aaT		1		-1	FSTL1	HGNC	HGNC:3972	protein_coding	YES	CCDS2998.1	ENSP00000295633	Q12841		UPI00000422DB	NM_007085.4	deleterious_low_confidence(0.04)	benign(0.027)	11/11		Coiled-coils_(Ncoils):ncoils																	MODERATE	1	SNV	1			1											PASS	TTGGTCTTTTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4112599	True	Unknown
HSPBAP1	79663	BI	GRCh38	chr3	122740607	122740607	+	Missense_Mutation	SNP	G	G	A	rs371225480	byCluster;byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1205C>T	p.Pro402Leu	p.P402L	ENST00000306103	8/8	215	187	28	136			HSPBAP1,missense_variant,p.P402L,ENST00000306103,NM_024610.5,c.1205C>T,MODERATE,YES,tolerated(0.19),benign(0.004),-1;HSPBAP1,non_coding_transcript_exon_variant,,ENST00000471534,,n.1043C>T,MODIFIER,,,,-1	A	ENSG00000169087	ENST00000306103	Transcript	missense_variant	missense_variant	1349/1953	1205/1467	402/488	P/L	cCg/cTg	rs371225480	1		-1	HSPBAP1	HGNC	HGNC:16389	protein_coding	YES	CCDS3017.1	ENSP00000302562	Q96EW2		UPI00000715E9	NM_024610.5	tolerated(0.19)	benign(0.004)	8/8										0.0005	0								MODERATE	1	SNV	1			1	1.647e-05	1.647e-05	0.0001923	0	0	0	0	0	0		PASS	AAGGCGGTTCT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	gdc_pon	COSM4112798	True	Unknown
PLXND1	23129	BI	GRCh38	chr3	129558564	129558564	+	Missense_Mutation	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.5309G>A	p.Arg1770Gln	p.R1770Q	ENST00000324093	33/36	85	69	16	66			PLXND1,missense_variant,p.R1770Q,ENST00000324093,NM_015103.2,c.5309G>A,MODERATE,YES,deleterious(0),probably_damaging(0.917),-1;PLXND1,missense_variant,p.R114Q,ENST00000506979,,c.339G>A,MODERATE,,deleterious(0),benign(0.26),-1;PLXND1,upstream_gene_variant,,ENST00000504689,,,MODIFIER,,,,-1;PLXND1,synonymous_variant,p.P367P,ENST00000512744,,c.1099G>A,LOW,,,,-1;PLXND1,non_coding_transcript_exon_variant,,ENST00000504524,,n.134G>A,MODIFIER,,,,-1;PLXND1,non_coding_transcript_exon_variant,,ENST00000508630,,n.535G>A,MODIFIER,,,,-1;PLXND1,upstream_gene_variant,,ENST00000501038,,,MODIFIER,,,,-1;PLXND1,downstream_gene_variant,,ENST00000512807,,,MODIFIER,,,,-1;PLXND1,downstream_gene_variant,,ENST00000503166,,,MODIFIER,,,,-1;PLXND1,downstream_gene_variant,,ENST00000504979,,,MODIFIER,,,,-1	T	ENSG00000004399	ENST00000324093	Transcript	missense_variant	missense_variant	5488/7094	5309/5778	1770/1925	R/Q	cGg/cAg		1		-1	PLXND1	HGNC	HGNC:9107	protein_coding	YES	CCDS33854.1	ENSP00000317128	Q9Y4D7		UPI00003671AD	NM_015103.2	deleterious(0)	probably_damaging(0.917)	33/36		Pfam_domain:PF08337;Superfamily_domains:SSF48350																	MODERATE	1	SNV	1			1											PASS	AGAACCGGAGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4113355;COSM4113356	True	Unknown
COL6A5	256076	BI	GRCh38	chr3	130468921	130468921	+	Missense_Mutation	SNP	A	A	T	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.6917A>T	p.Glu2306Val	p.E2306V	ENST00000312481	38/42	38	30	8	19			COL6A5,missense_variant,p.E2302V,ENST00000265379,NM_153264.6&NM_001278298.1,c.6905A>T,MODERATE,YES,deleterious(0.02),benign(0.331),1;COL6A5,missense_variant,p.E558V,ENST00000512836,,c.1671A>T,MODERATE,,tolerated(0.15),benign(0.331),1;COL6A5,missense_variant,p.E141V,ENST00000512482,,c.422A>T,MODERATE,,deleterious(0.02),possibly_damaging(0.549),1;COL6A5,missense_variant,p.E249V,ENST00000373157,,c.746A>T,MODERATE,,deleterious(0.02),possibly_damaging(0.465),1;COL6A5,missense_variant,p.E2306V,ENST00000312481,,c.6917A>T,MODERATE,,deleterious(0.02),benign(0.364),1	T	ENSG00000172752	ENST00000312481	Transcript	missense_variant	missense_variant;NMD_transcript_variant	7411/9226	6917/7848	2306/2615	E/V	gAg/gTg		1		1	COL6A5	HGNC	HGNC:26674	nonsense_mediated_decay			ENSP00000309762	A8TX70		UPI00015E564F		deleterious(0.02)	benign(0.364)	38/42		Pfam_domain:PF00092;PROSITE_profiles:PS50234;SMART_domains:SM00327;Superfamily_domains:SSF53300																	MODERATE		SNV	1			1											PASS	TGATGAGTTTA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
COL6A6	131873	BI	GRCh38	chr3	130635703	130635703	+	Missense_Mutation	SNP	A	A	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.5033A>T	p.Glu1678Val	p.E1678V	ENST00000358511	27/36	37	32	5	31			COL6A6,missense_variant,p.E1678V,ENST00000358511,NM_001102608.1,c.5033A>T,MODERATE,YES,tolerated(0.06),possibly_damaging(0.634),1;COL6A6,3_prime_UTR_variant,,ENST00000506143,,c.*546A>T,MODIFIER,,,,1	T	ENSG00000206384	ENST00000358511	Transcript	missense_variant	missense_variant	5064/9581	5033/6792	1678/2263	E/V	gAg/gTg		1		1	COL6A6	HGNC	HGNC:27023	protein_coding	YES	CCDS46911.1	ENSP00000351310	A6NMZ7		UPI00015B6548	NM_001102608.1	tolerated(0.06)	possibly_damaging(0.634)	27/36		PROSITE_profiles:PS50315																	MODERATE	1	SNV	5			1											PASS	GGGTGAGATTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4113509;COSM4113510	True	Unknown
DZIP1L	199221	BI	GRCh38	chr3	138103857	138103857	+	Missense_Mutation	SNP	T	T	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.115A>C	p.Ser39Arg	p.S39R	ENST00000327532	2/16	247	112	135	192			DZIP1L,missense_variant,p.S39R,ENST00000327532,NM_173543.2,c.115A>C,MODERATE,YES,deleterious(0),probably_damaging(0.911),-1;DZIP1L,missense_variant,p.S39R,ENST00000469243,NM_001170538.1,c.115A>C,MODERATE,,deleterious(0),probably_damaging(0.945),-1;DZIP1L,missense_variant,p.S39R,ENST00000492010,,c.115A>C,MODERATE,,deleterious_low_confidence(0),probably_damaging(0.911),-1;DZIP1L,missense_variant,p.S39R,ENST00000467030,,c.115A>C,MODERATE,,deleterious(0),probably_damaging(0.911),-1;AC023049.1,downstream_gene_variant,,ENST00000626774,,,MODIFIER,YES,,,1;DZIP1L,upstream_gene_variant,,ENST00000490472,,,MODIFIER,,,,-1;KRT8P36,upstream_gene_variant,,ENST00000489121,,,MODIFIER,YES,,,-1	G	ENSG00000158163	ENST00000327532	Transcript	missense_variant	missense_variant	478/3493	115/2304	39/767	S/R	Agc/Cgc		1		-1	DZIP1L	HGNC	HGNC:26551	protein_coding	YES	CCDS3096.1	ENSP00000332148	Q8IYY4		UPI0000161A66	NM_173543.2	deleterious(0)	probably_damaging(0.911)	2/16																			MODERATE	1	SNV	1			1											PASS	GGTGCTAATGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4113915;COSM4113916	True	Unknown
PAQR9	344838	BI	GRCh38	chr3	142963071	142963071	+	Missense_Mutation	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.266C>T	p.Thr89Met	p.T89M	ENST00000340634	1/1	64	35	29	24			PAQR9,missense_variant,p.T89M,ENST00000340634,NM_198504.2,c.266C>T,MODERATE,YES,deleterious(0),probably_damaging(0.998),-1;PAQR9,upstream_gene_variant,,ENST00000492509,,,MODIFIER,,,,-1;U2SURP,upstream_gene_variant,,ENST00000600150,,,MODIFIER,,,,1;PAQR9,upstream_gene_variant,,ENST00000498470,,,MODIFIER,,,,-1;PAQR9-AS1,non_coding_transcript_exon_variant,,ENST00000594095,,n.118G>A,MODIFIER,,,,1;PAQR9-AS1,non_coding_transcript_exon_variant,,ENST00000608686,,n.117G>A,MODIFIER,,,,1;PAQR9-AS1,intron_variant,,ENST00000627207,,n.521-1394G>A,MODIFIER,,,,1;PAQR9-AS1,intron_variant,,ENST00000625937,,n.240+449G>A,MODIFIER,,,,1;PAQR9-AS1,upstream_gene_variant,,ENST00000595248,,,MODIFIER,YES,,,1;PAQR9-AS1,upstream_gene_variant,,ENST00000595774,,,MODIFIER,,,,1;PAQR9-AS1,upstream_gene_variant,,ENST00000598139,,,MODIFIER,,,,1;PAQR9-AS1,upstream_gene_variant,,ENST00000593321,,,MODIFIER,,,,1;PAQR9-AS1,upstream_gene_variant,,ENST00000478823,,,MODIFIER,,,,1;PAQR9-AS1,upstream_gene_variant,,ENST00000493825,,,MODIFIER,,,,1;PAQR9-AS1,upstream_gene_variant,,ENST00000625677,,,MODIFIER,,,,1;PAQR9-AS1,upstream_gene_variant,,ENST00000497652,,,MODIFIER,,,,1;PAQR9-AS1,upstream_gene_variant,,ENST00000598787,,,MODIFIER,,,,1;PAQR9-AS1,upstream_gene_variant,,ENST00000607937,,,MODIFIER,,,,1;PAQR9-AS1,upstream_gene_variant,,ENST00000608349,,,MODIFIER,,,,1;RP11-372E1.7,downstream_gene_variant,,ENST00000468434,,,MODIFIER,YES,,,1	A	ENSG00000188582	ENST00000340634	Transcript	missense_variant	missense_variant	612/2452	266/1134	89/377	T/M	aCg/aTg		1		-1	PAQR9	HGNC	HGNC:30131	protein_coding	YES	CCDS3128.1	ENSP00000341564	Q6ZVX9		UPI00000620A1	NM_198504.2	deleterious(0)	probably_damaging(0.998)	1/1		Pfam_domain:PF03006;Transmembrane_helices:Tmhmm																	MODERATE		SNV				1											PASS	AGTGCGTCCAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4114180	True	Unknown
USP13	8975	BI	GRCh38	chr3	179742319	179742319	+	Missense_Mutation	SNP	A	A	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1503A>T	p.Leu501Phe	p.L501F	ENST00000263966	12/21	78	41	37	61			USP13,missense_variant,p.L501F,ENST00000263966,NM_003940.2,c.1503A>T,MODERATE,YES,deleterious(0),probably_damaging(1),1;USP13,missense_variant,p.L436F,ENST00000496897,,c.1308A>T,MODERATE,,deleterious(0),probably_damaging(1),1;USP13,missense_variant,p.L147F,ENST00000497155,,c.441A>T,MODERATE,,deleterious(0),probably_damaging(0.997),1;USP13,non_coding_transcript_exon_variant,,ENST00000482333,,n.1679A>T,MODIFIER,,,,1	T	ENSG00000058056	ENST00000263966	Transcript	missense_variant	missense_variant	1974/8323	1503/2592	501/863	L/F	ttA/ttT		1		1	USP13	HGNC	HGNC:12611	protein_coding	YES	CCDS3235.1	ENSP00000263966	Q92995	A0A0A6YZ17	UPI000006DC10	NM_003940.2	deleterious(0)	probably_damaging(1)	12/21		Pfam_domain:PF00443;PROSITE_profiles:PS50235;Superfamily_domains:SSF54001;PIRSF_domain:PIRSF016308																	MODERATE	1	SNV	1			1											PASS	CAGTTACCTGT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4115486	True	Unknown
ANK2	287	BI	GRCh38	chr4	113373415	113373415	+	Missense_Mutation	SNP	G	G	A	rs542400709	byCluster;byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.11825G>A	p.Arg3942His	p.R3942H	ENST00000357077	45/46	128	108	20	132			ANK2,missense_variant,p.R3942H,ENST00000357077,NM_001148.4,c.11825G>A,MODERATE,YES,,probably_damaging(1),1;ANK2,missense_variant,p.R3909H,ENST00000264366,,c.11726G>A,MODERATE,,,probably_damaging(0.999),1;ANK2,missense_variant,p.R1848H,ENST00000506722,NM_001127493.1,c.5543G>A,MODERATE,,deleterious_low_confidence(0),possibly_damaging(0.703),1;ANK2,missense_variant,p.R1857H,ENST00000394537,NM_020977.3,c.5570G>A,MODERATE,,deleterious_low_confidence(0),benign(0.294),1;ANK2,missense_variant,p.R952H,ENST00000505342,,c.2855G>A,MODERATE,,deleterious(0),probably_damaging(0.999),1;ANK2,missense_variant,p.R890H,ENST00000514960,,c.2667G>A,MODERATE,,deleterious_low_confidence(0),probably_damaging(0.999),1;ANK2,missense_variant,p.R1033H,ENST00000509550,,c.3098G>A,MODERATE,,deleterious_low_confidence(0),probably_damaging(0.973),1;ANK2,missense_variant,p.R540H,ENST00000510275,,c.1619G>A,MODERATE,,deleterious(0),probably_damaging(1),1;ANK2,missense_variant,p.R34H,ENST00000506344,,c.99G>A,MODERATE,,deleterious(0),probably_damaging(0.925),1;ANK2,missense_variant,p.R20H,ENST00000514167,,c.57G>A,MODERATE,,deleterious_low_confidence(0.01),probably_damaging(0.928),1;ANK2,3_prime_UTR_variant,,ENST00000612754,,c.*3186G>A,MODIFIER,,,,1	A	ENSG00000145362	ENST00000357077	Transcript	missense_variant	missense_variant	11878/14196	11825/11874	3942/3957	R/H	cGt/cAt	rs542400709	1		1	ANK2	HGNC	HGNC:493	protein_coding	YES	CCDS3702.1	ENSP00000349588	Q01484		UPI0000441EF3	NM_001148.4		probably_damaging(1)	45/46																			MODERATE	1	SNV	1			1	2.471e-05	2.474e-05	0	0.0002592	0	0	0	0	0		PASS	AAAGCGTGTTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4121497;COSM4121498	True	Unknown
PDGFC	56034	BI	GRCh38	chr4	156850337	156850337	+	Silent	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.198T>G	p.=	p.T66T	ENST00000502773	2/6	33	27	6	52			PDGFC,synonymous_variant,p.T66T,ENST00000502773,NM_016205.2,c.198T>G,LOW,YES,,,-1;PDGFC,synonymous_variant,p.T66T,ENST00000422544,,c.198T>G,LOW,,,,-1;PDGFC,non_coding_transcript_exon_variant,,ENST00000512711,,n.208T>G,MODIFIER,,,,-1;PDGFC,3_prime_UTR_variant,,ENST00000274071,,c.*106T>G,MODIFIER,,,,-1;PDGFC,upstream_gene_variant,,ENST00000506880,,,MODIFIER,,,,-1	C	ENSG00000145431	ENST00000502773	Transcript	synonymous_variant	synonymous_variant	689/4165	198/1038	66/345	T	acT/acG		1		-1	PDGFC	HGNC	HGNC:8801	protein_coding	YES	CCDS3795.1	ENSP00000422464	Q9NRA1		UPI0000034814	NM_016205.2			2/6		Pfam_domain:PF00431;PROSITE_profiles:PS01180;SMART_domains:SM00042;Superfamily_domains:SSF49854																	LOW	1	SNV	1			1											PASS	GGATAAGTATG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM1261801	True	Unknown
ADCY2	108	BI	GRCh38	chr5	7706826	7706826	+	Missense_Mutation	SNP	C	C	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1192C>A	p.Leu398Met	p.L398M	ENST00000338316	8/25	152	132	20	163			ADCY2,missense_variant,p.L398M,ENST00000338316,NM_020546.2,c.1192C>A,MODERATE,YES,deleterious(0),probably_damaging(0.99),1;ADCY2,missense_variant,p.L396M,ENST00000537121,,c.1186C>A,MODERATE,,deleterious(0),probably_damaging(0.93),1;RP11-711G10.1,downstream_gene_variant,,ENST00000514105,,,MODIFIER,YES,,,-1	A	ENSG00000078295	ENST00000338316	Transcript	missense_variant	missense_variant	1281/6575	1192/3276	398/1091	L/M	Ctg/Atg		1		1	ADCY2	HGNC	HGNC:233	protein_coding	YES	CCDS3872.2	ENSP00000342952	Q08462		UPI000066D9F2	NM_020546.2	deleterious(0)	probably_damaging(0.99)	8/25		Pfam_domain:PF00211;PROSITE_profiles:PS50125;SMART_domains:SM00044;Superfamily_domains:SSF55073																	MODERATE	1	SNV	1			1											PASS	TTGGTCTGCAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3856388;COSM3856389	True	Unknown
CENPH	64946	BI	GRCh38	chr5	69202971	69202971	+	Splice_Site	SNP	G	G	A	rs541394077	by1000G	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.487+1G>A		p.X163_splice	ENST00000283006		33	28	5	38			CENPH,splice_donor_variant,p.X163_splice,ENST00000283006,NM_022909.3,c.487+1G>A,HIGH,YES,,,1;CENPH,splice_donor_variant,p.X144_splice,ENST00000515001,,c.430+1G>A,HIGH,,,,1;CENPH,splice_donor_variant,p.X102_splice,ENST00000502689,,c.305+1G>A,HIGH,,,,1;CENPH,upstream_gene_variant,,ENST00000510742,,,MODIFIER,,,,1;CENPH,downstream_gene_variant,,ENST00000513575,,,MODIFIER,,,,1	A	ENSG00000153044	ENST00000283006	Transcript	splice_donor_variant	splice_donor_variant	-/1389	487/744	163/247			rs541394077	1		1	CENPH	HGNC	HGNC:17268	protein_coding	YES	CCDS3998.1	ENSP00000283006	Q9H3R5		UPI000006F610	NM_022909.3				7/8			0.0008	0.0000		0.0000	0.0000	0.0000										HIGH	1	SNV	1			1	4.118e-05	4.137e-05	0.0001939	0	0	0	4.516e-05	0	0		PASS	ATTGCGTATGT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	NonExonic	COSM3856101	True	Unknown
VCAN	1462	BI	GRCh38	chr5	83520283	83520283	+	Silent	SNP	T	T	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1977T>A	p.=	p.S659S	ENST00000265077	7/15	88	74	14	79			VCAN,synonymous_variant,p.S659S,ENST00000265077,NM_004385.4,c.1977T>A,LOW,YES,,,1;VCAN,synonymous_variant,p.S659S,ENST00000342785,NM_001164098.1,c.1977T>A,LOW,,,,1;VCAN,synonymous_variant,p.S611S,ENST00000512590,,c.1833T>A,LOW,,,,1;VCAN,intron_variant,,ENST00000343200,NM_001164097.1,c.1042+7887T>A,MODIFIER,,,,1;VCAN,intron_variant,,ENST00000513960,,c.1042+7887T>A,MODIFIER,,,,1;VCAN,intron_variant,,ENST00000502527,NM_001126336.2,c.1042+7887T>A,MODIFIER,,,,1;VCAN,intron_variant,,ENST00000515397,,n.295+7887T>A,MODIFIER,,,,1	A	ENSG00000038427	ENST00000265077	Transcript	synonymous_variant	synonymous_variant	2542/12625	1977/10191	659/3396	S	tcT/tcA		1		1	VCAN	HGNC	HGNC:2464	protein_coding	YES	CCDS4060.1	ENSP00000265077	P13611	A0A024RAQ9	UPI000013178B	NM_004385.4			7/15																			LOW	1	SNV	1			1											PASS	TATTCTGGTGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3856688	True	Unknown
ADGRV1	84059	BI	GRCh38	chr5	90840818	90840818	+	Missense_Mutation	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.16852A>G	p.Thr5618Ala	p.T5618A	ENST00000405460	78/90	69	50	19	58			ADGRV1,missense_variant,p.T5618A,ENST00000405460,NM_032119.3,c.16852A>G,MODERATE,YES,,possibly_damaging(0.636),1;ADGRV1,missense_variant,p.T1279A,ENST00000425867,,c.3835A>G,MODERATE,,deleterious(0.01),possibly_damaging(0.872),1	G	ENSG00000164199	ENST00000405460	Transcript	missense_variant	missense_variant	16948/19338	16852/18921	5618/6306	T/A	Act/Gct		1		1	ADGRV1	HGNC	HGNC:17416	protein_coding	YES	CCDS47246.1	ENSP00000384582	Q8WXG9		UPI00002127A7	NM_032119.3		possibly_damaging(0.636)	78/90		Superfamily_domains:SSF141072																	MODERATE	1	SNV	1			1											PASS	ACATCACTCTT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3856865	True	Unknown
RAPGEF6	51735	BI	GRCh38	chr5	131492686	131492686	+	Nonsense_Mutation	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1627C>T	p.Gln543Ter	p.Q543*	ENST00000509018	14/28	88	74	14	81			RAPGEF6,stop_gained,p.Q543*,ENST00000509018,NM_016340.5,c.1627C>T,HIGH,,,,-1;RAPGEF6,stop_gained,p.Q543*,ENST00000307984,,c.1627C>T,HIGH,,,,-1;CTC-432M15.3,stop_gained,p.Q593*,ENST00000514667,,c.1777C>T,HIGH,YES,,,-1;RAPGEF6,stop_gained,p.Q543*,ENST00000507093,NM_001164387.1,c.1627C>T,HIGH,,,,-1;RAPGEF6,stop_gained,p.Q543*,ENST00000296859,NM_001164386.1,c.1627C>T,HIGH,YES,,,-1;RAPGEF6,stop_gained,p.Q543*,ENST00000627212,NM_001164388.1,c.1627C>T,HIGH,YES,,,-1;RAPGEF6,stop_gained,p.Q543*,ENST00000308008,NM_001164389.1,c.1627C>T,HIGH,,,,-1;RAPGEF6,stop_gained,p.Q258*,ENST00000512052,,c.772C>T,HIGH,,,,-1;RAPGEF6,stop_gained,p.Q543*,ENST00000510071,NM_001164390.1,c.1627C>T,HIGH,,,,-1;RAPGEF6,stop_gained,p.Q543*,ENST00000515170,,c.1627C>T,HIGH,,,,-1;RAPGEF6,non_coding_transcript_exon_variant,,ENST00000514179,,n.1191C>T,MODIFIER,,,,-1	A	ENSG00000158987	ENST00000509018	Transcript	stop_gained	stop_gained	1833/8357	1627/4806	543/1601	Q/*	Caa/Taa		1		-1	RAPGEF6	HGNC	HGNC:20655	protein_coding		CCDS34225.1	ENSP00000421684	Q8TEU7		UPI000020C537	NM_016340.5			14/28		Pfam_domain:PF00595;PROSITE_profiles:PS50106;SMART_domains:SM00228;Superfamily_domains:SSF48366;Superfamily_domains:SSF50156																	HIGH		SNV	1			1											PASS	GAATTGTAGAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3849953;COSM3849954;COSM3849955;COSM3849956	True	Unknown
PCDHB9	56127	BI	GRCh38	chr5	141189653	141189653	+	Missense_Mutation	SNP	G	G	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2335G>T	p.Gly779Cys	p.G779C	ENST00000316105	1/1	120	81	39	145			PCDHB9,missense_variant,p.G779C,ENST00000316105,NM_019119.4,c.2335G>T,MODERATE,YES,tolerated_low_confidence(0.13),benign(0.006),1;PCDHB10,intron_variant,,ENST00000515856,,c.14+2321G>T,MODIFIER,,,,1;PCDHB16,downstream_gene_variant,,ENST00000609684,NM_020957.2,,MODIFIER,YES,,,1;PCDHB10,upstream_gene_variant,,ENST00000239446,NM_018930.3,,MODIFIER,YES,,,1;PCDHB9,downstream_gene_variant,,ENST00000624909,,,MODIFIER,,,,1;CH17-140K24.5,downstream_gene_variant,,ENST00000623884,,,MODIFIER,YES,,,1;CH17-140K24.7,intron_variant,,ENST00000624549,,n.132-5804C>A,MODIFIER,YES,,,-1;CH17-140K24.2,intron_variant,,ENST00000624192,,n.72+52020C>A,MODIFIER,,,,-1;CH17-140K24.6,downstream_gene_variant,,ENST00000625144,,,MODIFIER,YES,,,-1;PCDHB9,downstream_gene_variant,,ENST00000623266,,,MODIFIER,,,,1;CH17-140K24.5,downstream_gene_variant,,ENST00000623407,,,MODIFIER,,,,1	T	ENSG00000177839	ENST00000316105	Transcript	missense_variant	missense_variant	2527/4415	2335/2394	779/797	G/C	Ggt/Tgt		1		1	PCDHB9	HGNC	HGNC:8694	protein_coding	YES	CCDS75328.1	ENSP00000478606	Q9Y5E1		UPI00005764A0	NM_019119.4	tolerated_low_confidence(0.13)	benign(0.006)	1/1																			MODERATE		SNV				1											PASS	ATAGGGGTGGG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSN8355429	False	Unknown
DOCK2	1794	BI	GRCh38	chr5	169996157	169996157	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.3065A>C	p.Glu1022Ala	p.E1022A	ENST00000256935	30/52	40	25	15	44			DOCK2,missense_variant,p.E1022A,ENST00000256935,NM_004946.2,c.3065A>C,MODERATE,YES,deleterious(0),benign(0.437),1;DOCK2,missense_variant,p.E514A,ENST00000520908,,c.1541A>C,MODERATE,,deleterious(0),possibly_damaging(0.496),1;DOCK2,non_coding_transcript_exon_variant,,ENST00000523351,,n.830A>C,MODIFIER,,,,1;DOCK2,non_coding_transcript_exon_variant,,ENST00000522994,,n.226A>C,MODIFIER,,,,1;DOCK2,missense_variant,p.E1022A,ENST00000524185,,c.3065A>C,MODERATE,,deleterious(0),probably_damaging(0.993),1	C	ENSG00000134516	ENST00000256935	Transcript	missense_variant	missense_variant	3145/6097	3065/5493	1022/1830	E/A	gAg/gCg		1		1	DOCK2	HGNC	HGNC:2988	protein_coding	YES	CCDS4371.1	ENSP00000256935	Q92608		UPI00001A38CC	NM_004946.2	deleterious(0)	benign(0.437)	30/52		Superfamily_domains:SSF48371;Superfamily_domains:SSF47240																	MODERATE	1	SNV	1			1											PASS	CTTTGAGTTCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3853623	True	Unknown
MUC21	394263	BI	GRCh38	chr6	30984026	30984026	+	Splice_Region	SNP	G	G	A	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.61+7G>A			ENST00000376296		117	105	12	89			MUC21,splice_region_variant,,ENST00000376296,NM_001010909.2,c.61+7G>A,LOW,YES,,,1;MUC21,5_prime_UTR_variant,,ENST00000486149,,c.-1437G>A,MODIFIER,,,,1	A	ENSG00000204544	ENST00000376296	Transcript	splice_region_variant	splice_region_variant;intron_variant	-/3651	-/1701	-/566				1		1	MUC21	HGNC	HGNC:21661	protein_coding	YES	CCDS34388.1	ENSP00000365473	Q5SSG8		UPI000047030C	NM_001010909.2				1/2																		LOW	1	SNV	1			1											PASS	TGAGTGATTTT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
BRD2	6046	BI	GRCh38	chr6	32977381	32977381	+	Intron	SNP	G	G	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1201-61G>C			ENST00000374825		58	51	7	63			BRD2,intron_variant,,ENST00000374825,NM_005104.3,c.1201-61G>C,MODIFIER,,,,1;BRD2,intron_variant,,ENST00000374831,NM_001113182.2,c.1201-61G>C,MODIFIER,,,,1;BRD2,intron_variant,,ENST00000395287,NM_001199455.1,c.1201-61G>C,MODIFIER,YES,,,1;BRD2,intron_variant,,ENST00000449025,,c.1218-61G>C,MODIFIER,,,,1;BRD2,intron_variant,,ENST00000449085,NM_001199456.1,c.1060-61G>C,MODIFIER,,,,1;BRD2,intron_variant,,ENST00000607833,,c.1201-61G>C,MODIFIER,,,,1;BRD2,downstream_gene_variant,,ENST00000456339,,,MODIFIER,,,,1;BRD2,downstream_gene_variant,,ENST00000606059,,,MODIFIER,,,,1;XXbac-BPG181M17.6,upstream_gene_variant,,ENST00000580587,,,MODIFIER,YES,,,-1;BRD2,3_prime_UTR_variant,,ENST00000495733,,c.*116G>C,MODIFIER,,,,1;BRD2,non_coding_transcript_exon_variant,,ENST00000464592,,n.1063G>C,MODIFIER,,,,1;BRD2,intron_variant,,ENST00000482914,NM_001291986.1,c.*849-61G>C,MODIFIER,,,,1;BRD2,intron_variant,,ENST00000481259,,c.369-36G>C,MODIFIER,,,,1;BRD2,upstream_gene_variant,,ENST00000469132,,,MODIFIER,,,,1;BRD2,upstream_gene_variant,,ENST00000463639,,,MODIFIER,,,,1;BRD2,upstream_gene_variant,,ENST00000482838,,,MODIFIER,,,,1	C	ENSG00000204256	ENST00000374825	Transcript	intron_variant	intron_variant	-/4894	-/2406	-/801				1		1	BRD2	HGNC	HGNC:1103	protein_coding		CCDS4762.1	ENSP00000363958	P25440	A0A024RCR5	UPI0000126ACC	NM_005104.3				7/12																		MODIFIER		SNV	1			1											PASS	CTGGGGTTGGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			False	Unknown
DST	667	BI	GRCh38	chr6	56618576	56618585	+	Intron	DEL	TGTGCTGCCC	TGTGCTGCCC	-	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.4417-4101_4417-4092delGGGCAGCACA			ENST00000312431		119	94	25	110			DST,frameshift_variant,p.G1817Wfs*16,ENST00000370765,NM_001723.5,c.5449_5458delGGGCAGCACA,HIGH,,,,-1;DST,intron_variant,,ENST00000361203,,c.4297-4101_4297-4092delGGGCAGCACA,MODIFIER,,,,-1;DST,intron_variant,,ENST00000370754,NM_001144769.2,c.4831-4101_4831-4092delGGGCAGCACA,MODIFIER,,,,-1;DST,intron_variant,,ENST00000421834,NM_183380.3,c.4297-4101_4297-4092delGGGCAGCACA,MODIFIER,,,,-1;DST,intron_variant,,ENST00000312431,NM_001144770.1,c.4417-4101_4417-4092delGGGCAGCACA,MODIFIER,YES,,,-1;DST,intron_variant,,ENST00000370788,,c.4297-4101_4297-4092delGGGCAGCACA,MODIFIER,,,,-1;DST,intron_variant,,ENST00000244364,NM_015548.4,c.3319-4101_3319-4092delGGGCAGCACA,MODIFIER,,,,-1;DST,intron_variant,,ENST00000439203,,c.3319-4101_3319-4092delGGGCAGCACA,MODIFIER,,,,-1;DST,intron_variant,,ENST00000520645,,c.4417-4101_4417-4092delGGGCAGCACA,MODIFIER,,,,-1;DST,intron_variant,,ENST00000522360,,c.312-1167_312-1158delGGGCAGCACA,MODIFIER,,,,-1	-	ENSG00000151914	ENST00000312431	Transcript	intron_variant	intron_variant	-/17756	-/16614	-/5537				1		-1	DST	HGNC	HGNC:1090	protein_coding	YES	CCDS75474.1	ENSP00000307959		F6QMI7		NM_001144770.1				33/94																		MODIFIER	1	deletion	5			1											PASS	CTTCCATGTGCTGCCCTTGCT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
KCNQ5	56479	BI	GRCh38	chr6	73194615	73194615	+	Missense_Mutation	SNP	C	C	T	rs747182315	byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2000C>T	p.Ser667Leu	p.S667L	ENST00000370398	14/14	71	55	16	93			KCNQ5,missense_variant,p.S686L,ENST00000342056,NM_001160133.1&NM_001160132.1,c.2057C>T,MODERATE,YES,deleterious(0.04),possibly_damaging(0.703),1;KCNQ5,missense_variant,p.S686L,ENST00000355635,,c.2057C>T,MODERATE,,deleterious(0.04),possibly_damaging(0.452),1;KCNQ5,missense_variant,p.S677L,ENST00000402622,,c.2030C>T,MODERATE,,deleterious(0.04),possibly_damaging(0.452),1;KCNQ5,missense_variant,p.S667L,ENST00000355194,,c.2000C>T,MODERATE,,deleterious(0.04),possibly_damaging(0.452),1;KCNQ5,missense_variant,p.S658L,ENST00000403813,,c.1973C>T,MODERATE,,deleterious(0.03),benign(0.396),1;KCNQ5,missense_variant,p.S667L,ENST00000370398,NM_019842.3,c.2000C>T,MODERATE,,deleterious(0.03),benign(0.265),1;KCNQ5,missense_variant,p.S557L,ENST00000414165,,c.1670C>T,MODERATE,,deleterious(0.01),possibly_damaging(0.49),1;KCNQ5,missense_variant,p.S557L,ENST00000628967,NM_001160134.1,c.1670C>T,MODERATE,,deleterious(0.01),possibly_damaging(0.637),1;KCNQ5,missense_variant,p.S658L,ENST00000629977,NM_001160130.1,c.1973C>T,MODERATE,,deleterious(0.03),benign(0.231),1	T	ENSG00000185760	ENST00000370398	Transcript	missense_variant	missense_variant	2109/6345	2000/2799	667/932	S/L	tCg/tTg	rs747182315	1		1	KCNQ5	HGNC	HGNC:6299	protein_coding		CCDS4976.1	ENSP00000359425	Q9NR82		UPI0000167EE4	NM_019842.3	deleterious(0.03)	benign(0.265)	14/14																			MODERATE		SNV	1			1	1.647e-05	1.647e-05	0	0	0	0	1.498e-05	0	6.056e-05		PASS	TCTTTCGGGTT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3875393;COSM3875394	True	Unknown
ASCC3	10973	BI	GRCh38	chr6	100655706	100655706	+	Missense_Mutation	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2816C>T	p.Ala939Val	p.A939V	ENST00000369162	17/42	54	31	22	43			ASCC3,missense_variant,p.A939V,ENST00000369162,NM_006828.3,c.2816C>T,MODERATE,YES,tolerated(0.2),benign(0.009),-1;ASCC3,3_prime_UTR_variant,,ENST00000324696,,c.*2518C>T,MODIFIER,,,,-1	A	ENSG00000112249	ENST00000369162	Transcript	missense_variant	missense_variant	3161/8146	2816/6609	939/2202	A/V	gCt/gTt		1		-1	ASCC3	HGNC	HGNC:18697	protein_coding	YES	CCDS5046.1	ENSP00000358159	Q8N3C0		UPI000014145A	NM_006828.3	tolerated(0.2)	benign(0.009)	17/42																			MODERATE	1	SNV	5			1											PASS	GATAAGCCTTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3857137	True	Unknown
REV3L	5980	BI	GRCh38	chr6	111375517	111375517	+	Silent	SNP	A	A	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2838T>A	p.=	p.P946P	ENST00000358835	14/33	26	18	8	24			REV3L,synonymous_variant,p.P868P,ENST00000435970,NM_001286431.1&NM_001286432.1,c.2604T>A,LOW,,,,-1;REV3L,synonymous_variant,p.P946P,ENST00000358835,NM_002912.4,c.2838T>A,LOW,YES,,,-1;REV3L,synonymous_variant,p.P946P,ENST00000368802,,c.2838T>A,LOW,,,,-1;REV3L,synonymous_variant,p.P946P,ENST00000368805,,c.2838T>A,LOW,,,,-1;REV3L,3_prime_UTR_variant,,ENST00000422377,,c.*2822T>A,MODIFIER,,,,-1;REV3L,3_prime_UTR_variant,,ENST00000434009,,c.*2929T>A,MODIFIER,,,,-1	T	ENSG00000009413	ENST00000358835	Transcript	synonymous_variant	synonymous_variant	3296/10815	2838/9393	946/3130	P	ccT/ccA		1		-1	REV3L	HGNC	HGNC:9968	protein_coding	YES	CCDS5091.2	ENSP00000351697	O60673		UPI0000140023	NM_002912.4			14/33		Superfamily_domains:SSF53098																	LOW	1	SNV	5			1											PASS	GGATGAGGTAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3857583;COSM3857584	True	Unknown
HSF2	3298	BI	GRCh38	chr6	122419208	122419208	+	Missense_Mutation	SNP	T	T	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.572T>G	p.Leu191Arg	p.L191R	ENST00000368455	6/13	37	32	5	37			HSF2,missense_variant,p.L191R,ENST00000452194,NM_001135564.1,c.572T>G,MODERATE,,deleterious(0),possibly_damaging(0.812),1;HSF2,missense_variant,p.L191R,ENST00000368455,NM_004506.3,c.572T>G,MODERATE,YES,deleterious(0),possibly_damaging(0.653),1;HSF2,upstream_gene_variant,,ENST00000465214,,,MODIFIER,,,,1	G	ENSG00000025156	ENST00000368455	Transcript	missense_variant	missense_variant	764/2549	572/1611	191/536	L/R	cTt/cGt		1		1	HSF2	HGNC	HGNC:5225	protein_coding	YES	CCDS5124.1	ENSP00000357440	Q03933		UPI000012CCE8	NM_004506.3	deleterious(0)	possibly_damaging(0.653)	6/13		Superfamily_domains:SSF46966																	MODERATE	1	SNV	1			1											PASS	CCAACTTGTGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3857963	True	Unknown
SYNE1	23345	BI	GRCh38	chr6	152230641	152230641	+	Missense_Mutation	SNP	A	A	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.21101T>A	p.Leu7034Gln	p.L7034Q	ENST00000367255	115/146	56	43	13	76			SYNE1,missense_variant,p.L7034Q,ENST00000367255,NM_182961.3,c.21101T>A,MODERATE,YES,,probably_damaging(0.998),-1;SYNE1,missense_variant,p.L6963Q,ENST00000423061,NM_033071.3,c.20888T>A,MODERATE,,,probably_damaging(0.995),-1;SYNE1,missense_variant,p.L6629Q,ENST00000341594,,c.19886T>A,MODERATE,,,benign(0.002),-1;SYNE1,upstream_gene_variant,,ENST00000367251,,,MODIFIER,,,,-1;SYNE1,non_coding_transcript_exon_variant,,ENST00000367256,,n.4793T>A,MODIFIER,,,,-1;SYNE1,non_coding_transcript_exon_variant,,ENST00000409694,,n.4685T>A,MODIFIER,,,,-1	T	ENSG00000131018	ENST00000367255	Transcript	missense_variant	missense_variant	21703/27748	21101/26394	7034/8797	L/Q	cTg/cAg		1		-1	SYNE1	HGNC	HGNC:17089	protein_coding	YES	CCDS5236.2	ENSP00000356224	Q8NF91		UPI000204AF58	NM_182961.3		probably_damaging(0.998)	115/146		Pfam_domain:PF00435;SMART_domains:SM00150;Superfamily_domains:SSF49758;Superfamily_domains:SSF90123																	MODERATE	1	SNV	1			1											PASS	TTTTCAGACAT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3859252;COSM3859253;COSM3859254;COSM3859255;COSM3859256	True	Unknown
SDK1	221935	BI	GRCh38	chr7	4132388	4132388	+	Nonsense_Mutation	SNP	G	G	A	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.4193G>A	p.Trp1398Ter	p.W1398*	ENST00000404826	28/45	21	12	9	35			SDK1,stop_gained,p.W1398*,ENST00000404826,NM_152744.3,c.4193G>A,HIGH,YES,,,1;SDK1,stop_gained,p.W1398*,ENST00000615806,,c.4193G>A,HIGH,,,,1;SDK1,stop_gained,p.W1398*,ENST00000389531,,c.4193G>A,HIGH,,,,1;SDK1,non_coding_transcript_exon_variant,,ENST00000476701,,n.477G>A,MODIFIER,,,,1	A	ENSG00000146555	ENST00000404826	Transcript	stop_gained	stop_gained	4332/10397	4193/6642	1398/2213	W/*	tGg/tAg		1		1	SDK1	HGNC	HGNC:19307	protein_coding	YES	CCDS34590.1	ENSP00000385899	Q7Z5N4		UPI0000DBEEC4	NM_152744.3			28/45		Pfam_domain:PF00041;PROSITE_profiles:PS50853;SMART_domains:SM00060;Superfamily_domains:SSF49265																	HIGH	1	SNV	5			1											PASS	AGTGTGGCAAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
SP8	221833	BI	GRCh38	chr7	20785022	20785022	+	Silent	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.741G>A	p.=	p.P247P	ENST00000361443	3/3	15	9	6	25			SP8,synonymous_variant,p.P223P,ENST00000617581,,c.669G>A,LOW,,,,-1;SP8,synonymous_variant,p.P247P,ENST00000361443,NM_198956.2,c.741G>A,LOW,,,,-1;SP8,synonymous_variant,p.P265P,ENST00000418710,NM_182700.4,c.795G>A,LOW,YES,,,-1	T	ENSG00000164651	ENST00000361443	Transcript	synonymous_variant	synonymous_variant	979/1714	741/1473	247/490	P	ccG/ccA		1		-1	SP8	HGNC	HGNC:19196	protein_coding		CCDS5372.1	ENSP00000354482	Q8IXZ3			NM_198956.2			3/3																			LOW		SNV	1			1											PASS	CCGAGCGGCGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3698329;COSM3698330	True	Unknown
PKD1L1	168507	BI	GRCh38	chr7	47855031	47855031	+	Silent	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.4710G>A	p.=	p.R1570R	ENST00000289672	30/57	39	30	9	50			PKD1L1,synonymous_variant,p.R1570R,ENST00000289672,NM_138295.3,c.4710G>A,LOW,YES,,,-1;HUS1,intron_variant,,ENST00000436444,,c.*1170+109155G>A,MODIFIER,,,,-1	T	ENSG00000158683	ENST00000289672	Transcript	synonymous_variant	synonymous_variant	4761/9092	4710/8550	1570/2849	R	agG/agA		1		-1	PKD1L1	HGNC	HGNC:18053	protein_coding	YES	CCDS34633.1	ENSP00000289672	Q8TDX9		UPI0000130FA9	NM_138295.3			30/57		PROSITE_profiles:PS51111																	LOW	1	SNV	1			1											PASS	TTTCTCCTATT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3639201	True	Unknown
POM121	9883	BI	GRCh38	chr7	72949106	72949106	+	3'Flank	SNP	A	A	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d				ENST00000434423		42	32	10	61			POM121,3_prime_UTR_variant,,ENST00000395270,NM_001257190.2,c.*636A>C,MODIFIER,YES,,,1;POM121,downstream_gene_variant,,ENST00000627934,NM_172020.4,,MODIFIER,,,,1;POM121,downstream_gene_variant,,ENST00000358357,,,MODIFIER,,,,1;POM121,downstream_gene_variant,,ENST00000434423,,,MODIFIER,,,,1;POM121,downstream_gene_variant,,ENST00000446813,,,MODIFIER,,,,1;NSUN5P2,splice_region_variant,,ENST00000388955,,n.1138-4T>G,LOW,YES,,,-1;NSUN5P2,splice_region_variant,,ENST00000602348,,n.338-4T>G,LOW,,,,-1;NSUN5P2,splice_region_variant,,ENST00000485741,,n.1068-4T>G,LOW,,,,-1;NSUN5P2,splice_region_variant,,ENST00000444583,,n.524-4T>G,LOW,,,,-1;NSUN5P2,splice_region_variant,,ENST00000457352,,n.1065-4T>G,LOW,,,,-1	C	ENSG00000196313	ENST00000434423	Transcript	downstream_gene_variant	downstream_gene_variant	-/3750	-/3750	-/1249				1	2872	1	POM121	HGNC	HGNC:19702	protein_coding			ENSP00000405562	Q96HA1																									MODIFIER		SNV	5			1											PASS	ACCTAAGGAAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
PCLO	27445	BI	GRCh38	chr7	82915250	82915250	+	Missense_Mutation	SNP	T	T	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.12736A>G	p.Arg4246Gly	p.R4246G	ENST00000333891	7/25	22	15	7	25			PCLO,missense_variant,p.R4246G,ENST00000333891,NM_033026.5,c.12736A>G,MODERATE,YES,,unknown(0),-1;PCLO,missense_variant,p.R4246G,ENST00000423517,NM_014510.2,c.12736A>G,MODERATE,,,probably_damaging(0.967),-1;PCLO,missense_variant,p.R966G,ENST00000437081,,c.2896A>G,MODERATE,,deleterious(0),possibly_damaging(0.465),-1	C	ENSG00000186472	ENST00000333891	Transcript	missense_variant	missense_variant	13074/20329	12736/15429	4246/5142	R/G	Aga/Gga		1		-1	PCLO	HGNC	HGNC:13406	protein_coding	YES	CCDS47630.1	ENSP00000334319	Q9Y6V0		UPI0001573469	NM_033026.5		unknown(0)	7/25																			MODERATE	1	SNV	2			1											PASS	TTTTCTGAGGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
PCLO	27445	BI	GRCh38	chr7	82916007	82916007	+	Silent	SNP	C	C	T	rs376827834	byCluster	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.11979G>A	p.=	p.T3993T	ENST00000333891	7/25	324	260	64	357			PCLO,synonymous_variant,p.T3993T,ENST00000333891,NM_033026.5,c.11979G>A,LOW,YES,,,-1;PCLO,synonymous_variant,p.T3993T,ENST00000423517,NM_014510.2,c.11979G>A,LOW,,,,-1;PCLO,synonymous_variant,p.T713T,ENST00000437081,,c.2139G>A,LOW,,,,-1	T	ENSG00000186472	ENST00000333891	Transcript	synonymous_variant	synonymous_variant	12317/20329	11979/15429	3993/5142	T	acG/acA	rs376827834	1		-1	PCLO	HGNC	HGNC:13406	protein_coding	YES	CCDS47630.1	ENSP00000334319	Q9Y6V0		UPI0001573469	NM_033026.5			7/25										0	0.0002								LOW	1	SNV	2			1	8.274e-06	8.283e-06	0	0	0	0	1.499e-05	0	0		PASS	TTATCCGTAGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	gdc_pon	COSM3030585;COSM3030586;COSM4363624	True	Unknown
PCLO	27445	BI	GRCh38	chr7	82954890	82954890	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.6063T>G	p.His2021Gln	p.H2021Q	ENST00000333891	5/25	38	31	7	40			PCLO,missense_variant,p.H2021Q,ENST00000333891,NM_033026.5,c.6063T>G,MODERATE,YES,,unknown(0),-1;PCLO,missense_variant,p.H2021Q,ENST00000423517,NM_014510.2,c.6063T>G,MODERATE,,,possibly_damaging(0.843),-1;PCLO,upstream_gene_variant,,ENST00000437081,,,MODIFIER,,,,-1	C	ENSG00000186472	ENST00000333891	Transcript	missense_variant	missense_variant	6401/20329	6063/15429	2021/5142	H/Q	caT/caG		1		-1	PCLO	HGNC	HGNC:13406	protein_coding	YES	CCDS47630.1	ENSP00000334319	Q9Y6V0		UPI0001573469	NM_033026.5		unknown(0)	5/25																			MODERATE	1	SNV	2			1											PASS	ACAGAATGTAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3882805;COSM3882806;COSM3882807;COSM4907567	True	Unknown
PTCD1	26024	BI	GRCh38	chr7	99429767	99429767	+	Missense_Mutation	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.634A>G	p.Thr212Ala	p.T212A	ENST00000292478	4/8	31	22	9	48			PTCD1,missense_variant,p.T212A,ENST00000292478,NM_015545.3,c.634A>G,MODERATE,YES,deleterious(0),probably_damaging(0.999),-1;ATP5J2-PTCD1,missense_variant,p.T261A,ENST00000413834,NM_001198879.1,c.781A>G,MODERATE,YES,deleterious(0),probably_damaging(0.999),-1;PTCD1,downstream_gene_variant,,ENST00000430982,,,MODIFIER,,,,-1;PTCD1,non_coding_transcript_exon_variant,,ENST00000485746,,n.435A>G,MODIFIER,,,,-1	C	ENSG00000106246	ENST00000292478	Transcript	missense_variant	missense_variant	885/5582	634/2103	212/700	T/A	Acg/Gcg		1		-1	PTCD1	HGNC	HGNC:22198	protein_coding	YES	CCDS34691.1	ENSP00000292478	O75127	A4D273	UPI0000223FFA	NM_015545.3	deleterious(0)	probably_damaging(0.999)	4/8																			MODERATE	1	SNV	1			1											PASS	GGCCGTGTAGG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3883825;COSM3883826	True	Unknown
GIGYF1	64599	BI	GRCh38	chr7	100684058	100684058	+	Silent	SNP	C	C	T	rs138722511	by1000G;byCluster	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1830G>A	p.=	p.T610T	ENST00000275732	15/24	18	13	5	21			GIGYF1,synonymous_variant,p.T610T,ENST00000275732,NM_022574.4,c.1830G>A,LOW,YES,,,-1;GNB2,downstream_gene_variant,,ENST00000303210,NM_005273.3,,MODIFIER,YES,,,1;GNB2,downstream_gene_variant,,ENST00000393926,,,MODIFIER,,,,1;GNB2,downstream_gene_variant,,ENST00000393924,,,MODIFIER,,,,1;GNB2,downstream_gene_variant,,ENST00000436220,,,MODIFIER,,,,1;GNB2,downstream_gene_variant,,ENST00000424361,,,MODIFIER,,,,1;GNB2,downstream_gene_variant,,ENST00000419828,,,MODIFIER,,,,1;GNB2,downstream_gene_variant,,ENST00000427895,,,MODIFIER,,,,1;GIGYF1,downstream_gene_variant,,ENST00000471340,,,MODIFIER,,,,-1;GIGYF1,non_coding_transcript_exon_variant,,ENST00000472105,,n.422G>A,MODIFIER,,,,-1;GNB2,downstream_gene_variant,,ENST00000469287,,,MODIFIER,,,,1;GIGYF1,downstream_gene_variant,,ENST00000464111,,,MODIFIER,,,,-1	T	ENSG00000146830	ENST00000275732	Transcript	synonymous_variant	synonymous_variant	3040/6530	1830/3108	610/1035	T	acG/acA	rs138722511	1		-1	GIGYF1	HGNC	HGNC:9126	protein_coding	YES	CCDS34708.1	ENSP00000275732	O75420			NM_022574.4			15/24		Low_complexity_(Seg):Seg;PROSITE_profiles:PS50322	0.0002	0.0008	0.0000		0.0000	0.0000	0.0000										LOW	1	SNV	1			1	1.652e-05	1.899e-05	0.0001245	0	0	0	0	0	6.626e-05		PASS	AATGCCGTGAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	gdc_pon	COSM3876377;COSM3876378	True	Unknown
OR2F1	26211	BI	GRCh38	chr7	143960399	143960399	+	Silent	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.429G>A	p.=	p.R143R	ENST00000392899	1/1	68	47	21	95			OR2F1,synonymous_variant,p.R143R,ENST00000392899,NM_012369.2,c.429G>A,LOW,YES,,,1;OR2F1,synonymous_variant,p.R143R,ENST00000623829,,c.429G>A,LOW,YES,,,1;RP4-669B10.3,intron_variant,,ENST00000470988,,n.146+1291G>A,MODIFIER,,,,1;RP4-669B10.3,downstream_gene_variant,,ENST00000466281,,,MODIFIER,YES,,,1;OR2F1,synonymous_variant,p.R143R,ENST00000624504,,c.429G>A,LOW,,,,1	A	ENSG00000213215	ENST00000392899	Transcript	synonymous_variant	synonymous_variant	468/1084	429/954	143/317	R	agG/agA		1		1	OR2F1	HGNC	HGNC:8246	protein_coding	YES	CCDS5887.1	ENSP00000376633	Q13607			NM_012369.2			1/1		Pfam_domain:PF00001;Transmembrane_helices:Tmhmm;PROSITE_profiles:PS50262;Superfamily_domains:SSF81321																	LOW		SNV				1											PASS	GCTAGGTTGGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3878996	True	Unknown
CSGALNACT1	55790	BI	GRCh38	chr8	19505233	19505233	+	Missense_Mutation	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.602A>G	p.His201Arg	p.H201R	ENST00000332246	4/10	56	44	12	80			CSGALNACT1,missense_variant,p.H201R,ENST00000454498,NM_001130518.1,c.602A>G,MODERATE,YES,tolerated(0.8),benign(0.001),-1;CSGALNACT1,missense_variant,p.H201R,ENST00000332246,NM_018371.4,c.602A>G,MODERATE,,tolerated(0.8),benign(0.001),-1;CSGALNACT1,missense_variant,p.H201R,ENST00000522854,,c.602A>G,MODERATE,,tolerated(0.8),benign(0.001),-1;CSGALNACT1,downstream_gene_variant,,ENST00000523262,,,MODIFIER,,,,-1;CSGALNACT1,downstream_gene_variant,,ENST00000517494,,,MODIFIER,,,,-1;CSGALNACT1,downstream_gene_variant,,ENST00000520003,,,MODIFIER,,,,-1;CSGALNACT1,downstream_gene_variant,,ENST00000524213,,,MODIFIER,,,,-1;CSGALNACT1,downstream_gene_variant,,ENST00000523227,,,MODIFIER,,,,-1;CSGALNACT1,downstream_gene_variant,,ENST00000517651,,,MODIFIER,,,,-1;CSGALNACT1,downstream_gene_variant,,ENST00000522573,,,MODIFIER,,,,-1;CSGALNACT1,downstream_gene_variant,,ENST00000522732,,,MODIFIER,,,,-1;CSGALNACT1,missense_variant,p.H201R,ENST00000397998,,c.602A>G,MODERATE,,tolerated(0.65),benign(0.001),-1;CSGALNACT1,missense_variant,p.H201R,ENST00000519222,,c.602A>G,MODERATE,,tolerated(0.65),benign(0.001),-1	C	ENSG00000147408	ENST00000332246	Transcript	missense_variant	missense_variant	1256/3872	602/1599	201/532	H/R	cAc/cGc		1		-1	CSGALNACT1	HGNC	HGNC:24290	protein_coding		CCDS6010.1	ENSP00000330805	Q8TDX6		UPI000013F19F	NM_018371.4	tolerated(0.8)	benign(0.001)	4/10		Pfam_domain:PF05679																	MODERATE		SNV	1			1											PASS	GACGGTGATTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3898661	True	Unknown
ADRA1A	148	BI	GRCh38	chr8	26770508	26770508	+	Missense_Mutation	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1042A>G	p.Arg348Gly	p.R348G	ENST00000276393	2/2	160	131	29	236			ADRA1A,missense_variant,p.R348G,ENST00000380573,,c.1042A>G,MODERATE,,tolerated(0.08),benign(0.009),-1;ADRA1A,missense_variant,p.R348G,ENST00000380586,NM_033303.3,c.1042A>G,MODERATE,YES,tolerated(0.07),benign(0.118),-1;ADRA1A,missense_variant,p.R348G,ENST00000276393,NM_000680.2,c.1042A>G,MODERATE,,tolerated(0.08),benign(0.009),-1;ADRA1A,missense_variant,p.R348G,ENST00000380582,NM_033302.2,c.1042A>G,MODERATE,,tolerated(0.08),benign(0.003),-1;ADRA1A,missense_variant,p.R348G,ENST00000519229,,c.1042A>G,MODERATE,,tolerated(0.08),benign(0.075),-1;ADRA1A,missense_variant,p.R348G,ENST00000354550,NM_033304.2,c.1042A>G,MODERATE,,tolerated(0.07),benign(0.033),-1;ADRA1A,non_coding_transcript_exon_variant,,ENST00000518621,,n.255A>G,MODIFIER,,,,-1;ADRA1A,intron_variant,,ENST00000519096,,c.*83-21760A>G,MODIFIER,,,,-1;ADRA1A,intron_variant,,ENST00000521711,,c.*83-13729A>G,MODIFIER,,,,-1;RP11-384C12.1,upstream_gene_variant,,ENST00000486251,,,MODIFIER,YES,,,1	C	ENSG00000120907	ENST00000276393	Transcript	missense_variant	missense_variant	1478/2281	1042/1401	348/466	R/G	Aga/Gga		1		-1	ADRA1A	HGNC	HGNC:277	protein_coding		CCDS6054.1	ENSP00000276393	P35348		UPI000003B07A	NM_000680.2	tolerated(0.08)	benign(0.009)	2/2		Superfamily_domains:SSF81321																	MODERATE		SNV	1			1											PASS	CTTTCTGCAGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3899171;COSM3899172;COSM3899173;COSM3899174	True	Unknown
GINS4	84296	BI	GRCh38	chr8	41541861	41541861	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.537A>C	p.Gln179His	p.Q179H	ENST00000276533	7/8	44	39	5	63			GINS4,missense_variant,p.Q179H,ENST00000523277,,c.537A>C,MODERATE,,deleterious(0.02),possibly_damaging(0.881),1;GINS4,missense_variant,p.Q179H,ENST00000276533,NM_032336.2,c.537A>C,MODERATE,YES,deleterious(0.02),possibly_damaging(0.881),1;GINS4,missense_variant,p.Q179H,ENST00000518671,,c.537A>C,MODERATE,,deleterious(0.02),possibly_damaging(0.881),1;GINS4,downstream_gene_variant,,ENST00000520710,,,MODIFIER,,,,1;RP11-360L9.7,intron_variant,,ENST00000524133,,n.541-1451T>G,MODIFIER,,,,-1;RP11-360L9.4,intron_variant,,ENST00000523081,,n.64-4551T>G,MODIFIER,YES,,,-1;RP11-360L9.7,downstream_gene_variant,,ENST00000578500,,,MODIFIER,YES,,,-1;GINS4,3_prime_UTR_variant,,ENST00000520354,,c.*35A>C,MODIFIER,,,,1;GINS4,non_coding_transcript_exon_variant,,ENST00000518430,,n.58A>C,MODIFIER,,,,1;GINS4,downstream_gene_variant,,ENST00000520631,,,MODIFIER,,,,1;GINS4,downstream_gene_variant,,ENST00000522642,,,MODIFIER,,,,1	C	ENSG00000147536	ENST00000276533	Transcript	missense_variant	missense_variant	747/3841	537/672	179/223	Q/H	caA/caC		1		1	GINS4	HGNC	HGNC:28226	protein_coding	YES	CCDS6116.1	ENSP00000276533	Q9BRT9		UPI000007007B	NM_032336.2	deleterious(0.02)	possibly_damaging(0.881)	7/8		PIRSF_domain:PIRSF007764																	MODERATE	1	SNV	1			1											PASS	CGACAAGAAAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3900155	True	Unknown
TTPA	7274	BI	GRCh38	chr8	63061247	63061247	+	3'UTR	SNP	A	A	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.*5T>G			ENST00000260116	5/5	49	42	7	43			TTPA,3_prime_UTR_variant,,ENST00000260116,NM_000370.3,c.*5T>G,MODIFIER,YES,,,-1;TTPA,intron_variant,,ENST00000521138,,n.233-12644T>G,MODIFIER,,,,-1	C	ENSG00000137561	ENST00000260116	Transcript	3_prime_UTR_variant	3_prime_UTR_variant	874/2338	-/837	-/278				1		-1	TTPA	HGNC	HGNC:12404	protein_coding	YES	CCDS6178.1	ENSP00000260116	P49638		UPI00001377AC	NM_000370.3			5/5																			MODIFIER	1	SNV	1			1											PASS	ACATAACTTCT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
C8orf34	116328	BI	GRCh38	chr8	68446479	68446479	+	Intron	SNP	C	C	T	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.607+19C>T			ENST00000518698		44	39	5	36			C8orf34,missense_variant,p.S123L,ENST00000523686,,c.368C>T,MODERATE,,deleterious_low_confidence(0),unknown(0),1;C8orf34,intron_variant,,ENST00000337103,,c.274+19C>T,MODIFIER,,,,1;C8orf34,intron_variant,,ENST00000348340,NM_001195639.1,c.349+19C>T,MODIFIER,,,,1;C8orf34,intron_variant,,ENST00000518698,NM_052958.2,c.607+19C>T,MODIFIER,YES,,,1;C8orf34,intron_variant,,ENST00000349492,,n.478+19C>T,MODIFIER,,,,1;C8orf34,intron_variant,,ENST00000521406,,c.274+19C>T,MODIFIER,,,,1	T	ENSG00000165084	ENST00000518698	Transcript	intron_variant	intron_variant	-/2223	-/1617	-/538				1		1	C8orf34	HGNC	HGNC:30905	protein_coding	YES	CCDS6203.2	ENSP00000427820	Q49A92		UPI000021D12D	NM_052958.2				3/13																		MODIFIER	1	SNV	2			1											PASS	TTATTCAAATG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
DPY19L4	286148	BI	GRCh38	chr8	94781151	94781151	+	Missense_Mutation	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1700T>C	p.Leu567Pro	p.L567P	ENST00000414645	16/19	58	47	11	77			DPY19L4,missense_variant,p.L567P,ENST00000414645,NM_181787.2,c.1700T>C,MODERATE,YES,deleterious(0),probably_damaging(1),1;DPY19L4,intron_variant,,ENST00000522669,,c.166+736T>C,MODIFIER,,,,1	C	ENSG00000156162	ENST00000414645	Transcript	missense_variant	missense_variant	1799/6197	1700/2172	567/723	L/P	cTt/cCt		1		1	DPY19L4	HGNC	HGNC:27829	protein_coding	YES	CCDS34924.1	ENSP00000389630	Q7Z388	A0A024R9F2		NM_181787.2	deleterious(0)	probably_damaging(1)	16/19		Pfam_domain:PF10034																	MODERATE	1	SNV	1			1											PASS	GGAACTTATGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3902203	True	Unknown
TG	7038	BI	GRCh38	chr8	132887110	132887110	+	Missense_Mutation	SNP	T	T	G	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1738T>G	p.Phe580Val	p.F580V	ENST00000220616	9/48	66	59	7	72			TG,missense_variant,p.F580V,ENST00000220616,NM_003235.4,c.1738T>G,MODERATE,YES,deleterious(0.04),probably_damaging(0.962),1;TG,downstream_gene_variant,,ENST00000520769,,,MODIFIER,,,,1	G	ENSG00000042832	ENST00000220616	Transcript	missense_variant	missense_variant	1778/8450	1738/8307	580/2768	F/V	Ttc/Gtc		1		1	TG	HGNC	HGNC:11764	protein_coding	YES	CCDS34944.1	ENSP00000220616	P01266		UPI000013C79F	NM_003235.4	deleterious(0.04)	probably_damaging(0.962)	9/48		Low_complexity_(Seg):Seg;PIRSF_domain:PIRSF001831																	MODERATE	1	SNV	1			1											PASS	TTCTCTTCTTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
PARP10	84875	BI	GRCh38	chr8	143984330	143984330	+	Silent	SNP	G	G	A	rs371073478	byCluster;byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1560C>T	p.=	p.S520S	ENST00000313028	6/11	34	24	10	33			PARP10,synonymous_variant,p.S520S,ENST00000313028,NM_032789.3,c.1560C>T,LOW,YES,,,-1;PARP10,synonymous_variant,p.S520S,ENST00000524918,,c.1560C>T,LOW,,,,-1;PARP10,synonymous_variant,p.S532S,ENST00000525773,,c.1596C>T,LOW,,,,-1;PARP10,downstream_gene_variant,,ENST00000313059,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000525879,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000528136,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000529842,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000528625,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000528914,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000530478,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000531537,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000525486,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000529311,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000531707,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000532311,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000533665,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000534737,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000532660,,,MODIFIER,,,,-1;PARP10,synonymous_variant,p.S520S,ENST00000527262,,c.1560C>T,LOW,,,,-1;PARP10,non_coding_transcript_exon_variant,,ENST00000526007,,n.29C>T,MODIFIER,,,,-1;PARP10,non_coding_transcript_exon_variant,,ENST00000528963,,n.198C>T,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000526985,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000528580,,,MODIFIER,,,,-1	A	ENSG00000178685	ENST00000313028	Transcript	synonymous_variant	synonymous_variant	1655/3497	1560/3078	520/1025	S	agC/agT	rs371073478	1		-1	PARP10	HGNC	HGNC:25895	protein_coding	YES	CCDS34960.1	ENSP00000325618	Q53GL7		UPI0000251FAB	NM_032789.3			6/11										0.0005	0								LOW	1	SNV	1			1	4.942e-05	5.015e-05	0.0002976	0	0	0	4.577e-05	0	0		PASS	CTGGCGCTGCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3898092	True	Unknown
PARP10	84875	BI	GRCh38	chr8	143984953	143984953	+	Missense_Mutation	SNP	C	C	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1049G>C	p.Ser350Thr	p.S350T	ENST00000313028	5/11	75	64	11	89			PARP10,missense_variant,p.S350T,ENST00000313028,NM_032789.3,c.1049G>C,MODERATE,YES,tolerated(0.38),benign(0.002),-1;PARP10,missense_variant,p.S350T,ENST00000524918,,c.1049G>C,MODERATE,,tolerated(0.36),benign(0.039),-1;PARP10,missense_variant,p.S362T,ENST00000525773,,c.1085G>C,MODERATE,,tolerated(0.4),benign(0.003),-1;PARP10,missense_variant,p.S265T,ENST00000313059,,c.794G>C,MODERATE,,tolerated(0.18),benign(0.442),-1;PARP10,downstream_gene_variant,,ENST00000525879,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000528136,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000529842,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000528625,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000528914,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000530478,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000531537,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000525486,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000529311,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000531707,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000532311,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000533665,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000534737,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000532660,,,MODIFIER,,,,-1;PARP10,missense_variant,p.S350T,ENST00000527262,,c.1049G>C,MODERATE,,tolerated(0.25),benign(0.135),-1;PARP10,upstream_gene_variant,,ENST00000526007,,,MODIFIER,,,,-1;PARP10,upstream_gene_variant,,ENST00000528963,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000526985,,,MODIFIER,,,,-1;PARP10,downstream_gene_variant,,ENST00000528580,,,MODIFIER,,,,-1	G	ENSG00000178685	ENST00000313028	Transcript	missense_variant	missense_variant	1144/3497	1049/3078	350/1025	S/T	aGc/aCc		1		-1	PARP10	HGNC	HGNC:25895	protein_coding	YES	CCDS34960.1	ENSP00000325618	Q53GL7		UPI0000251FAB	NM_032789.3	tolerated(0.38)	benign(0.002)	5/11																			MODERATE	1	SNV	1			1											PASS	TCGAGCTGACT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3898094	True	Unknown
PPP1R16A	84988	BI	GRCh38	chr8	144497445	144497445	+	Missense_Mutation	SNP	T	T	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.251T>A	p.Leu84Gln	p.L84Q	ENST00000292539	2/11	28	24	4	52			PPP1R16A,missense_variant,p.L84Q,ENST00000292539,,c.251T>A,MODERATE,YES,deleterious(0.01),probably_damaging(0.981),1;PPP1R16A,missense_variant,p.L84Q,ENST00000435887,NM_032902.5,c.251T>A,MODERATE,,deleterious(0.01),probably_damaging(0.981),1;PPP1R16A,downstream_gene_variant,,ENST00000529009,,,MODIFIER,,,,1;CTD-2517M22.14,splice_acceptor_variant,,ENST00000532766,,n.740-2A>T,HIGH,,,,-1;CTD-2517M22.14,downstream_gene_variant,,ENST00000527086,,,MODIFIER,,,,-1;PPP1R16A,downstream_gene_variant,,ENST00000529283,,,MODIFIER,,,,1;PPP1R16A,downstream_gene_variant,,ENST00000533088,,,MODIFIER,,,,1;PPP1R16A,downstream_gene_variant,,ENST00000533829,,,MODIFIER,,,,1;CTD-2517M22.14,splice_acceptor_variant,,ENST00000569326,,n.2305-2A>T,HIGH,YES,,,-1;PPP1R16A,non_coding_transcript_exon_variant,,ENST00000526183,,n.1207T>A,MODIFIER,,,,1;CTD-2517M22.14,non_coding_transcript_exon_variant,,ENST00000528207,,n.798A>T,MODIFIER,,,,-1;PPP1R16A,non_coding_transcript_exon_variant,,ENST00000532806,,n.100T>A,MODIFIER,,,,1;PPP1R16A,upstream_gene_variant,,ENST00000528430,,,MODIFIER,,,,1;PPP1R16A,upstream_gene_variant,,ENST00000526564,,,MODIFIER,,,,1;CTD-2517M22.14,downstream_gene_variant,,ENST00000528690,,,MODIFIER,,,,-1	A	ENSG00000160972	ENST00000292539	Transcript	missense_variant	missense_variant	1168/2722	251/1587	84/528	L/Q	cTg/cAg		1		1	PPP1R16A	HGNC	HGNC:14941	protein_coding	YES	CCDS6429.1	ENSP00000292539	Q96I34		UPI0000132057		deleterious(0.01)	probably_damaging(0.981)	2/11		PROSITE_profiles:PS50297;Superfamily_domains:SSF48403;PIRSF_domain:PIRSF038159																	MODERATE	1	SNV	2			1											PASS	TGACCTGGAAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3898286	True	Unknown
TPD52L3	89882	BI	GRCh38	chr9	6328606	6328606	+	Missense_Mutation	SNP	C	C	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.11C>A	p.Ala4Asp	p.A4D	ENST00000344545	1/1	119	104	15	120			TPD52L3,missense_variant,p.A4D,ENST00000344545,NM_033516.5,c.11C>A,MODERATE,YES,deleterious(0.01),possibly_damaging(0.643),1;TPD52L3,missense_variant,p.A4D,ENST00000314556,NM_001001874.2,c.11C>A,MODERATE,,deleterious_low_confidence(0.01),possibly_damaging(0.591),1;TPD52L3,missense_variant,p.A4D,ENST00000381428,NM_001001875.3,c.11C>A,MODERATE,,deleterious_low_confidence(0.01),possibly_damaging(0.51),1	A	ENSG00000170777	ENST00000344545	Transcript	missense_variant	missense_variant	232/2296	11/423	4/140	A/D	gCc/gAc		1		1	TPD52L3	HGNC	HGNC:23382	protein_coding	YES	CCDS34986.1	ENSP00000341677	Q96J77		UPI0000367601	NM_033516.5	deleterious(0.01)	possibly_damaging(0.643)	1/1		Pfam_domain:PF04201																	MODERATE	1	SNV				1											PASS	ACATGCCAGGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3907600;COSM3907601;COSM3907602	True	Unknown
ELAVL2	1993	BI	GRCh38	chr9	23762122	23762122	+	Missense_Mutation	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.113A>G	p.Lys38Arg	p.K38R	ENST00000380117	2/7	130	109	21	186			ELAVL2,missense_variant,p.K38R,ENST00000397312,NM_004432.3,c.113A>G,MODERATE,YES,tolerated(0.4),benign(0.004),-1;ELAVL2,missense_variant,p.K38R,ENST00000544538,,c.113A>G,MODERATE,,tolerated(0.4),benign(0.004),-1;ELAVL2,missense_variant,p.K38R,ENST00000223951,NM_001171195.1&NM_001171197.1,c.113A>G,MODERATE,,tolerated(0.38),probably_damaging(0.991),-1;ELAVL2,missense_variant,p.K67R,ENST00000380110,,c.200A>G,MODERATE,,tolerated(0.31),benign(0.01),-1;ELAVL2,missense_variant,p.K38R,ENST00000380117,,c.113A>G,MODERATE,,tolerated(0.4),benign(0.004),-1;ELAVL2,missense_variant,p.K38R,ENST00000440102,,c.113A>G,MODERATE,,tolerated(0.39),benign(0.004),-1;ELAVL2,downstream_gene_variant,,ENST00000462649,,,MODIFIER,,,,-1	C	ENSG00000107105	ENST00000380117	Transcript	missense_variant	missense_variant	657/2370	113/1080	38/359	K/R	aAg/aGg		1		-1	ELAVL2	HGNC	HGNC:3313	protein_coding		CCDS6515.1	ENSP00000369460	Q12926		UPI000013C83F		tolerated(0.4)	benign(0.004)	2/7		TIGRFAM_domain:TIGR01661;Superfamily_domains:SSF54928																	MODERATE		SNV	1			1											PASS	TGGTCTTGCTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3906669;COSM3906670	True	Unknown
SPATA31A6	389730	BI	GRCh38	chr9	42189320	42189320	+	Missense_Mutation	SNP	G	G	A	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.3618G>A	p.Met1206Ile	p.M1206I	ENST00000332857	4/4	197	155	42	270			SPATA31A6,missense_variant,p.M1206I,ENST00000332857,NM_001145196.1,c.3618G>A,MODERATE,YES,tolerated(0.09),benign(0.098),1;SPATA31A6,downstream_gene_variant,,ENST00000496386,,,MODIFIER,,,,1	A	ENSG00000185775	ENST00000332857	Transcript	missense_variant	missense_variant	3647/4209	3618/4032	1206/1343	M/I	atG/atA		1		1	SPATA31A6	HGNC	HGNC:32006	protein_coding	YES	CCDS75837.1	ENSP00000329825	Q5VVP1		UPI0000197F6E	NM_001145196.1	tolerated(0.09)	benign(0.098)	4/4																			MODERATE	1	SNV	5			1											PASS	CTCATGACGGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			False	Unknown
ZFP37	7539	BI	GRCh38	chr9	113044136	113044136	+	Frame_Shift_Del	DEL	T	T	-	rs766714144		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.482delA	p.Asn161IlefsTer24	p.N161Ifs*24	ENST00000374227	4/4	42	26	16	43			ZFP37,frameshift_variant,p.N161Ifs*24,ENST00000374227,NM_003408.2,c.482delA,HIGH,,,,-1;ZFP37,frameshift_variant,p.N162Ifs*24,ENST00000555206,NM_001282518.1,c.485delA,HIGH,,,,-1;ZFP37,frameshift_variant,p.N176Ifs*24,ENST00000553380,NM_001282515.1,c.527delA,HIGH,YES,,,-1;ZNF883,intron_variant,,ENST00000619044,,n.33+5875delA,MODIFIER,,,,-1	-	ENSG00000136866	ENST00000374227	Transcript	frameshift_variant	frameshift_variant	510/6266	482/1893	161/630	N/X	aAt/at	rs766714144	1		-1	ZFP37	HGNC	HGNC:12863	protein_coding		CCDS6787.1	ENSP00000363344	Q9Y6Q3		UPI000013D04B	NM_003408.2			4/4		PROSITE_profiles:PS50318																	HIGH		deletion	1			1											PASS	AAATTATTTTTT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM1241918;COSM4338837	True	Unknown
OR1B1	347169	BI	GRCh38	chr9	122629139	122629139	+	Missense_Mutation	SNP	G	G	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.397C>A	p.His133Asn	p.H133N	ENST00000304833	1/1	39	31	8	74			OR1B1,missense_variant,p.H133N,ENST00000624439,,c.397C>A,MODERATE,YES,deleterious(0.01),benign(0.398),-1;OR1B1,missense_variant,p.H133N,ENST00000304833,NM_001004450.1,c.397C>A,MODERATE,YES,deleterious(0.01),benign(0.398),-1;RP11-64P14.7,intron_variant,,ENST00000419604,,n.279-7967G>T,MODIFIER,YES,,,1;RP11-64P14.7,intron_variant,,ENST00000431442,,n.137-7964G>T,MODIFIER,,,,1;OR1B1,missense_variant,p.H133N,ENST00000623530,,c.397C>A,MODERATE,,deleterious(0.01),benign(0.398),-1	T	ENSG00000171484	ENST00000304833	Transcript	missense_variant	missense_variant	397/957	397/957	133/318	H/N	Cac/Aac		1		-1	OR1B1	HGNC	HGNC:8181	protein_coding	YES	CCDS35126.1	ENSP00000303151	Q8NGR6		UPI0000041DFF	NM_001004450.1	deleterious(0.01)	benign(0.398)	1/1		Pfam_domain:PF00001;Pfam_domain:PF10320;Prints_domain:PR00245;PROSITE_profiles:PS50262;Superfamily_domains:SSF81321																	MODERATE		SNV				1											PASS	ATAGTGCAGGG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3903822	True	Unknown
WDR5	11091	BI	GRCh38	chr9	134158025	134158025	+	3'UTR	SNP	G	G	A	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.*32G>A			ENST00000358625	14/14	41	28	13	49			WDR5,3_prime_UTR_variant,,ENST00000358625,NM_052821.3&NM_017588.2,c.*32G>A,MODIFIER,YES,,,1	A	ENSG00000196363	ENST00000358625	Transcript	3_prime_UTR_variant	3_prime_UTR_variant	1208/3151	-/1005	-/334				1		1	WDR5	HGNC	HGNC:12757	protein_coding	YES	CCDS6981.1	ENSP00000351446	P61964		UPI00000040F5	NM_052821.3;NM_017588.2			14/14																			MODIFIER	1	SNV	1			1											PASS	CTGTCGGGAAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
NELFB	25920	BI	GRCh38	chr9	137256995	137256995	+	Nonsense_Mutation	SNP	G	G	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.538G>T	p.Glu180Ter	p.E180*	ENST00000343053	4/13	52	37	15	60			NELFB,stop_gained,p.E180*,ENST00000343053,NM_015456.3,c.538G>T,HIGH,YES,,,1;C9orf173,downstream_gene_variant,,ENST00000388931,NM_001256699.1,,MODIFIER,YES,,,1;C9orf173,downstream_gene_variant,,ENST00000412566,NM_001004353.3,,MODIFIER,,,,1;C9orf173,downstream_gene_variant,,ENST00000620243,NM_001256701.1,,MODIFIER,,,,1;C9orf173,downstream_gene_variant,,ENST00000611378,NM_001256700.1,,MODIFIER,,,,1;C9orf173-AS1,upstream_gene_variant,,ENST00000612170,,,MODIFIER,YES,,,-1;C9orf173,downstream_gene_variant,,ENST00000622761,,,MODIFIER,,,,1;C9orf173,downstream_gene_variant,,ENST00000620716,,,MODIFIER,,,,1;C9orf173,downstream_gene_variant,,ENST00000610325,,,MODIFIER,,,,1	T	ENSG00000188986	ENST00000343053	Transcript	stop_gained	stop_gained	875/2698	538/1743	180/580	E/*	Gag/Tag		1		1	NELFB	HGNC	HGNC:24324	protein_coding	YES	CCDS7040.1	ENSP00000339495	Q8WX92		UPI0000070699	NM_015456.3			4/13		Pfam_domain:PF06209																	HIGH	1	SNV	1			1											PASS	GTACAGAGCTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3906047	True	Unknown
PFKP	5214	BI	GRCh38	chr10	3105131	3105131	+	Missense_Mutation	SNP	G	G	A	rs746311349		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.637G>A	p.Val213Ile	p.V213I	ENST00000381125	6/22	37	30	7	45			PFKP,missense_variant,p.V205I,ENST00000381075,NM_001242339.1,c.613G>A,MODERATE,,tolerated(0.21),possibly_damaging(0.901),1;PFKP,missense_variant,p.V213I,ENST00000381125,NM_002627.4,c.637G>A,MODERATE,YES,tolerated(0.28),benign(0.235),1;PFKP,missense_variant,p.V175I,ENST00000407806,,c.523G>A,MODERATE,,tolerated(0.26),benign(0.235),1;PFKP,5_prime_UTR_variant,,ENST00000415005,,c.-12G>A,MODIFIER,,,,1;PFKP,5_prime_UTR_variant,,ENST00000468050,,c.-12G>A,MODIFIER,,,,1;PFKP,downstream_gene_variant,,ENST00000607886,,,MODIFIER,,,,1;PFKP,non_coding_transcript_exon_variant,,ENST00000460445,,n.253G>A,MODIFIER,,,,1;PFKP,downstream_gene_variant,,ENST00000421751,,,MODIFIER,,,,1	A	ENSG00000067057	ENST00000381125	Transcript	missense_variant	missense_variant	713/2654	637/2355	213/784	V/I	Gtt/Att	rs746311349	1		1	PFKP	HGNC	HGNC:8878	protein_coding	YES	CCDS7059.1	ENSP00000370517	Q01813		UPI00000012D2	NM_002627.4	tolerated(0.28)	benign(0.235)	6/22		Pfam_domain:PF00365;Prints_domain:PR00476;TIGRFAM_domain:TIGR02478;Superfamily_domains:SSF53784;PIRSF_domain:PIRSF000533																	MODERATE	1	SNV	1			1	8.236e-06	8.32e-06	0	0	0	0	1.51e-05	0	0		PASS	CCTTCGTTCTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4013755;COSM4013756	True	Unknown
ARMC4	55130	BI	GRCh38	chr10	27935201	27935201	+	Missense_Mutation	SNP	C	C	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2304G>T	p.Gln768His	p.Q768H	ENST00000305242	16/20	87	71	15	76			ARMC4,missense_variant,p.Q768H,ENST00000305242,NM_018076.2&NM_001290020.1,c.2304G>T,MODERATE,YES,deleterious(0),probably_damaging(1),-1	A	ENSG00000169126	ENST00000305242	Transcript	missense_variant	missense_variant	2397/3572	2304/3135	768/1044	Q/H	caG/caT		1		-1	ARMC4	HGNC	HGNC:25583	protein_coding	YES	CCDS7157.1	ENSP00000306410	Q5T2S8		UPI00001A95E1	NM_018076.2;NM_001290020.1	deleterious(0)	probably_damaging(1)	16/20		Pfam_domain:PF05804;SMART_domains:SM00185;Superfamily_domains:SSF48371																	MODERATE	1	SNV	2			1											PASS	TCAGGCTGATC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4013604;COSM4439084	True	Unknown
TACC2	10579	BI	GRCh38	chr10	122083781	122083781	+	Silent	SNP	T	T	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1281T>A	p.=	p.A427A	ENST00000334433	3/22	68	51	16	109			TACC2,synonymous_variant,p.A427A,ENST00000369005,NM_206862.2,c.1281T>A,LOW,YES,,,1;TACC2,synonymous_variant,p.A427A,ENST00000334433,,c.1281T>A,LOW,,,,1;TACC2,synonymous_variant,p.A427A,ENST00000515273,NM_001291877.1,c.1281T>A,LOW,,,,1;TACC2,synonymous_variant,p.A427A,ENST00000453444,,c.1281T>A,LOW,,,,1;TACC2,synonymous_variant,p.A427A,ENST00000515603,NM_001291876.1,c.1281T>A,LOW,,,,1;TACC2,intron_variant,,ENST00000513429,NM_206861.1,c.146+33231T>A,MODIFIER,,,,1;TACC2,intron_variant,,ENST00000358010,,c.146+33231T>A,MODIFIER,,,,1;TACC2,downstream_gene_variant,,ENST00000491540,,,MODIFIER,,,,1;TACC2,downstream_gene_variant,,ENST00000498721,,,MODIFIER,,,,1	A	ENSG00000138162	ENST00000334433	Transcript	synonymous_variant	synonymous_variant	1327/9377	1281/8847	427/2948	A	gcT/gcA		1		1	TACC2	HGNC	HGNC:11523	protein_coding		CCDS7626.1	ENSP00000334280	O95359		UPI0000246F6B				3/22																			LOW		SNV	1			1											PASS	CCAGCTGCTCA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4012227;COSM4012228	True	Unknown
MUC5B	727897	BI	GRCh38	chr11	1245844	1245844	+	Silent	SNP	G	G	A	rs552609450	by1000G	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.8964G>A	p.=	p.G2988G	ENST00000529681	31/49	141	114	27	229			MUC5B,synonymous_variant,p.G2988G,ENST00000529681,NM_002458.2,c.8964G>A,LOW,YES,,,1;RP11-532E4.2,intron_variant,,ENST00000532061,,n.57-3206C>T,MODIFIER,YES,,,-1	A	ENSG00000117983	ENST00000529681	Transcript	synonymous_variant	synonymous_variant	9022/17911	8964/17289	2988/5762	G	ggG/ggA	rs552609450	1		1	MUC5B	HGNC	HGNC:7516	protein_coding	YES	CCDS44515.2	ENSP00000436812	Q9HC84		UPI0001DD21C7	NM_002458.2			31/49		Low_complexity_(Seg):Seg;PROSITE_profiles:PS50325	0.0002	0.0000	0.0000		0.0010	0.0000	0.0000										LOW	1	SNV	5			1											PASS	CCAGGGACGAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4019181;COSM4019182	True	Unknown
OR51E1	143503	BI	GRCh38	chr11	4653436	4653436	+	Missense_Mutation	SNP	C	C	T	rs200993659	byCluster	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.910C>T	p.Arg304Cys	p.R304C	ENST00000396952	2/2	77	61	16	111			OR51E1,missense_variant,p.R304C,ENST00000396952,NM_152430.3,c.910C>T,MODERATE,YES,deleterious(0),probably_damaging(0.992),1;OR51E1,3_prime_UTR_variant,,ENST00000530215,,c.*21C>T,MODIFIER,,,,1	T	ENSG00000180785	ENST00000396952	Transcript	missense_variant	missense_variant	1560/3612	910/957	304/318	R/C	Cgc/Tgc	rs200993659	1		1	OR51E1	HGNC	HGNC:15194	protein_coding	YES	CCDS31358.2	ENSP00000380155	Q8TCB6		UPI000003ACE2	NM_152430.3	deleterious(0)	probably_damaging(0.992)	2/2		Superfamily_domains:SSF81321																	MODERATE	1	SNV				1	3.295e-05	3.327e-05	9.737e-05	0	0	0	1.511e-05	0	0.0001246		PASS	GACAGCGCATC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM1980885	True	Unknown
TRIM5	85363	BI	GRCh38	chr11	5665528	5665528	+	Intron	SNP	G	G	A	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.895+128C>T			ENST00000380034		38	32	6	51			TRIM5,synonymous_variant,p.H341H,ENST00000396847,NM_033092.2,c.1023C>T,LOW,,,,-1;TRIM5,intron_variant,,ENST00000380034,NM_033034.2,c.895+128C>T,MODIFIER,YES,,,-1;TRIM5,intron_variant,,ENST00000380027,NM_033093.2,c.895+128C>T,MODIFIER,,,,-1;TRIM5,intron_variant,,ENST00000438025,,c.424+128C>T,MODIFIER,,,,-1;TRIM5,non_coding_transcript_exon_variant,,ENST00000492086,,n.554C>T,MODIFIER,,,,-1;TRIM5,intron_variant,,ENST00000483835,,n.575+128C>T,MODIFIER,,,,-1;TRIM5,downstream_gene_variant,,ENST00000465634,,,MODIFIER,,,,-1;TRIM5,intron_variant,,ENST00000433961,,c.*56+128C>T,MODIFIER,,,,-1	A	ENSG00000132256	ENST00000380034	Transcript	intron_variant	intron_variant	-/2991	-/1482	-/493				1		-1	TRIM5	HGNC	HGNC:16276	protein_coding	YES	CCDS31393.1	ENSP00000369373	Q9C035		UPI00000717A7	NM_033034.2				7/7																		MODIFIER	1	SNV	2			1											PASS	GTTATGTGTGT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
OR2D2	120776	BI	GRCh38	chr11	6891810	6891810	+	Missense_Mutation	SNP	T	T	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.691A>C	p.Thr231Pro	p.T231P	ENST00000299459	1/1	50	33	17	73			OR2D2,missense_variant,p.T231P,ENST00000299459,NM_003700.1,c.691A>C,MODERATE,YES,deleterious(0.01),possibly_damaging(0.555),-1	G	ENSG00000166368	ENST00000299459	Transcript	missense_variant	missense_variant	790/1110	691/927	231/308	T/P	Act/Cct		1		-1	OR2D2	HGNC	HGNC:8244	protein_coding	YES	CCDS31416.1	ENSP00000299459	Q9H210		UPI0000061F0B	NM_003700.1	deleterious(0.01)	possibly_damaging(0.555)	1/1		Pfam_domain:PF00001;Pfam_domain:PF10320;PROSITE_profiles:PS50262;Superfamily_domains:SSF81321																	MODERATE	1	SNV				1											PASS	CACAGTTGACT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4036221	True	Unknown
MRGPRX1	259249	BI	GRCh38	chr11	18934791	18934791	+	5'UTR	SNP	A	A	T	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.-7T>A			ENST00000302797	1/1	139	80	59	179			MRGPRX1,5_prime_UTR_variant,,ENST00000302797,NM_147199.3,c.-7T>A,MODIFIER,YES,,,-1;RP11-583F24.8,upstream_gene_variant,,ENST00000528646,,,MODIFIER,YES,,,1;MRGPRX1,non_coding_transcript_exon_variant,,ENST00000526914,,n.247T>A,MODIFIER,,,,-1	T	ENSG00000170255	ENST00000302797	Transcript	5_prime_UTR_variant	5_prime_UTR_variant	212/1190	-/969	-/322				1		-1	MRGPRX1	HGNC	HGNC:17962	protein_coding	YES	CCDS7846.1	ENSP00000305766	Q96LB2	W8W3P5	UPI000003BCCF	NM_147199.3			1/1																			MODIFIER		SNV				1											PASS	CTCAGAAACCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
ACCSL	390110	BI	GRCh38	chr11	44053034	44053034	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.914A>C	p.Lys305Thr	p.K305T	ENST00000378832	7/14	47	33	14	73			ACCSL,missense_variant,p.K305T,ENST00000378832,NM_001031854.2,c.914A>C,MODERATE,YES,deleterious(0),probably_damaging(0.993),1;ACCSL,3_prime_UTR_variant,,ENST00000527145,,c.*433A>C,MODIFIER,,,,1	C	ENSG00000205126	ENST00000378832	Transcript	missense_variant	missense_variant	970/1820	914/1707	305/568	K/T	aAg/aCg		1		1	ACCSL	HGNC	HGNC:34391	protein_coding	YES	CCDS41636.1	ENSP00000368109	Q4AC99		UPI000023785D	NM_001031854.2	deleterious(0)	probably_damaging(0.993)	7/14		Pfam_domain:PF00155;Superfamily_domains:SSF53383																	MODERATE	1	SNV	1			1											PASS	GGACAAGTTAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4032797	True	Unknown
SCGB1D4	404552	BI	GRCh38	chr11	62297494	62297494	+	Nonsense_Mutation	SNP	G	G	A	rs752348321	byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.220C>T	p.Arg74Ter	p.R74*	ENST00000358585	2/3	227	183	44	294			SCGB1D4,stop_gained,p.R74*,ENST00000358585,NM_206998.1,c.220C>T,HIGH,YES,,,-1	A	ENSG00000197745	ENST00000358585	Transcript	stop_gained	stop_gained	274/439	220/252	74/83	R/*	Cga/Tga	rs752348321	1		-1	SCGB1D4	HGNC	HGNC:31748	protein_coding	YES	CCDS31583.1	ENSP00000351395	Q6XE38		UPI0000049DF4	NM_206998.1			2/3		Low_complexity_(Seg):Seg;Pfam_domain:PF01099;Superfamily_domains:SSF48201																	HIGH	1	SNV	1			1	2.471e-05	2.475e-05	0.0001923	0	0	0	1.501e-05	0	0		PASS	GAGTCGTTTCT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4034707	True	Unknown
AHNAK	79026	BI	GRCh38	chr11	62531109	62531109	+	Missense_Mutation	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.3308T>C	p.Ile1103Thr	p.I1103T	ENST00000378024	5/5	79	49	30	118			AHNAK,missense_variant,p.I1103T,ENST00000378024,NM_001620.2,c.3308T>C,MODERATE,YES,,possibly_damaging(0.669),-1;AHNAK,intron_variant,,ENST00000257247,NM_024060.3,c.342+3894T>C,MODIFIER,,,,-1;AHNAK,intron_variant,,ENST00000530124,,c.342+3894T>C,MODIFIER,,,,-1;AHNAK,intron_variant,,ENST00000533365,,c.342+3894T>C,MODIFIER,,,,-1;AHNAK,downstream_gene_variant,,ENST00000530285,,,MODIFIER,,,,-1;AHNAK,downstream_gene_variant,,ENST00000531324,,,MODIFIER,,,,-1;AHNAK,downstream_gene_variant,,ENST00000528508,,,MODIFIER,,,,-1	G	ENSG00000124942	ENST00000378024	Transcript	missense_variant	missense_variant	3583/18787	3308/17673	1103/5890	I/T	aTc/aCc		1		-1	AHNAK	HGNC	HGNC:347	protein_coding	YES	CCDS31584.1	ENSP00000367263	Q09666		UPI00004EC29C	NM_001620.2		possibly_damaging(0.669)	5/5																			MODERATE	1	SNV	2			1											PASS	CTCTGATGTCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4034748;COSM4907565	True	Unknown
FAM89B	23625	BI	GRCh38	chr11	65573565	65573565	+	Missense_Mutation	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.494C>T	p.Pro165Leu	p.P165L	ENST00000530349	2/2	36	25	11	89			FAM89B,missense_variant,p.P152L,ENST00000316409,NM_152832.2,c.455C>T,MODERATE,,tolerated(0.09),probably_damaging(0.96),1;FAM89B,missense_variant,p.P165L,ENST00000530349,NM_001098785.1,c.494C>T,MODERATE,YES,tolerated(0.05),probably_damaging(0.995),1;FAM89B,3_prime_UTR_variant,,ENST00000449319,NM_001098784.1,c.*39C>T,MODIFIER,,,,1;SSSCA1,3_prime_UTR_variant,,ENST00000526433,,c.*39C>T,MODIFIER,,,,1;EHBP1L1,upstream_gene_variant,,ENST00000309295,NM_001099409.1,,MODIFIER,YES,,,1;EHBP1L1,upstream_gene_variant,,ENST00000533237,,,MODIFIER,,,,1;SSSCA1,downstream_gene_variant,,ENST00000533115,,,MODIFIER,,,,1;SSSCA1,downstream_gene_variant,,ENST00000531405,NM_001303024.1,,MODIFIER,,,,1;SSSCA1,downstream_gene_variant,,ENST00000527920,,,MODIFIER,,,,1;SSSCA1,downstream_gene_variant,,ENST00000526877,,,MODIFIER,,,,1;SSSCA1,downstream_gene_variant,,ENST00000309328,NM_006396.1,,MODIFIER,YES,,,1;SSSCA1-AS1,upstream_gene_variant,,ENST00000567594,,,MODIFIER,,,,-1;SSSCA1-AS1,upstream_gene_variant,,ENST00000623234,,,MODIFIER,YES,,,-1;EHBP1L1,upstream_gene_variant,,ENST00000531106,,,MODIFIER,,,,1;SSSCA1,downstream_gene_variant,,ENST00000527413,,,MODIFIER,,,,1	T	ENSG00000176973	ENST00000530349	Transcript	missense_variant	missense_variant	636/1263	494/570	165/189	P/L	cCg/cTg		1		1	FAM89B	HGNC	HGNC:16708	protein_coding	YES	CCDS53662.1	ENSP00000431459	Q8N5H3		UPI00001FABAE	NM_001098785.1	tolerated(0.05)	probably_damaging(0.995)	2/2		Low_complexity_(Seg):Seg																	MODERATE		SNV	2			1											PASS	TGACCCGCCAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4035428	True	Unknown
ANKRD42	338699	BI	GRCh38	chr11	83227859	83227859	+	Silent	SNP	T	T	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.816T>A	p.=	p.T272T	ENST00000393392	7/10	138	103	35	120			ANKRD42,synonymous_variant,p.T299T,ENST00000260047,NM_001300973.1&NM_001300972.1,c.897T>A,LOW,,,,1;ANKRD42,synonymous_variant,p.T272T,ENST00000393392,NM_182603.2,c.816T>A,LOW,YES,,,1;ANKRD42,synonymous_variant,p.T300T,ENST00000533342,,c.900T>A,LOW,,,,1;ANKRD42,synonymous_variant,p.T300T,ENST00000531895,,c.900T>A,LOW,,,,1;ANKRD42,synonymous_variant,p.T25T,ENST00000531815,,c.75T>A,LOW,,,,1	A	ENSG00000137494	ENST00000393392	Transcript	synonymous_variant	synonymous_variant	978/2302	816/1170	272/389	T	acT/acA		1		1	ANKRD42	HGNC	HGNC:26752	protein_coding	YES	CCDS8265.1	ENSP00000377051	Q8N9B4		UPI000013D0A8	NM_182603.2			7/10		Pfam_domain:PF00023;PROSITE_profiles:PS50088;PROSITE_profiles:PS50297;SMART_domains:SM00248;Superfamily_domains:SSF48403																	LOW	1	SNV	2			1											PASS	TCAACTCCTAT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4037109	True	Unknown
EXPH5	23086	BI	GRCh38	chr11	108512803	108512803	+	Missense_Mutation	SNP	A	A	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2704T>A	p.Ser902Thr	p.S902T	ENST00000265843	6/6	107	91	16	101			EXPH5,missense_variant,p.S902T,ENST00000265843,NM_015065.2,c.2704T>A,MODERATE,YES,deleterious(0.02),possibly_damaging(0.897),-1;EXPH5,missense_variant,p.S895T,ENST00000525344,,c.2683T>A,MODERATE,,deleterious(0.02),possibly_damaging(0.897),-1;EXPH5,missense_variant,p.S826T,ENST00000526312,,c.2476T>A,MODERATE,,deleterious(0.01),possibly_damaging(0.796),-1;EXPH5,missense_variant,p.S714T,ENST00000533052,,c.2140T>A,MODERATE,,deleterious(0.01),possibly_damaging(0.796),-1;EXPH5,downstream_gene_variant,,ENST00000524840,,,MODIFIER,,,,-1	T	ENSG00000110723	ENST00000265843	Transcript	missense_variant	missense_variant	2815/10187	2704/5970	902/1989	S/T	Tct/Act		1		-1	EXPH5	HGNC	HGNC:30578	protein_coding	YES	CCDS8341.1	ENSP00000265843	Q8NEV8		UPI00018E24EB	NM_015065.2	deleterious(0.02)	possibly_damaging(0.897)	6/6																			MODERATE	1	SNV	1			1											PASS	AGTAGATGGAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4017680	True	Unknown
ARHGAP20	57569	BI	GRCh38	chr11	110580376	110580376	+	Missense_Mutation	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2570T>C	p.Leu857Pro	p.L857P	ENST00000260283	16/16	60	51	9	75			ARHGAP20,missense_variant,p.L857P,ENST00000260283,NM_020809.3,c.2570T>C,MODERATE,YES,deleterious(0),probably_damaging(0.969),-1;ARHGAP20,missense_variant,p.L834P,ENST00000524756,NM_001258415.1,c.2501T>C,MODERATE,,deleterious(0),probably_damaging(0.986),-1;ARHGAP20,missense_variant,p.L831P,ENST00000533353,NM_001258416.1,c.2492T>C,MODERATE,,deleterious(0),probably_damaging(0.986),-1;ARHGAP20,missense_variant,p.L821P,ENST00000527598,NM_001258418.1,c.2462T>C,MODERATE,,deleterious(0),probably_damaging(0.969),-1;ARHGAP20,missense_variant,p.L821P,ENST00000528829,NM_001258417.1,c.2462T>C,MODERATE,,deleterious(0),probably_damaging(0.969),-1;ARHGAP20,missense_variant,p.L400P,ENST00000529591,,c.1199T>C,MODERATE,,deleterious(0),probably_damaging(0.992),-1	G	ENSG00000137727	ENST00000260283	Transcript	missense_variant	missense_variant	2855/6189	2570/3576	857/1191	L/P	cTg/cCg		1		-1	ARHGAP20	HGNC	HGNC:18357	protein_coding	YES	CCDS31673.1	ENSP00000260283	Q9P2F6		UPI000013D0BA	NM_020809.3	deleterious(0)	probably_damaging(0.969)	16/16																			MODERATE	1	SNV	1			1											PASS	AGGTCAGCTTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4017741;COSM4017742	True	Unknown
BCO2	83875	BI	GRCh38	chr11	112175680	112175680	+	Missense_Mutation	SNP	C	C	T	rs149163526	byCluster	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.79C>T	p.Arg27Trp	p.R27W	ENST00000357685	1/12	78	68	10	70			BCO2,missense_variant,p.R27W,ENST00000357685,NM_031938.5,c.79C>T,MODERATE,YES,tolerated_low_confidence(0.19),benign(0.002),1;BCO2,missense_variant,p.R27W,ENST00000361053,NM_001256398.1,c.79C>T,MODERATE,,tolerated_low_confidence(0.19),benign(0.013),1;BCO2,missense_variant,p.R4W,ENST00000532612,,c.9C>T,MODERATE,,tolerated_low_confidence(0.27),benign(0.011),1;BCO2,upstream_gene_variant,,ENST00000438022,NM_001037290.2,,MODIFIER,,,,1;BCO2,upstream_gene_variant,,ENST00000531169,,,MODIFIER,,,,1;BCO2,upstream_gene_variant,,ENST00000526088,NM_001256397.1,,MODIFIER,,,,1;BCO2,upstream_gene_variant,,ENST00000532593,NM_001256400.1,,MODIFIER,,,,1;TEX12,downstream_gene_variant,,ENST00000280358,NM_031275.4,,MODIFIER,YES,,,1;TEX12,downstream_gene_variant,,ENST00000530752,,,MODIFIER,,,,1;RP11-356J5.4,upstream_gene_variant,,ENST00000527589,,,MODIFIER,YES,,,-1;AP002884.2,intron_variant,,ENST00000525468,,n.282+5150C>T,MODIFIER,,,,1;BCO2,missense_variant,p.R27W,ENST00000527939,,c.79C>T,MODERATE,,deleterious_low_confidence(0),unknown(0),1;BCO2,missense_variant,p.R27W,ENST00000534550,,c.79C>T,MODERATE,,deleterious_low_confidence(0),unknown(0),1;BCO2,missense_variant,p.R27W,ENST00000531003,,c.79C>T,MODERATE,,tolerated(0.2),benign(0.002),1;BCO2,non_coding_transcript_exon_variant,,ENST00000460924,,n.171C>T,MODIFIER,,,,1;BCO2,non_coding_transcript_exon_variant,,ENST00000494860,,n.136C>T,MODIFIER,,,,1;BCO2,non_coding_transcript_exon_variant,,ENST00000461480,,n.169C>T,MODIFIER,,,,1;AP002884.2,intron_variant,,ENST00000525987,,n.432-3598C>T,MODIFIER,,,,1;AP002884.2,intron_variant,,ENST00000532699,,c.*55+5006C>T,MODIFIER,YES,,,1;AP002884.2,intron_variant,,ENST00000531744,,c.*56-3598C>T,MODIFIER,,,,1;BCO2,upstream_gene_variant,,ENST00000534122,,,MODIFIER,,,,1	T	ENSG00000197580	ENST00000357685	Transcript	missense_variant	missense_variant	214/2930	79/1740	27/579	R/W	Cgg/Tgg	rs149163526	1		1	BCO2	HGNC	HGNC:18503	protein_coding	YES	CCDS8358.2	ENSP00000350314	Q9BYV7		UPI00005FB124	NM_031938.5	tolerated_low_confidence(0.19)	benign(0.002)	1/12										0	0.0001								MODERATE	1	SNV	1			1	8.236e-06	8.239e-06	0	0	0	0	1.499e-05	0	0		PASS	TGCACCGGCTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4017855	True	Unknown
IL10RA	3587	BI	GRCh38	chr11	117993391	117993391	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.518A>C	p.Lys173Thr	p.K173T	ENST00000227752	4/7	83	71	12	67			IL10RA,missense_variant,p.K173T,ENST00000227752,NM_001558.3,c.518A>C,MODERATE,YES,deleterious(0.01),possibly_damaging(0.577),1;IL10RA,non_coding_transcript_exon_variant,,ENST00000533700,,n.725A>C,MODIFIER,,,,1;IL10RA,non_coding_transcript_exon_variant,,ENST00000534335,,n.338A>C,MODIFIER,,,,1;IL10RA,3_prime_UTR_variant,,ENST00000534574,,c.*458A>C,MODIFIER,,,,1;IL10RA,3_prime_UTR_variant,,ENST00000526544,,c.*54A>C,MODIFIER,,,,1;IL10RA,non_coding_transcript_exon_variant,,ENST00000529924,,n.2096A>C,MODIFIER,,,,1;IL10RA,non_coding_transcript_exon_variant,,ENST00000530761,,n.895A>C,MODIFIER,,,,1;IL10RA,non_coding_transcript_exon_variant,,ENST00000530178,,n.384A>C,MODIFIER,,,,1;IL10RA,non_coding_transcript_exon_variant,,ENST00000532009,,n.334A>C,MODIFIER,,,,1;IL10RA,upstream_gene_variant,,ENST00000525467,,,MODIFIER,,,,1;IL10RA,downstream_gene_variant,,ENST00000531365,,,MODIFIER,,,,1	C	ENSG00000110324	ENST00000227752	Transcript	missense_variant	missense_variant	638/3695	518/1737	173/578	K/T	aAg/aCg		1		1	IL10RA	HGNC	HGNC:5964	protein_coding	YES	CCDS8388.1	ENSP00000227752	Q13651		UPI000013C8BF	NM_001558.3	deleterious(0.01)	possibly_damaging(0.577)	4/7		Superfamily_domains:SSF49265																	MODERATE	1	SNV	1			1											PASS	TCGCAAGGTGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4018234	True	Unknown
SC5D	6309	BI	GRCh38	chr11	121303382	121303382	+	Missense_Mutation	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.7C>T	p.Leu3Phe	p.L3F	ENST00000264027	2/5	98	87	11	66			SC5D,missense_variant,p.L3F,ENST00000264027,NM_006918.4,c.7C>T,MODERATE,YES,deleterious(0.01),possibly_damaging(0.488),1;SC5D,missense_variant,p.L3F,ENST00000392789,NM_001024956.2,c.7C>T,MODERATE,,deleterious(0.01),possibly_damaging(0.488),1;SC5D,missense_variant,p.L3F,ENST00000534230,,c.7C>T,MODERATE,,deleterious(0.02),benign(0.35),1;SC5D,missense_variant,p.L3F,ENST00000527762,,c.7C>T,MODERATE,,deleterious(0.02),possibly_damaging(0.678),1;SC5D,upstream_gene_variant,,ENST00000528991,,,MODIFIER,,,,1;SC5D,non_coding_transcript_exon_variant,,ENST00000524683,,n.63C>T,MODIFIER,,,,1;SC5D,non_coding_transcript_exon_variant,,ENST00000534455,,n.153C>T,MODIFIER,,,,1;SC5D,non_coding_transcript_exon_variant,,ENST00000531140,,n.75C>T,MODIFIER,,,,1;SC5D,upstream_gene_variant,,ENST00000527183,,,MODIFIER,,,,1	T	ENSG00000109929	ENST00000264027	Transcript	missense_variant	missense_variant	381/2456	7/900	3/299	L/F	Ctt/Ttt		1		1	SC5D	HGNC	HGNC:10547	protein_coding	YES	CCDS8435.1	ENSP00000264027	O75845	A0A024R3G4	UPI000013D4A4	NM_006918.4	deleterious(0.01)	possibly_damaging(0.488)	2/5																			MODERATE	1	SNV	1			1											PASS	TGGATCTTGTA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4018686	True	Unknown
TMEM225	338661	BI	GRCh38	chr11	123884155	123884155	+	Missense_Mutation	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.383A>G	p.Gln128Arg	p.Q128R	ENST00000375026	3/4	102	74	28	93			TMEM225,missense_variant,p.Q128R,ENST00000375026,NM_001013743.1,c.383A>G,MODERATE,YES,deleterious(0.01),possibly_damaging(0.607),-1;TMEM225,missense_variant,p.Q78R,ENST00000528595,,c.233A>G,MODERATE,,deleterious(0.04),benign(0.136),-1	C	ENSG00000204300	ENST00000375026	Transcript	missense_variant	missense_variant	600/1107	383/678	128/225	Q/R	cAa/cGa		1		-1	TMEM225	HGNC	HGNC:32390	protein_coding	YES	CCDS31697.1	ENSP00000364166	Q6GV28		UPI000443236D	NM_001013743.1	deleterious(0.01)	possibly_damaging(0.607)	3/4																			MODERATE	1	SNV	1			1											PASS	TGGATTGACCT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4018846	True	Unknown
PRB2	653247	BI	GRCh38	chr12	11393811	11393811	+	Silent	SNP	A	A	G	rs758143951	byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.267T>C	p.=	p.P89P	ENST00000389362	3/4	251	213	37	239			PRB2,synonymous_variant,p.P89P,ENST00000389362,NM_006248.3,c.267T>C,LOW,YES,,,-1;PRB1,intron_variant,,ENST00000546254,,c.100+684T>C,MODIFIER,,,,-1;PRB2,downstream_gene_variant,,ENST00000565533,,,MODIFIER,,,,-1;PRB2,downstream_gene_variant,,ENST00000545829,,,MODIFIER,,,,-1	G	ENSG00000121335	ENST00000389362	Transcript	synonymous_variant	synonymous_variant	303/1429	267/1251	89/416	P	ccT/ccC	rs758143951	1		-1	PRB2	HGNC	HGNC:9338	protein_coding	YES	CCDS41757.2	ENSP00000374013	P02812			NM_006248.3			3/4		Low_complexity_(Seg):Seg;PROSITE_profiles:PS50315;PROSITE_profiles:PS50099																	LOW	1	SNV	5			1	1.660e-05	1.798e-05	0	0	0	0	0	0	0.0001323		PASS	CCTTGAGGTTT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4039079;COSM4039080	True	Unknown
SLCO1C1	53919	BI	GRCh38	chr12	20723157	20723157	+	Silent	SNP	T	T	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1089T>A	p.=	p.T363T	ENST00000266509	9/15	82	68	14	66			SLCO1C1,synonymous_variant,p.T363T,ENST00000266509,NM_017435.4,c.1089T>A,LOW,,,,1;SLCO1C1,synonymous_variant,p.T245T,ENST00000545102,NM_001145944.1,c.735T>A,LOW,,,,1;SLCO1C1,synonymous_variant,p.T363T,ENST00000545604,NM_001145946.1,c.1089T>A,LOW,YES,,,1;SLCO1C1,synonymous_variant,p.T314T,ENST00000540354,NM_001145945.1,c.942T>A,LOW,,,,1;SLCO1C1,3_prime_UTR_variant,,ENST00000539415,,c.*673T>A,MODIFIER,,,,1	A	ENSG00000139155	ENST00000266509	Transcript	synonymous_variant	synonymous_variant	1457/3365	1089/2139	363/712	T	acT/acA		1		1	SLCO1C1	HGNC	HGNC:13819	protein_coding		CCDS8683.1	ENSP00000266509	Q9NYB5		UPI00000557C4	NM_017435.4			9/15		Pfam_domain:PF03137;Pfam_domain:PF07690;Pfam_domain:PF00083;Transmembrane_helices:Tmhmm;TIGRFAM_domain:TIGR00805;PROSITE_profiles:PS50850;Superfamily_domains:SSF103473																	LOW		SNV	1			1											PASS	AGCACTGTTCA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4040736;COSM4040737	True	Unknown
KRT73	319101	BI	GRCh38	chr12	52616372	52616372	+	Silent	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.456C>T	p.=	p.F152F	ENST00000305748	2/9	47	32	15	53			KRT73,synonymous_variant,p.F152F,ENST00000305748,NM_175068.2,c.456C>T,LOW,YES,,,-1;KRT73,upstream_gene_variant,,ENST00000552855,,,MODIFIER,,,,-1;KRT73-AS1,downstream_gene_variant,,ENST00000552364,,,MODIFIER,YES,,,1;KRT73-AS1,downstream_gene_variant,,ENST00000549180,,,MODIFIER,,,,1;KRT73-AS1,downstream_gene_variant,,ENST00000551089,,,MODIFIER,,,,1;KRT73,non_coding_transcript_exon_variant,,ENST00000546934,,n.481C>T,MODIFIER,,,,-1	A	ENSG00000186049	ENST00000305748	Transcript	synonymous_variant	synonymous_variant	491/2284	456/1623	152/540	F	ttC/ttT		1		-1	KRT73	HGNC	HGNC:28928	protein_coding	YES	CCDS8834.1	ENSP00000307014	Q86Y46		UPI000000DCB8	NM_175068.2			2/9		Pfam_domain:PF00038																	LOW	1	SNV	1			1											PASS	TCCAGGAACCG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4042895	True	Unknown
DGKA	1606	BI	GRCh38	chr12	55941521	55941521	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1187A>C	p.Lys396Thr	p.K396T	ENST00000331886	15/24	160	124	36	173			DGKA,missense_variant,p.K396T,ENST00000331886,NM_001345.4,c.1187A>C,MODERATE,YES,deleterious(0.03),probably_damaging(1),1;DGKA,missense_variant,p.K396T,ENST00000394147,NM_201444.2&NM_201554.1&NM_201445.1,c.1187A>C,MODERATE,,deleterious(0.03),probably_damaging(1),1;DGKA,missense_variant,p.K396T,ENST00000551156,,c.1187A>C,MODERATE,,deleterious(0.03),probably_damaging(1),1;DGKA,missense_variant,p.K315T,ENST00000555218,,c.944A>C,MODERATE,,deleterious(0.03),probably_damaging(0.999),1;DGKA,intron_variant,,ENST00000552903,,c.80+196A>C,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000551707,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000432422,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000555090,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000549368,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000553783,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000546878,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000549629,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000555025,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000547015,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000557080,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000556001,,,MODIFIER,,,,1;DGKA,non_coding_transcript_exon_variant,,ENST00000549079,,n.913A>C,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000549323,,,MODIFIER,,,,1;DGKA,3_prime_UTR_variant,,ENST00000402956,,c.*354A>C,MODIFIER,,,,1;DGKA,3_prime_UTR_variant,,ENST00000553084,,c.*841A>C,MODIFIER,,,,1;DGKA,3_prime_UTR_variant,,ENST00000557180,,c.*301A>C,MODIFIER,,,,1;DGKA,non_coding_transcript_exon_variant,,ENST00000552478,,n.3272A>C,MODIFIER,,,,1;DGKA,non_coding_transcript_exon_variant,,ENST00000551739,,n.2139A>C,MODIFIER,,,,1;DGKA,non_coding_transcript_exon_variant,,ENST00000551296,,n.2802A>C,MODIFIER,,,,1;DGKA,non_coding_transcript_exon_variant,,ENST00000548047,,n.1317A>C,MODIFIER,,,,1;DGKA,non_coding_transcript_exon_variant,,ENST00000551585,,n.53A>C,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000549097,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000547358,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000548407,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000552652,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000552335,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000554434,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000552687,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000546895,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000548479,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000547324,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000546995,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000550888,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000549986,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000547535,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000548549,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000551615,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000556344,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000549085,,,MODIFIER,,,,1;DGKA,downstream_gene_variant,,ENST00000550484,,,MODIFIER,,,,1	C	ENSG00000065357	ENST00000331886	Transcript	missense_variant	missense_variant	1641/2909	1187/2208	396/735	K/T	aAg/aCg		1		1	DGKA	HGNC	HGNC:2849	protein_coding	YES	CCDS8896.1	ENSP00000328405	P23743	A0A024RB23	UPI000007417B	NM_001345.4	deleterious(0.03)	probably_damaging(1)	15/24		Pfam_domain:PF00781;SMART_domains:SM00046																	MODERATE	1	SNV	5			1											PASS	CTGGAAGTTCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4043399	True	Unknown
NAV3	89795	BI	GRCh38	chr12	78205068	78205068	+	Frame_Shift_Del	DEL	G	G	-	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.6968delG	p.Ser2323ThrfsTer24	p.S2323Tfs*24	ENST00000397909	39/40	38	34	4	37			NAV3,frameshift_variant,p.S2323Tfs*24,ENST00000397909,NM_001024383.1,c.6968delG,HIGH,YES,,,1;NAV3,frameshift_variant,p.S2301Tfs*24,ENST00000536525,NM_014903.5,c.6902delG,HIGH,,,,1;NAV3,frameshift_variant,p.S1196Tfs*24,ENST00000552895,,c.3585delG,HIGH,,,,1;NAV3,frameshift_variant,p.S191Tfs*24,ENST00000551162,,c.570delG,HIGH,,,,1;NAV3,downstream_gene_variant,,ENST00000547884,,,MODIFIER,,,,1	-	ENSG00000067798	ENST00000397909	Transcript	frameshift_variant	frameshift_variant	7141/9821	6968/7158	2323/2385	S/X	aGc/ac		1		1	NAV3	HGNC	HGNC:15998	protein_coding	YES	CCDS66432.1	ENSP00000381007	Q8IVL0		UPI0000E59849	NM_001024383.1			39/40																			HIGH	1	deletion	1			1											PASS	ATGAAAGCTGCA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
CEP83	51134	BI	GRCh38	chr12	94370032	94370032	+	Missense_Mutation	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.938A>G	p.Lys313Arg	p.K313R	ENST00000397809	9/17	136	94	42	98			CEP83,missense_variant,p.K313R,ENST00000397809,NM_016122.2,c.938A>G,MODERATE,YES,deleterious(0),benign(0.1),-1;CEP83,missense_variant,p.K313R,ENST00000339839,NM_001042399.1,c.938A>G,MODERATE,,deleterious(0),benign(0.1),-1;CEP83,missense_variant,p.K313R,ENST00000547575,,c.938A>G,MODERATE,,deleterious(0.01),benign(0.156),-1;CEP83,missense_variant,p.K184R,ENST00000397807,,c.551A>G,MODERATE,,deleterious(0),benign(0.156),-1;CEP83,non_coding_transcript_exon_variant,,ENST00000549352,,n.782A>G,MODIFIER,,,,-1;CEP83,missense_variant,p.K280R,ENST00000547232,,c.839A>G,MODERATE,,deleterious(0),benign(0.156),-1	C	ENSG00000173588	ENST00000397809	Transcript	missense_variant	missense_variant	1488/3773	938/2106	313/701	K/R	aAa/aGa		1		-1	CEP83	HGNC	HGNC:17966	protein_coding	YES	CCDS41820.1	ENSP00000380911		J3KNW7	UPI0000D4BD6F	NM_016122.2	deleterious(0)	benign(0.1)	9/17		Coiled-coils_(Ncoils):ncoils																	MODERATE	1	SNV	1			1											PASS	GTTCTTTTACC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4045459	True	Unknown
CCDC38	120935	BI	GRCh38	chr12	95879643	95879643	+	Splice_Site	SNP	C	C	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1142+1G>C		p.X381_splice	ENST00000344280		53	46	7	34			CCDC38,splice_donor_variant,p.X381_splice,ENST00000344280,NM_182496.2,c.1142+1G>C,HIGH,YES,,,-1;SNRPF,intron_variant,,ENST00000552085,,c.130-45C>G,MODIFIER,,,,1;SNRPF,intron_variant,,ENST00000553192,,c.130-45C>G,MODIFIER,,,,1;CCDC38,splice_donor_variant,p.X10_splice,ENST00000549876,,c.28+1G>C,HIGH,,,,-1	G	ENSG00000165972	ENST00000344280	Transcript	splice_donor_variant	splice_donor_variant	-/2277	1142/1692	381/563				1		-1	CCDC38	HGNC	HGNC:26843	protein_coding	YES	CCDS9056.1	ENSP00000345470	Q502W7		UPI00001AEC9B	NM_182496.2				12/15																		HIGH	1	SNV	1			1											PASS	ACTTACGTTTT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	NonExonic	COSM4045511	True	Unknown
MYO1H	283446	BI	GRCh38	chr12	109406841	109406841	+	Missense_Mutation	SNP	T	T	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.968T>G	p.Ile323Ser	p.I323S	ENST00000310903	9/32	73	49	24	67			MYO1H,missense_variant,p.I323S,ENST00000310903,,c.968T>G,MODERATE,YES,deleterious(0),probably_damaging(0.998),1;MYO1H,missense_variant,p.I323S,ENST00000431443,NM_001101421.3,c.968T>G,MODERATE,,deleterious(0),probably_damaging(0.998),1;MYO1H,non_coding_transcript_exon_variant,,ENST00000542883,,n.346T>G,MODIFIER,,,,1	G	ENSG00000174527	ENST00000310903	Transcript	missense_variant	missense_variant	1074/4364	968/3069	323/1022	I/S	aTt/aGt		1		1	MYO1H	HGNC	HGNC:13879	protein_coding	YES	CCDS53826.1	ENSP00000439182	Q8N1T3		UPI0001AFF951		deleterious(0)	probably_damaging(0.998)	9/32		Pfam_domain:PF00063;SMART_domains:SM00242;Superfamily_domains:SSF52540																	MODERATE	1	SNV	5			1											PASS	AAAAATTGAAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4038524;COSM4038525	True	Unknown
KSR2	283455	BI	GRCh38	chr12	117471320	117471320	+	Splice_Region	SNP	G	G	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2583C>A	p.=	p.G861G	ENST00000339824	18/20	49	43	6	56			KSR2,splice_region_variant,p.G861G,ENST00000339824,,c.2583C>A,LOW,,,,-1;KSR2,splice_region_variant,p.G832G,ENST00000425217,NM_173598.4,c.2496C>A,LOW,YES,,,-1	T	ENSG00000171435	ENST00000339824	Transcript	splice_region_variant	splice_region_variant;synonymous_variant	3311/17726	2583/2853	861/950	G	ggC/ggA		1		-1	KSR2	HGNC	HGNC:18610	protein_coding			ENSP00000339952	Q6VAB6		UPI000152636C				18/20		Pfam_domain:PF07714;Pfam_domain:PF00069;PROSITE_profiles:PS50011;SMART_domains:SM00220;SMART_domains:SM00219;Superfamily_domains:SSF56112																	LOW		SNV	5			1											PASS	ATTGTGCTGTT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4039155;COSM4907566	True	Unknown
SBNO1	55206	BI	GRCh38	chr12	123309504	123309504	+	Silent	SNP	G	G	A	rs376953957	byCluster;byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.3522C>T	p.=	p.H1174H	ENST00000420886	26/31	227	191	36	224			SBNO1,synonymous_variant,p.H1173H,ENST00000267176,NM_018183.3,c.3519C>T,LOW,,,,-1;SBNO1,synonymous_variant,p.H1174H,ENST00000420886,NM_001167856.1,c.3522C>T,LOW,YES,,,-1;SBNO1,synonymous_variant,p.H1174H,ENST00000602398,,c.3522C>T,LOW,,,,-1	A	ENSG00000139697	ENST00000420886	Transcript	synonymous_variant	synonymous_variant	3522/10981	3522/4182	1174/1393	H	caC/caT	rs376953957	1		-1	SBNO1	HGNC	HGNC:22973	protein_coding	YES	CCDS53844.1	ENSP00000387361	A3KN83		UPI00001FB922	NM_001167856.1			26/31																			LOW	1	SNV	1			1	2.471e-05	2.474e-05	0	8.637e-05	0	0	1.498e-05	0.001101	0		PASS	TCTACGTGGCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	common_in_exac	COSM4039746	True	Unknown
BRCA2	675	BI	GRCh38	chr13	32398298	32398298	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.9785A>C	p.Gln3262Pro	p.Q3262P	ENST00000380152	27/27	122	97	25	84			BRCA2,missense_variant,p.Q3262P,ENST00000380152,,c.9785A>C,MODERATE,YES,tolerated(1),benign(0.001),1;BRCA2,missense_variant,p.Q3262P,ENST00000544455,NM_000059.3,c.9785A>C,MODERATE,,tolerated(1),benign(0.001),1;N4BP2L1,downstream_gene_variant,,ENST00000380130,NM_052818.2&NM_001286459.1,,MODIFIER,YES,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000380139,NM_001286460.1&NM_001079691.1,,MODIFIER,,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000613078,,,MODIFIER,,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000530622,,,MODIFIER,,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000380133,,,MODIFIER,,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000495479,NM_001286461.1,,MODIFIER,,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000459716,,,MODIFIER,,,,-1;BRCA2,non_coding_transcript_exon_variant,,ENST00000533776,,n.373A>C,MODIFIER,,,,1;BRCA2,downstream_gene_variant,,ENST00000470094,,,MODIFIER,,,,1	C	ENSG00000139618	ENST00000380152	Transcript	missense_variant	missense_variant	10018/11986	9785/10257	3262/3418	Q/P	cAa/cCa		1		1	BRCA2	HGNC	HGNC:1101	protein_coding	YES	CCDS9344.1	ENSP00000369497	P51587		UPI00001FCBCC		tolerated(1)	benign(0.001)	27/27		PIRSF_domain:PIRSF002397																	MODERATE		SNV	5			1											PASS	TGACCAAAAGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4047105;COSM4047106	True	Unknown
BRCA2	675	BI	GRCh38	chr13	32398450	32398450	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.9937A>C	p.Lys3313Gln	p.K3313Q	ENST00000380152	27/27	51	35	16	43			BRCA2,missense_variant,p.K3313Q,ENST00000380152,,c.9937A>C,MODERATE,YES,tolerated(0.09),probably_damaging(0.956),1;BRCA2,missense_variant,p.K3313Q,ENST00000544455,NM_000059.3,c.9937A>C,MODERATE,,tolerated(0.09),probably_damaging(0.956),1;N4BP2L1,downstream_gene_variant,,ENST00000380130,NM_052818.2&NM_001286459.1,,MODIFIER,YES,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000380139,NM_001286460.1&NM_001079691.1,,MODIFIER,,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000613078,,,MODIFIER,,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000530622,,,MODIFIER,,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000380133,,,MODIFIER,,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000495479,NM_001286461.1,,MODIFIER,,,,-1;N4BP2L1,downstream_gene_variant,,ENST00000459716,,,MODIFIER,,,,-1;BRCA2,downstream_gene_variant,,ENST00000470094,,,MODIFIER,,,,1;BRCA2,downstream_gene_variant,,ENST00000533776,,,MODIFIER,,,,1	C	ENSG00000139618	ENST00000380152	Transcript	missense_variant	missense_variant	10170/11986	9937/10257	3313/3418	K/Q	Aag/Cag		1		1	BRCA2	HGNC	HGNC:1101	protein_coding	YES	CCDS9344.1	ENSP00000369497	P51587		UPI00001FCBCC		tolerated(0.09)	probably_damaging(0.956)	27/27		PIRSF_domain:PIRSF002397																	MODERATE		SNV	5			1											PASS	CCATAAAGAAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4047107;COSM4047108	True	Unknown
VWA8	23078	BI	GRCh38	chr13	41891497	41891497	+	Silent	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.574T>C	p.=	p.L192L	ENST00000379310	5/45	146	129	17	93			VWA8,synonymous_variant,p.L192L,ENST00000379310,NM_015058.1,c.574T>C,LOW,YES,,,-1;VWA8,synonymous_variant,p.L192L,ENST00000281496,NM_001009814.1,c.574T>C,LOW,,,,-1	G	ENSG00000102763	ENST00000379310	Transcript	synonymous_variant	synonymous_variant	643/7147	574/5718	192/1905	L	Ttg/Ctg		1		-1	VWA8	HGNC	HGNC:29071	protein_coding	YES	CCDS41881.1	ENSP00000368612	A3KMH1		UPI00001606AC	NM_015058.1			5/45		Low_complexity_(Seg):Seg;Pfam_domain:PF07728;Superfamily_domains:SSF52540																	LOW	1	SNV	2			1											PASS	CAGCAAGTTGT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4047658	True	Unknown
PCDH20	64881	BI	GRCh38	chr13	61411763	61411763	+	Missense_Mutation	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2336T>C	p.Val779Ala	p.V779A	ENST00000409186	5/5	58	49	9	51			PCDH20,missense_variant,p.V779A,ENST00000409186,,c.2336T>C,MODERATE,YES,tolerated(0.24),possibly_damaging(0.449),-1;PCDH20,missense_variant,p.V779A,ENST00000409204,NM_022843.3,c.2336T>C,MODERATE,YES,tolerated(0.24),possibly_damaging(0.449),-1	G	ENSG00000197991	ENST00000409186	Transcript	missense_variant	missense_variant	4442/6347	2336/2856	779/951	V/A	gTc/gCc		1		-1	PCDH20	HGNC	HGNC:14257	protein_coding	YES	CCDS9442.2	ENSP00000386653	Q8N6Y1		UPI000007371F		tolerated(0.24)	possibly_damaging(0.449)	5/5		Pfam_domain:PF00028;PROSITE_profiles:PS50268;SMART_domains:SM00112;Superfamily_domains:SSF49313																	MODERATE	1	SNV	1			1											PASS	CTATGACAGCA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4048206;COSM4048207	True	Unknown
EDNRB	1910	BI	GRCh38	chr13	77919566	77919566	+	5'Flank	SNP	C	C	T	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d				ENST00000334286		26	16	10	28			EDNRB,stop_gained,p.W17*,ENST00000377211,NM_001201397.1,c.50G>A,HIGH,YES,,,-1;EDNRB,upstream_gene_variant,,ENST00000334286,NM_001122659.2&NM_000115.3,,MODIFIER,,,,-1;EDNRB,upstream_gene_variant,,ENST00000626030,NM_003991.3,,MODIFIER,,,,-1;EDNRB,upstream_gene_variant,,ENST00000475537,,,MODIFIER,,,,-1;RNF219-AS1,upstream_gene_variant,,ENST00000607862,,,MODIFIER,YES,,,1	T	ENSG00000136160	ENST00000334286	Transcript	upstream_gene_variant	upstream_gene_variant	-/4277	-/1329	-/442				1	756	-1	EDNRB	HGNC	HGNC:3180	protein_coding		CCDS9461.1	ENSP00000335311	P24530		UPI00000503F8	NM_001122659.2;NM_000115.3																						MODIFIER		SNV	1			1											PASS	GCCTCCACCGT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
FAM179B	23116	BI	GRCh38	chr14	44964098	44964098	+	Silent	SNP	A	A	G	rs781263117		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1677A>G	p.=	p.Q559Q	ENST00000361577	1/19	68	54	14	134			FAM179B,synonymous_variant,p.Q559Q,ENST00000361462,,c.1677A>G,LOW,,,,1;FAM179B,synonymous_variant,p.Q559Q,ENST00000361577,NM_015091.2,c.1677A>G,LOW,YES,,,1;KLHL28,intron_variant,,ENST00000556239,,c.-1+14100T>C,MODIFIER,,,,-1;KLHL28,upstream_gene_variant,,ENST00000396128,NM_017658.3,,MODIFIER,YES,,,-1;KLHL28,upstream_gene_variant,,ENST00000355081,,,MODIFIER,,,,-1;KLHL28,upstream_gene_variant,,ENST00000556500,,,MODIFIER,,,,-1;KLHL28,upstream_gene_variant,,ENST00000579157,,,MODIFIER,,,,-1;KLHL28,upstream_gene_variant,,ENST00000557468,,,MODIFIER,,,,-1;KLHL28,splice_region_variant,,ENST00000553817,,n.309-6T>C,LOW,,,,-1;FAM179B,synonymous_variant,p.Q559Q,ENST00000557423,,c.1677A>G,LOW,,,,1;FAM179B,non_coding_transcript_exon_variant,,ENST00000555607,,n.1885A>G,MODIFIER,,,,1;FAM179B,non_coding_transcript_exon_variant,,ENST00000555945,,n.1880A>G,MODIFIER,,,,1	G	ENSG00000198718	ENST00000361577	Transcript	synonymous_variant	synonymous_variant	1891/6247	1677/5163	559/1720	Q	caA/caG	rs781263117	1		1	FAM179B	HGNC	HGNC:19959	protein_coding	YES	CCDS9681.1	ENSP00000355045	Q9Y4F4		UPI00001C1F79	NM_015091.2			1/19		Superfamily_domains:SSF48371																	LOW	1	SNV	1			1											PASS	CTGCAAGATAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4050868	True	Unknown
TBPL2	387332	BI	GRCh38	chr14	55414390	55414390	+	Nonsense_Mutation	SNP	T	T	A	rs767811298	byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1117A>T	p.Lys373Ter	p.K373*	ENST00000247219	7/7	33	16	17	47			TBPL2,stop_gained,p.K373*,ENST00000247219,NM_199047.2,c.1117A>T,HIGH,YES,,,-1;ATG14,upstream_gene_variant,,ENST00000247178,NM_014924.4,,MODIFIER,YES,,,-1;RPL21P6,upstream_gene_variant,,ENST00000479171,,,MODIFIER,YES,,,-1	A	ENSG00000182521	ENST00000247219	Transcript	stop_gained	stop_gained	1188/2037	1117/1128	373/375	K/*	Aaa/Taa	rs767811298	1		-1	TBPL2	HGNC	HGNC:19841	protein_coding	YES	CCDS9724.1	ENSP00000247219	Q6SJ96		UPI0000226668	NM_199047.2			7/7		Superfamily_domains:SSF55945																	HIGH	1	SNV	1			1	1.647e-05	1.654e-05	0	0	0	0	0	0	0.0001214		PASS	TTTTTTAAAAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM2245377	True	Unknown
KCNH5	27133	BI	GRCh38	chr14	62950129	62950129	+	Splice_Region	SNP	T	T	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1369+4A>G			ENST00000322893		37	30	7	37			KCNH5,splice_region_variant,,ENST00000322893,NM_139318.4,c.1369+4A>G,LOW,YES,,,-1;KCNH5,splice_region_variant,,ENST00000420622,NM_172375.2,c.1369+4A>G,LOW,,,,-1;KCNH5,splice_region_variant,,ENST00000394968,,c.1195+4A>G,LOW,,,,-1;KCNH5,non_coding_transcript_exon_variant,,ENST00000394964,,n.1538A>G,MODIFIER,,,,-1	C	ENSG00000140015	ENST00000322893	Transcript	splice_region_variant	splice_region_variant;intron_variant	-/11290	-/2967	-/988				1		-1	KCNH5	HGNC	HGNC:6254	protein_coding	YES	CCDS9756.1	ENSP00000321427	Q8NCM2		UPI0000039E2D	NM_139318.4				7/10																		LOW	1	SNV	1			1											PASS	AATACTTACAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
GPX2	2877	BI	GRCh38	chr14	64939622	64939622	+	Missense_Mutation	SNP	G	G	A	rs755670449	byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.439C>T	p.Arg147Cys	p.R147C	ENST00000389614	2/2	65	55	10	98			GPX2,missense_variant,p.R146C,ENST00000612794,,c.436C>T,MODERATE,,deleterious(0),probably_damaging(0.999),-1;GPX2,missense_variant,p.R147C,ENST00000389614,NM_002083.3,c.439C>T,MODERATE,YES,deleterious(0),probably_damaging(0.998),-1;GPX2,missense_variant,p.R91C,ENST00000557049,,c.271C>T,MODERATE,,deleterious(0.01),probably_damaging(0.998),-1;CHURC1,intron_variant,,ENST00000551947,,c.229-3677G>A,MODIFIER,,,,1;CHURC1-FNTB,intron_variant,,ENST00000549987,NM_001202559.1,c.246+13542G>A,MODIFIER,YES,,,1;CHURC1,intron_variant,,ENST00000551093,,c.266-3677G>A,MODIFIER,,,,1;CHURC1-FNTB,intron_variant,,ENST00000553743,,c.91+15496G>A,MODIFIER,,,,1;CHURC1,downstream_gene_variant,,ENST00000607599,NM_145165.3,,MODIFIER,YES,,,1;GPX2,3_prime_UTR_variant,,ENST00000553522,,c.*408C>T,MODIFIER,,,,-1;GPX2,3_prime_UTR_variant,,ENST00000557323,,c.*407C>T,MODIFIER,,,,-1;CHURC1-FNTB,intron_variant,,ENST00000552941,,c.186+15496G>A,MODIFIER,,,,1;CHURC1-FNTB,intron_variant,,ENST00000551823,,c.*62+7330G>A,MODIFIER,,,,1	A	ENSG00000176153	ENST00000389614	Transcript	missense_variant	missense_variant	526/990	439/573	147/190	R/C	Cgc/Tgc	rs755670449	1		-1	GPX2	HGNC	HGNC:4554	protein_coding	YES	CCDS41964.1	ENSP00000374265	P18283		UPI00001B2F3B	NM_002083.3	deleterious(0)	probably_damaging(0.998)	2/2		Superfamily_domains:SSF52833;PIRSF_domain:PIRSF000303																	MODERATE	1	SNV	1			1	2.481e-04	0.0002484	0	0.001728	0.0005796	0	1.498e-05	0	0.0002422		PASS	TGAGCGGCGCA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	common_in_exac	COSM4051893	True	Unknown
UNC79	57578	BI	GRCh38	chr14	93593729	93593729	+	Missense_Mutation	SNP	G	G	A	rs139389360	byCluster	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.3082G>A	p.Val1028Ile	p.V1028I	ENST00000393151	23/50	131	114	17	152			UNC79,missense_variant,p.V1028I,ENST00000553484,,c.3082G>A,MODERATE,,tolerated(0.07),benign(0.147),1;UNC79,missense_variant,p.V1028I,ENST00000555664,,c.3082G>A,MODERATE,,tolerated(0.07),benign(0.267),1;UNC79,missense_variant,p.V851I,ENST00000256339,NM_020818.3,c.2551G>A,MODERATE,YES,tolerated(0.06),benign(0.267),1;UNC79,missense_variant,p.V1028I,ENST00000393151,,c.3082G>A,MODERATE,,tolerated(0.06),benign(0.267),1;UNC79,missense_variant,p.V851I,ENST00000621021,,c.2551G>A,MODERATE,,tolerated(0.06),benign(0.267),1	A	ENSG00000133958	ENST00000393151	Transcript	missense_variant	missense_variant	3082/7908	3082/7908	1028/2635	V/I	Gtc/Atc	rs139389360	1		1	UNC79	HGNC	HGNC:19966	protein_coding			ENSP00000376858	Q9P2D8		UPI00021CF3DC		tolerated(0.06)	benign(0.267)	23/50		Low_complexity_(Seg):Seg;Superfamily_domains:SSF48371								0	0.0001								MODERATE		SNV	5			1	1.647e-05	1.649e-05	0	0	0	0	3e-05	0	0		PASS	TGGCAGTCCCT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4053140;COSM4053141	True	Unknown
NPAP1	23742	BI	GRCh38	chr15	24676523	24676523	+	Missense_Mutation	SNP	A	A	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.656A>T	p.Asn219Ile	p.N219I	ENST00000329468	1/1	24	20	4	25			NPAP1,missense_variant,p.N219I,ENST00000329468,NM_018958.2,c.656A>T,MODERATE,YES,tolerated(0.05),benign(0.362),1	T	ENSG00000185823	ENST00000329468	Transcript	missense_variant	missense_variant	656/7526	656/3471	219/1156	N/I	aAc/aTc		1		1	NPAP1	HGNC	HGNC:1190	protein_coding	YES	CCDS10015.1	ENSP00000333735	Q9NZP6		UPI00001AFA1B	NM_018958.2	tolerated(0.05)	benign(0.362)	1/1																			MODERATE	1	SNV				1											PASS	AGAAAACAGCA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4053680	True	Unknown
CTDSPL2	51496	BI	GRCh38	chr15	44524133	44524133	+	Missense_Mutation	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1360A>G	p.Arg454Gly	p.R454G	ENST00000260327	13/13	51	42	9	66			CTDSPL2,missense_variant,p.R454G,ENST00000260327,NM_016396.2,c.1360A>G,MODERATE,YES,deleterious(0.02),benign(0.13),1;CTDSPL2,missense_variant,p.R382G,ENST00000558373,,c.1144A>G,MODERATE,,deleterious(0.02),possibly_damaging(0.535),1;CTDSPL2,missense_variant,p.R454G,ENST00000558966,,c.1360A>G,MODERATE,,deleterious(0.02),benign(0.13),1;EIF3J-AS1,downstream_gene_variant,,ENST00000560750,,,MODIFIER,,,,-1;CTDSPL2,non_coding_transcript_exon_variant,,ENST00000559738,,n.240A>G,MODIFIER,,,,1;CTDSPL2,non_coding_transcript_exon_variant,,ENST00000559175,,n.1795A>G,MODIFIER,,,,1;CTDSPL2,downstream_gene_variant,,ENST00000560620,,,MODIFIER,,,,1	G	ENSG00000137770	ENST00000260327	Transcript	missense_variant	missense_variant	1923/6828	1360/1401	454/466	R/G	Aga/Gga		1		1	CTDSPL2	HGNC	HGNC:26936	protein_coding	YES	CCDS10110.1	ENSP00000260327	Q05D32	A0A024R5Q8	UPI000004A0B3	NM_016396.2	deleterious(0.02)	benign(0.13)	13/13		Superfamily_domains:SSF56784																	MODERATE	1	SNV	1			1											PASS	ACATCAGAGAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4054901	True	Unknown
CYP11A1	1583	BI	GRCh38	chr15	74367484	74367484	+	Silent	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.102T>C	p.=	p.T34T	ENST00000268053	1/9	30	20	9	50			CYP11A1,synonymous_variant,p.T34T,ENST00000268053,NM_000781.2,c.102T>C,LOW,YES,,,-1;CYP11A1,synonymous_variant,p.T34T,ENST00000416978,,c.102T>C,LOW,,,,-1;CYP11A1,upstream_gene_variant,,ENST00000358632,NM_001099773.1,,MODIFIER,,,,-1;CYP11A1,upstream_gene_variant,,ENST00000450547,,,MODIFIER,,,,-1;CYP11A1,upstream_gene_variant,,ENST00000569662,,,MODIFIER,,,,-1;CTD-2311M21.3,non_coding_transcript_exon_variant,,ENST00000568496,,n.1219A>G,MODIFIER,YES,,,1;CYP11A1,non_coding_transcript_exon_variant,,ENST00000467407,,n.163T>C,MODIFIER,,,,-1;CTD-2311M21.2,downstream_gene_variant,,ENST00000562009,,,MODIFIER,YES,,,1;CYP11A1,synonymous_variant,p.T34T,ENST00000435365,,c.102T>C,LOW,,,,-1;CYP11A1,upstream_gene_variant,,ENST00000466978,,,MODIFIER,,,,-1	G	ENSG00000140459	ENST00000268053	Transcript	synonymous_variant	synonymous_variant	257/1934	102/1566	34/521	T	acT/acC		1		-1	CYP11A1	HGNC	HGNC:2590	protein_coding	YES	CCDS32291.1	ENSP00000268053	P05108		UPI00000725F7	NM_000781.2			1/9																			LOW	1	SNV	1			1											PASS	TCGCCAGTGGG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4056870	True	Unknown
MEX3B	84206	BI	GRCh38	chr15	82043206	82043206	+	Missense_Mutation	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1664C>T	p.Pro555Leu	p.P555L	ENST00000329713	2/2	71	55	16	123			MEX3B,missense_variant,p.P555L,ENST00000329713,NM_032246.4,c.1664C>T,MODERATE,YES,deleterious(0),probably_damaging(0.999),-1;MEX3B,3_prime_UTR_variant,,ENST00000558133,,c.*2023C>T,MODIFIER,,,,-1;AC026956.1,upstream_gene_variant,,ENST00000410589,,,MODIFIER,YES,,,1	A	ENSG00000183496	ENST00000329713	Transcript	missense_variant	missense_variant	2100/3528	1664/1710	555/569	P/L	cCg/cTg		1		-1	MEX3B	HGNC	HGNC:25297	protein_coding	YES	CCDS10319.1	ENSP00000329918	Q6ZN04			NM_032246.4	deleterious(0)	probably_damaging(0.999)	2/2		PROSITE_profiles:PS50089;SMART_domains:SM00184;Superfamily_domains:SSF57850																	MODERATE	1	SNV	1			1											PASS	AGACCGGGCAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM162461	True	Unknown
RHCG	51458	BI	GRCh38	chr15	89480367	89480367	+	Silent	SNP	G	G	A	rs772093651	byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.564C>T	p.=	p.G188G	ENST00000268122	4/11	121	93	28	154			RHCG,synonymous_variant,p.G188G,ENST00000268122,NM_016321.2,c.564C>T,LOW,YES,,,-1;RHCG,upstream_gene_variant,,ENST00000558360,,,MODIFIER,,,,-1;RHCG,synonymous_variant,p.G188G,ENST00000560081,,c.564C>T,LOW,,,,-1;RHCG,3_prime_UTR_variant,,ENST00000558184,,c.*412C>T,MODIFIER,,,,-1;RHCG,intron_variant,,ENST00000558030,,c.475-879C>T,MODIFIER,,,,-1;RHCG,upstream_gene_variant,,ENST00000559638,,,MODIFIER,,,,-1	A	ENSG00000140519	ENST00000268122	Transcript	synonymous_variant	synonymous_variant	633/1982	564/1440	188/479	G	ggC/ggT	rs772093651	1		-1	RHCG	HGNC	HGNC:18140	protein_coding	YES	CCDS10351.1	ENSP00000268122	Q9UBD6		UPI00000343FD	NM_016321.2			4/11		Pfam_domain:PF00909;Transmembrane_helices:Tmhmm;Prints_domain:PR00342;Superfamily_domains:SSF111352																	LOW	1	SNV	1			1	3.295e-05	3.297e-05	9.61e-05	0	0.0002312	0	0	0	6.067e-05		PASS	TAGGCGCCAAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM1375339	True	Unknown
IGF1R	3480	BI	GRCh38	chr15	98891479	98891479	+	Silent	SNP	G	G	A	rs565401892	by1000G;byCluster	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.795G>A	p.=	p.P265P	ENST00000268035	3/21	43	32	11	74			IGF1R,synonymous_variant,p.P265P,ENST00000268035,NM_000875.3,c.795G>A,LOW,YES,,,1;IGF1R,synonymous_variant,p.P265P,ENST00000558762,NM_001291858.1,c.795G>A,LOW,,,,1;IGF1R,synonymous_variant,p.P144P,ENST00000558355,,c.432G>A,LOW,,,,1;IGF1R,5_prime_UTR_variant,,ENST00000558898,,c.-115G>A,MODIFIER,,,,1;RP11-654A16.1,intron_variant,,ENST00000558736,,n.69+1988C>T,MODIFIER,YES,,,-1;IGF1R,non_coding_transcript_exon_variant,,ENST00000560432,,n.369G>A,MODIFIER,,,,1;IGF1R,non_coding_transcript_exon_variant,,ENST00000557873,,n.292G>A,MODIFIER,,,,1;IGF1R,non_coding_transcript_exon_variant,,ENST00000557938,,n.197G>A,MODIFIER,,,,1;IGF1R,non_coding_transcript_exon_variant,,ENST00000560186,,n.230G>A,MODIFIER,,,,1;IGF1R,non_coding_transcript_exon_variant,,ENST00000560277,,n.275G>A,MODIFIER,,,,1;IGF1R,non_coding_transcript_exon_variant,,ENST00000559925,,n.795G>A,MODIFIER,,,,1	A	ENSG00000140443	ENST00000268035	Transcript	synonymous_variant	synonymous_variant	1406/11803	795/4104	265/1367	P	ccG/ccA	rs565401892	1		1	IGF1R	HGNC	HGNC:5465	protein_coding	YES	CCDS10378.1	ENSP00000268035	P08069		UPI000012D3EA	NM_000875.3			3/21		Pfam_domain:PF00757;SMART_domains:SM00261;Superfamily_domains:SSF57184;PIRSF_domain:PIRSF000620																	LOW	1	SNV	1			1	8.236e-06	8.276e-06	0	0	0	0	1.504e-05	0	0		PASS	TGCCCGCCCAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4058078	True	Unknown
ACSM2B	348158	BI	GRCh38	chr16	20564817	20564817	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.29T>G	p.Leu10Arg	p.L10R	ENST00000329697	2/14	46	39	7	48			ACSM2B,missense_variant,p.L10R,ENST00000329697,NM_001105069.1,c.29T>G,MODERATE,YES,deleterious(0.01),benign(0.024),-1;ACSM2B,missense_variant,p.L10R,ENST00000414188,,c.29T>G,MODERATE,,deleterious(0.01),benign(0.024),-1;ACSM2B,missense_variant,p.L10R,ENST00000565232,,c.29T>G,MODERATE,,deleterious(0.01),benign(0.024),-1;ACSM2B,missense_variant,p.L10R,ENST00000567001,NM_182617.3,c.29T>G,MODERATE,,deleterious(0.01),benign(0.024),-1;ACSM2B,missense_variant,p.L10R,ENST00000566384,,c.29T>G,MODERATE,,deleterious(0.01),benign(0.024),-1;ACSM2B,missense_variant,p.L10R,ENST00000569344,,c.29T>G,MODERATE,,,,-1;ACSM2B,intron_variant,,ENST00000565322,,c.-60-5370T>G,MODIFIER,,,,-1;ACSM2B,intron_variant,,ENST00000568882,,c.-60-5370T>G,MODIFIER,,,,-1;ACSM2B,missense_variant,p.L10R,ENST00000569327,,c.29T>G,MODERATE,,deleterious(0.01),benign(0.077),-1;ACSM2B,non_coding_transcript_exon_variant,,ENST00000569364,,n.204T>G,MODIFIER,,,,-1;ACSM2B,intron_variant,,ENST00000563943,,n.107-5370T>G,MODIFIER,,,,-1	C	ENSG00000066813	ENST00000329697	Transcript	missense_variant	missense_variant	198/2935	29/1734	10/577	L/R	cTt/cGt		1		-1	ACSM2B	HGNC	HGNC:30931	protein_coding	YES	CCDS10586.1	ENSP00000327453	Q68CK6		UPI00001AFAA7	NM_001105069.1	deleterious(0.01)	benign(0.024)	2/14		Superfamily_domains:SSF56801																	MODERATE	1	SNV	1			1											PASS	TGCAAAGTCCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4058993;COSM4907569	True	Unknown
PRSS36	146547	BI	GRCh38	chr16	31145816	31145816	+	Silent	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.693C>T	p.=	p.Y231Y	ENST00000268281	6/15	89	73	16	106			PRSS36,synonymous_variant,p.Y231Y,ENST00000268281,NM_173502.4,c.693C>T,LOW,YES,,,-1;PRSS36,synonymous_variant,p.Y231Y,ENST00000569305,NM_001258290.1,c.693C>T,LOW,,,,-1;PRSS36,synonymous_variant,p.Y231Y,ENST00000418068,NM_001258291.1,c.693C>T,LOW,,,,-1;PRSS36,non_coding_transcript_exon_variant,,ENST00000562368,,n.693C>T,MODIFIER,,,,-1;PRSS36,upstream_gene_variant,,ENST00000563693,,,MODIFIER,,,,-1;PRSS36,downstream_gene_variant,,ENST00000569614,,,MODIFIER,,,,-1;PRSS36,downstream_gene_variant,,ENST00000562390,,,MODIFIER,,,,-1;PRSS36,downstream_gene_variant,,ENST00000561897,,,MODIFIER,,,,-1	A	ENSG00000178226	ENST00000268281	Transcript	synonymous_variant	synonymous_variant	752/2840	693/2568	231/855	Y	taC/taT		1		-1	PRSS36	HGNC	HGNC:26906	protein_coding	YES	CCDS32436.1	ENSP00000268281	Q5K4E3		UPI00001FFF6A	NM_173502.4			6/15		Pfam_domain:PF00089;PROSITE_profiles:PS50240;SMART_domains:SM00020;Superfamily_domains:SSF50494;PIRSF_domain:PIRSF037933																	LOW	1	SNV	1			1											PASS	TCTGGGTAGCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4060405	True	Unknown
IRX5	10265	BI	GRCh38	chr16	54933477	54933477	+	Silent	SNP	C	C	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1056C>G	p.=	p.G352G	ENST00000394636	3/3	15	10	5	22			IRX5,synonymous_variant,p.G352G,ENST00000394636,NM_005853.5,c.1056C>G,LOW,YES,,,1;IRX5,synonymous_variant,p.G351G,ENST00000320990,NM_001252197.1,c.1053C>G,LOW,,,,1;IRX5,synonymous_variant,p.G286G,ENST00000558597,,c.858C>G,LOW,,,,1;IRX5,intron_variant,,ENST00000620085,,c.418-20C>G,MODIFIER,,,,1;IRX5,intron_variant,,ENST00000560154,,c.406-10C>G,MODIFIER,,,,1;CRNDE,upstream_gene_variant,,ENST00000560208,,,MODIFIER,YES,,,-1;CRNDE,upstream_gene_variant,,ENST00000559598,,,MODIFIER,,,,-1;CRNDE,upstream_gene_variant,,ENST00000502066,,,MODIFIER,,,,-1;CRNDE,upstream_gene_variant,,ENST00000501177,,,MODIFIER,,,,-1;CRNDE,upstream_gene_variant,,ENST00000558952,,,MODIFIER,,,,-1;CRNDE,upstream_gene_variant,,ENST00000559432,,,MODIFIER,,,,-1;CTD-3032H12.1,downstream_gene_variant,,ENST00000559802,,,MODIFIER,YES,,,-1;CTD-3032H12.1,downstream_gene_variant,,ENST00000558156,,,MODIFIER,,,,-1;CRNDE,upstream_gene_variant,,ENST00000557792,,,MODIFIER,,,,-1;CRNDE,upstream_gene_variant,,ENST00000560912,,,MODIFIER,,,,-1;CTD-3032H12.2,upstream_gene_variant,,ENST00000560487,,,MODIFIER,YES,,,1	G	ENSG00000176842	ENST00000394636	Transcript	synonymous_variant	synonymous_variant	1393/2401	1056/1452	352/483	G	ggC/ggG		1		1	IRX5	HGNC	HGNC:14361	protein_coding	YES	CCDS10751.1	ENSP00000378132	P78411		UPI00001FF1CD	NM_005853.5			3/3		PROSITE_profiles:PS50099																	LOW		SNV	3			1											PASS	GGCGGCGGGAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4061242	True	Unknown
CNOT1	23019	BI	GRCh38	chr16	58578860	58578860	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1423T>G	p.Phe475Val	p.F475V	ENST00000317147	13/49	61	39	22	79			CNOT1,missense_variant,p.F475V,ENST00000317147,NM_016284.4,c.1423T>G,MODERATE,YES,tolerated(0.47),benign(0.02),-1;CNOT1,missense_variant,p.F475V,ENST00000569240,NM_001265612.1,c.1423T>G,MODERATE,,tolerated(0.39),benign(0.029),-1;CNOT1,missense_variant,p.F475V,ENST00000441024,NM_206999.2,c.1423T>G,MODERATE,,tolerated(0.27),benign(0.037),-1;CNOT1,intron_variant,,ENST00000628857,,c.252-2356T>G,MODIFIER,,,,-1;CNOT1,upstream_gene_variant,,ENST00000569882,,,MODIFIER,,,,-1;CNOT1,missense_variant,p.F475V,ENST00000567188,,c.1423T>G,MODERATE,,tolerated(0.28),benign(0.045),-1;CNOT1,intron_variant,,ENST00000565605,,c.252-2356T>G,MODIFIER,,,,-1	C	ENSG00000125107	ENST00000317147	Transcript	missense_variant	missense_variant	1756/8471	1423/7131	475/2376	F/V	Ttc/Gtc		1		-1	CNOT1	HGNC	HGNC:7877	protein_coding	YES	CCDS10799.1	ENSP00000320949	A5YKK6		UPI00001FF2F6	NM_016284.4	tolerated(0.47)	benign(0.02)	13/49																			MODERATE	1	SNV	1			1											PASS	AGGGAAGCTGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4061565;COSM4061566	True	Unknown
MTSS1L	92154	BI	GRCh38	chr16	70664091	70664091	+	Silent	SNP	C	C	T	rs144949231	byCluster	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1830G>A	p.=	p.A610A	ENST00000338779	15/15	16	10	6	39			MTSS1L,synonymous_variant,p.A610A,ENST00000338779,NM_138383.2,c.1830G>A,LOW,YES,,,-1;MTSS1L,synonymous_variant,p.A609A,ENST00000616026,,c.1827G>A,LOW,,,,-1;IL34,downstream_gene_variant,,ENST00000429149,NM_152456.2&NM_001172771.1,,MODIFIER,YES,,,1;IL34,downstream_gene_variant,,ENST00000288098,NM_001172772.1,,MODIFIER,,,,1;IL34,downstream_gene_variant,,ENST00000566361,,,MODIFIER,,,,1;RP11-394B2.1,non_coding_transcript_exon_variant,,ENST00000623414,,n.2425C>T,MODIFIER,YES,,,1	T	ENSG00000132613	ENST00000338779	Transcript	synonymous_variant	synonymous_variant	2105/4992	1830/2244	610/747	A	gcG/gcA	rs144949231	1		-1	MTSS1L	HGNC	HGNC:25094	protein_coding	YES	CCDS32476.1	ENSP00000341171	Q765P7		UPI00001D627C	NM_138383.2			15/15										0	0.0001								LOW	1	SNV	1			1	6.616e-05	7.859e-05	0	0.0005956	0	0	3.556e-05	0	0		PASS	CTGCCCGCCCG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	common_in_exac	COSM4062389	True	Unknown
BCO1	53630	BI	GRCh38	chr16	81280931	81280931	+	Silent	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1176A>G	p.=	p.Q392Q	ENST00000258168	8/11	29	17	12	33			BCO1,synonymous_variant,p.Q392Q,ENST00000258168,NM_017429.2,c.1176A>G,LOW,YES,,,1;BCO1,3_prime_UTR_variant,,ENST00000563804,,c.*800A>G,MODIFIER,,,,1	G	ENSG00000135697	ENST00000258168	Transcript	synonymous_variant	synonymous_variant	1637/2670	1176/1644	392/547	Q	caA/caG		1		1	BCO1	HGNC	HGNC:13815	protein_coding	YES	CCDS10934.1	ENSP00000258168	Q9HAY6		UPI0000049CF7	NM_017429.2			8/11		Pfam_domain:PF03055																	LOW	1	SNV	1			1											PASS	GGCCAAGTCTA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM704641	True	Unknown
ZC3H18	124245	BI	GRCh38	chr16	88624674	88624674	+	Silent	SNP	C	C	T	rs376260255	by1000G;byCluster	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1971C>T	p.=	p.P657P	ENST00000301011	12/18	35	30	5	45			ZC3H18,synonymous_variant,p.P657P,ENST00000301011,NM_144604.3,c.1971C>T,LOW,,,,1;ZC3H18,synonymous_variant,p.P681P,ENST00000452588,NM_001294340.1,c.2043C>T,LOW,YES,,,1;ZC3H18,synonymous_variant,p.P31P,ENST00000564341,,c.93C>T,LOW,,,,1;ZC3H18,upstream_gene_variant,,ENST00000565583,,,MODIFIER,,,,1;ZC3H18,downstream_gene_variant,,ENST00000567085,,,MODIFIER,,,,1;ZC3H18,non_coding_transcript_exon_variant,,ENST00000564161,,n.3085C>T,MODIFIER,,,,1;ZC3H18,upstream_gene_variant,,ENST00000566496,,,MODIFIER,,,,1;ZC3H18,upstream_gene_variant,,ENST00000566317,,,MODIFIER,,,,1;ZC3H18,upstream_gene_variant,,ENST00000563382,,,MODIFIER,,,,1	T	ENSG00000158545	ENST00000301011	Transcript	synonymous_variant	synonymous_variant	2171/3729	1971/2862	657/953	P	ccC/ccT	rs376260255	1		1	ZC3H18	HGNC	HGNC:25091	protein_coding		CCDS10967.1	ENSP00000301011	Q86VM9			NM_144604.3			12/18		Low_complexity_(Seg):Seg;PROSITE_profiles:PS50099;PROSITE_profiles:PS50324		0.0000	0.0000		0.0010	0.0000	0.0000	0.0002	0								LOW		SNV	1			1	5.768e-05	5.927e-05	0.0002011	0	0	0	6.177e-05	0	6.073e-05		PASS	GTCCCCGAGCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4063488	True	Unknown
PITPNM3	83394	BI	GRCh38	chr17	6471306	6471306	+	Silent	SNP	C	C	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1479G>T	p.=	p.R493R	ENST00000262483	12/20	14	11	3	19			PITPNM3,synonymous_variant,p.R493R,ENST00000262483,NM_031220.3,c.1479G>T,LOW,YES,,,-1;PITPNM3,synonymous_variant,p.R457R,ENST00000421306,NM_001165966.1,c.1371G>T,LOW,,,,-1;PITPNM3,non_coding_transcript_exon_variant,,ENST00000576664,,n.228G>T,MODIFIER,,,,-1;PITPNM3,non_coding_transcript_exon_variant,,ENST00000572795,,n.3985G>T,MODIFIER,,,,-1	A	ENSG00000091622	ENST00000262483	Transcript	synonymous_variant	synonymous_variant	1567/7086	1479/2925	493/974	R	cgG/cgT		1		-1	PITPNM3	HGNC	HGNC:21043	protein_coding	YES	CCDS11076.1	ENSP00000262483	Q9BZ71		UPI000022A281	NM_031220.3			12/20		Pfam_domain:PF02862;PROSITE_profiles:PS51043																	LOW	1	SNV	1			1											PASS	CTGTCCCGGGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM707605	True	Unknown
TP53	7157	BI	GRCh38	chr17	7673838	7673838	+	Splice_Site	SNP	C	T	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.783-1G>A		p.X261_splice	ENST00000269305		9	2	7	15			TP53,splice_acceptor_variant,p.X261_splice,ENST00000617185,NM_001126114.2,c.783-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X261_splice,ENST00000420246,,c.783-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X222_splice,ENST00000622645,NM_001276696.1,c.666-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X222_splice,ENST00000610292,NM_001126118.1,c.666-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X261_splice,ENST00000455263,NM_001126113.2,c.783-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X222_splice,ENST00000610538,NM_001276695.1,c.666-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X261_splice,ENST00000269305,NM_000546.5&NM_001126112.2,c.783-1G>A,HIGH,YES,,,-1;TP53,splice_acceptor_variant,p.X222_splice,ENST00000620739,NM_001276761.1&NM_001276760.1,c.666-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X222_splice,ENST00000619485,,c.666-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X261_splice,ENST00000445888,,c.783-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X102_splice,ENST00000618944,NM_001276698.1,c.306-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X129_splice,ENST00000510385,NM_001126116.1,c.387-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X129_splice,ENST00000504290,NM_001126117.1,c.387-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X102_splice,ENST00000610623,NM_001276699.1,c.306-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X102_splice,ENST00000619186,NM_001276697.1,c.306-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X129_splice,ENST00000504937,NM_001126115.1,c.387-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X261_splice,ENST00000359597,,c.783-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X250_splice,ENST00000615910,,c.750-1G>A,HIGH,,,,-1;TP53,splice_acceptor_variant,p.X129_splice,ENST00000509690,,c.387-1G>A,HIGH,,,,-1;TP53,intron_variant,,ENST00000413465,,c.782+343G>A,MODIFIER,,,,-1;TP53,downstream_gene_variant,,ENST00000508793,,,MODIFIER,,,,-1;TP53,downstream_gene_variant,,ENST00000604348,,,MODIFIER,,,,-1;TP53,downstream_gene_variant,,ENST00000503591,,,MODIFIER,,,,-1;TP53,downstream_gene_variant,,ENST00000514944,,,MODIFIER,,,,-1;TP53,upstream_gene_variant,,ENST00000576024,,,MODIFIER,,,,-1;TP53,downstream_gene_variant,,ENST00000574684,,,MODIFIER,,,,-1;TP53,downstream_gene_variant,,ENST00000505014,,,MODIFIER,,,,-1	T	ENSG00000141510	ENST00000269305	Transcript	splice_acceptor_variant	splice_acceptor_variant	-/2579	783/1182	261/393			TP53_g.13762G>A	1		-1	TP53	HGNC	HGNC:11998	protein_coding	YES	CCDS11118.1	ENSP00000269305	P04637	K7PPA8		NM_000546.5;NM_001126112.2				7/10																		HIGH	1	SNV	1			1											PASS	TACCACTACTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	NonExonic	COSM1757290;COSM254989;COSM3932744;COSM44604	True	Unknown
LRRC37B	114659	BI	GRCh38	chr17	32022581	32022581	+	Nonsense_Mutation	SNP	C	C	T	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1435C>T	p.Gln479Ter	p.Q479*	ENST00000341671	1/12	64	53	11	78			LRRC37B,stop_gained,p.Q506*,ENST00000327564,,c.1516C>T,HIGH,,,,1;LRRC37B,stop_gained,p.Q397*,ENST00000543378,,c.1189C>T,HIGH,,,,1;LRRC37B,stop_gained,p.Q479*,ENST00000341671,,c.1435C>T,HIGH,YES,,,1;LRRC37B,stop_gained,p.Q479*,ENST00000394713,NM_052888.2,c.1435C>T,HIGH,,,,1;LRRC37B,stop_gained,p.Q491*,ENST00000584368,,c.1471C>T,HIGH,,,,1;LRRC37B,downstream_gene_variant,,ENST00000579206,,,MODIFIER,,,,1;LRRC37B,downstream_gene_variant,,ENST00000583342,,,MODIFIER,,,,1;LRRC37B,non_coding_transcript_exon_variant,,ENST00000581786,,n.292C>T,MODIFIER,,,,1;LRRC37B,upstream_gene_variant,,ENST00000580871,,,MODIFIER,,,,1;LRRC37B,stop_gained,p.Q491*,ENST00000578674,,c.1471C>T,HIGH,,,,1;LRRC37B,non_coding_transcript_exon_variant,,ENST00000583204,,n.1474C>T,MODIFIER,,,,1;LRRC37B,upstream_gene_variant,,ENST00000582815,,,MODIFIER,,,,1;RP11-640N20.5,downstream_gene_variant,,ENST00000448026,,,MODIFIER,YES,,,-1	T	ENSG00000185158	ENST00000341671	Transcript	stop_gained	stop_gained	1440/3025	1435/2844	479/947	Q/*	Cag/Tag		1		1	LRRC37B	HGNC	HGNC:29070	protein_coding	YES	CCDS32609.1	ENSP00000340519	Q96QE4		UPI000044D37B				1/12																			HIGH	1	SNV	1			1											PASS	AGGTTCAGACT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
WNK4	65266	BI	GRCh38	chr17	42793617	42793617	+	Missense_Mutation	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.2183C>T	p.Ser728Leu	p.S728L	ENST00000246914	12/19	58	48	10	77			WNK4,missense_variant,p.S728L,ENST00000246914,NM_032387.4,c.2183C>T,MODERATE,YES,tolerated(0.06),unknown(0),1;COA3,downstream_gene_variant,,ENST00000328434,NM_001040431.2,,MODIFIER,YES,,,-1;WNK4,upstream_gene_variant,,ENST00000587745,,,MODIFIER,,,,1;WNK4,3_prime_UTR_variant,,ENST00000591448,,c.*684C>T,MODIFIER,,,,1;WNK4,non_coding_transcript_exon_variant,,ENST00000592072,,n.741C>T,MODIFIER,,,,1;COA3,downstream_gene_variant,,ENST00000586680,,,MODIFIER,,,,-1	T	ENSG00000126562	ENST00000246914	Transcript	missense_variant	missense_variant	2204/4001	2183/3732	728/1243	S/L	tCg/tTg		1		1	WNK4	HGNC	HGNC:14544	protein_coding	YES	CCDS11439.1	ENSP00000246914	Q96J92		UPI000006FC0F	NM_032387.4	tolerated(0.06)	unknown(0)	12/19																			MODERATE	1	SNV	1			1											PASS	GCCTTCGGAGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4066668;COSM4066669	True	Unknown
CRHR1	1394	BI	GRCh38	chr17	45830939	45830942	+	Splice_Site	DEL	AAGT	AAGT	-	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.857+3_857+6delAAGT		p.X286_splice	ENST00000398285	9/14	50	42	8	66			CRHR1,splice_donor_variant,p.X286_splice,ENST00000293493,,c.857+3_857+6delAAGT,HIGH,,,,1;CRHR1,splice_donor_variant,p.X257_splice,ENST00000314537,NM_004382.4,c.770+3_770+6delAAGT,HIGH,,,,1;CRHR1,splice_donor_variant,p.X156_splice,ENST00000339069,NM_001303020.1,c.467+3_467+6delAAGT,HIGH,,,,1;CRHR1,splice_donor_variant,p.X286_splice,ENST00000398285,NM_001145146.1,c.857+3_857+6delAAGT,HIGH,YES,,,1;CRHR1,splice_donor_variant,,ENST00000619154,NM_001303018.1,c.*99+3_*99+6delAAGT,HIGH,,,,1;CRHR1,splice_donor_variant,p.X257_splice,ENST00000577353,NM_001145148.1,c.770+3_770+6delAAGT,HIGH,,,,1;CRHR1,splice_donor_variant,p.X217_splice,ENST00000352855,NM_001145147.1,c.650+3_650+6delAAGT,HIGH,,,,1;CRHR1,upstream_gene_variant,,ENST00000580876,,,MODIFIER,,,,1;CRHR1,splice_donor_variant,,ENST00000347197,,c.*247+3_*247+6delAAGT,HIGH,,,,1;CRHR1,splice_donor_variant,p.X134_splice,ENST00000583888,,c.400+3_400+6delAAGT,HIGH,,,,1;CRHR1,splice_donor_variant,,ENST00000581479,,n.541+3_541+6delAAGT,HIGH,,,,1;CRHR1,non_coding_transcript_exon_variant,,ENST00000582766,,,MODIFIER,,,,1;CRHR1,upstream_gene_variant,,ENST00000535778,,,MODIFIER,,,,1;CRHR1,downstream_gene_variant,,ENST00000580955,,,MODIFIER,,,,1	-	ENSG00000120088	ENST00000398285	Transcript	splice_donor_variant	splice_donor_variant;coding_sequence_variant	856-?/2399	856-?/1335	286-?/444				1		1	CRHR1	HGNC	HGNC:2357	protein_coding	YES	CCDS45712.1	ENSP00000381333	P34998			NM_001145146.1			9/14	9/13																		HIGH	1	deletion	1	4		1											PASS	AATGAGAAGTAAGTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
XYLT2	64132	BI	GRCh38	chr17	50356166	50356166	+	Missense_Mutation	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1387C>T	p.Arg463Cys	p.R463C	ENST00000017003	7/11	109	93	15	110			XYLT2,missense_variant,p.R463C,ENST00000017003,NM_022167.3,c.1387C>T,MODERATE,YES,deleterious(0),probably_damaging(1),1;XYLT2,missense_variant,p.R463C,ENST00000507602,,c.1387C>T,MODERATE,,deleterious(0),probably_damaging(1),1;XYLT2,upstream_gene_variant,,ENST00000574840,,,MODIFIER,,,,1;XYLT2,downstream_gene_variant,,ENST00000509778,,,MODIFIER,,,,1;XYLT2,missense_variant,p.R463C,ENST00000376550,,c.1387C>T,MODERATE,,deleterious(0),probably_damaging(0.999),1;XYLT2,upstream_gene_variant,,ENST00000571021,,,MODIFIER,,,,1;XYLT2,upstream_gene_variant,,ENST00000511654,,,MODIFIER,,,,1	T	ENSG00000015532	ENST00000017003	Transcript	missense_variant	missense_variant	1436/3507	1387/2598	463/865	R/C	Cgc/Tgc		1		1	XYLT2	HGNC	HGNC:15517	protein_coding	YES	CCDS11563.1	ENSP00000017003	Q9H1B5		UPI000013C536	NM_022167.3	deleterious(0)	probably_damaging(1)	7/11		Pfam_domain:PF02485																	MODERATE	1	SNV	1			1											PASS	GGAACCGCAAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4067590	True	Unknown
KIF2B	84643	BI	GRCh38	chr17	53823679	53823679	+	Missense_Mutation	SNP	G	G	A	rs369005833	byCluster;byFrequency	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.646G>A	p.Val216Ile	p.V216I	ENST00000268919	1/1	45	36	9	45			KIF2B,missense_variant,p.V216I,ENST00000268919,NM_032559.4,c.646G>A,MODERATE,YES,deleterious(0),possibly_damaging(0.467),1	A	ENSG00000141200	ENST00000268919	Transcript	missense_variant	missense_variant	779/2313	646/2022	216/673	V/I	Gtc/Atc	rs369005833	1		1	KIF2B	HGNC	HGNC:29443	protein_coding	YES	CCDS32685.1	ENSP00000268919	Q8N4N8		UPI000013D7E6	NM_032559.4	deleterious(0)	possibly_damaging(0.467)	1/1		PROSITE_profiles:PS50067;SMART_domains:SM00129;Superfamily_domains:SSF52540																	MODERATE	1	SNV				1	8.236e-06	8.255e-06	0	0	0	0	1.502e-05	0	0		PASS	TCTGCGTCTGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM240411	True	Unknown
MAP3K3	4215	BI	GRCh38	chr17	63689576	63689576	+	Missense_Mutation	SNP	C	C	A	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.904C>A	p.Gln302Lys	p.Q302K	ENST00000361733	11/16	28	22	6	35			MAP3K3,missense_variant,p.Q333K,ENST00000361357,NM_203351.1,c.997C>A,MODERATE,YES,tolerated(0.06),probably_damaging(0.939),1;MAP3K3,missense_variant,p.Q302K,ENST00000361733,NM_002401.3,c.904C>A,MODERATE,,deleterious(0.05),possibly_damaging(0.87),1;MAP3K3,missense_variant,p.Q333K,ENST00000579585,,c.997C>A,MODERATE,,tolerated(0.06),probably_damaging(0.939),1;MAP3K3,missense_variant,p.Q329K,ENST00000584573,,c.985C>A,MODERATE,,deleterious(0.02),possibly_damaging(0.839),1;MAP3K3,missense_variant,p.Q298K,ENST00000577395,,c.892C>A,MODERATE,,deleterious(0.02),probably_damaging(0.968),1;MAP3K3,non_coding_transcript_exon_variant,,ENST00000577784,,n.449C>A,MODIFIER,,,,1;MAP3K3,3_prime_UTR_variant,,ENST00000577597,,c.*729C>A,MODIFIER,,,,1;MAP3K3,non_coding_transcript_exon_variant,,ENST00000577839,,n.173C>A,MODIFIER,,,,1;MAP3K3,non_coding_transcript_exon_variant,,ENST00000578622,,n.522C>A,MODIFIER,,,,1;MAP3K3,downstream_gene_variant,,ENST00000585302,,,MODIFIER,,,,1;MAP3K3,upstream_gene_variant,,ENST00000581732,,,MODIFIER,,,,1	A	ENSG00000198909	ENST00000361733	Transcript	missense_variant	missense_variant	1224/3529	904/1881	302/626	Q/K	Caa/Aaa		1		1	MAP3K3	HGNC	HGNC:6855	protein_coding		CCDS32702.1	ENSP00000354485	Q99759		UPI00002011CC	NM_002401.3	deleterious(0.05)	possibly_damaging(0.87)	11/16																			MODERATE		SNV	1			1											PASS	GTCATCAAGGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
SCN4A	6329	BI	GRCh38	chr17	63948697	63948697	+	Missense_Mutation	SNP	G	G	C	rs371779795	by1000G;byCluster	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.3058C>G	p.Leu1020Val	p.L1020V	ENST00000435607	16/24	58	40	18	48			SCN4A,missense_variant,p.L1020V,ENST00000435607,NM_000334.4,c.3058C>G,MODERATE,YES,tolerated(0.07),possibly_damaging(0.612),-1;SCN4A,missense_variant,p.L1020V,ENST00000578147,,c.3058C>G,MODERATE,,tolerated(0.07),possibly_damaging(0.477),-1;SCN4A,non_coding_transcript_exon_variant,,ENST00000584310,,n.381C>G,MODIFIER,,,,-1	C	ENSG00000007314	ENST00000435607	Transcript	missense_variant	missense_variant	3135/7805	3058/5511	1020/1836	L/V	Ctg/Gtg	rs371779795	1		-1	SCN4A	HGNC	HGNC:10591	protein_coding	YES		ENSP00000396320	P35499		UPI0000201254	NM_000334.4	tolerated(0.07)	possibly_damaging(0.612)	16/24		Pfam_domain:PF06512;Superfamily_domains:SSF81324	0.0002	0.0000	0.0000		0.0010	0.0000	0.0000										MODERATE	1	SNV	5			1	4.942e-05	5.043e-05	0	0	0.0006972	0	0	0	0		PASS	GCGCAGAGTCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	common_in_exac	COSM4068686	True	Unknown
RBBP8	5932	BI	GRCh38	chr18	22949693	22949693	+	Silent	SNP	C	C	A	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.228C>A	p.=	p.T76T	ENST00000327155	4/19	84	58	26	43			RBBP8,synonymous_variant,p.T76T,ENST00000399722,NM_203291.1,c.228C>A,LOW,YES,,,1;RBBP8,synonymous_variant,p.T76T,ENST00000327155,NM_002894.2,c.228C>A,LOW,,,,1;RBBP8,synonymous_variant,p.T76T,ENST00000399725,NM_203292.1,c.228C>A,LOW,,,,1;RBBP8,synonymous_variant,p.T76T,ENST00000360790,,c.228C>A,LOW,,,,1;RBBP8,synonymous_variant,p.T76T,ENST00000399721,,c.228C>A,LOW,,,,1;RBBP8,synonymous_variant,p.T76T,ENST00000582354,,c.228C>A,LOW,,,,1;RBBP8,synonymous_variant,p.T76T,ENST00000581819,,c.228C>A,LOW,,,,1;RBBP8,downstream_gene_variant,,ENST00000579124,,,MODIFIER,,,,1;RBBP8,non_coding_transcript_exon_variant,,ENST00000580892,,n.224C>A,MODIFIER,,,,1	A	ENSG00000101773	ENST00000327155	Transcript	synonymous_variant	synonymous_variant	576/3288	228/2694	76/897	T	acC/acA		1		1	RBBP8	HGNC	HGNC:9891	protein_coding		CCDS11875.1	ENSP00000323050	Q99708	A0A024RC34		NM_002894.2			4/19		Coiled-coils_(Ncoils):ncoils;Pfam_domain:PF10482																	LOW		SNV	1			1											PASS	GAAACCATTAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	gdc_pon		True	Unknown
MEX3C	51320	BI	GRCh38	chr18	51177358	51177358	+	Missense_Mutation	SNP	C	C	T	rs778380833		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.973G>A	p.Gly325Ser	p.G325S	ENST00000406189	2/2	15	10	5	38			MEX3C,missense_variant,p.G325S,ENST00000406189,NM_016626.4,c.973G>A,MODERATE,YES,deleterious(0),probably_damaging(0.995),-1;MEX3C,missense_variant,p.G155S,ENST00000616921,,c.463G>A,MODERATE,,deleterious(0),probably_damaging(1),-1;MEX3C,non_coding_transcript_exon_variant,,ENST00000591040,,n.262G>A,MODIFIER,,,,-1	T	ENSG00000176624	ENST00000406189	Transcript	missense_variant	missense_variant	973/3781	973/1980	325/659	G/S	Ggt/Agt	rs778380833	1		-1	MEX3C	HGNC	HGNC:28040	protein_coding	YES	CCDS11951.2	ENSP00000385610	Q5U5Q3		UPI00005956CD	NM_016626.4	deleterious(0)	probably_damaging(0.995)	2/2		SMART_domains:SM00322;Superfamily_domains:SSF54791																	MODERATE	1	SNV	1			1	8.237e-06	8.243e-06	0	0	0	0	0	0	6.057e-05		PASS	TTGACCGGGCA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4072515;COSM4072516	True	Unknown
C3P1	388503	BI	GRCh38	chr19	10047379	10047379	+	RNA	SNP	A	A	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	n.2349A>C			ENST00000497718	18/37	97	76	21	152			C3P1,non_coding_transcript_exon_variant,,ENST00000495140,,n.1263A>C,MODIFIER,,,,1;C3P1,non_coding_transcript_exon_variant,,ENST00000497718,,n.2349A>C,MODIFIER,YES,,,1	C	ENSG00000167798	ENST00000497718	Transcript	non_coding_transcript_exon_variant	non_coding_transcript_exon_variant;non_coding_transcript_variant	2349/4612						1		1	C3P1	HGNC	HGNC:34414	transcribed_unprocessed_pseudogene	YES									18/37																			MODIFIER	1	SNV				1											PASS	CCTTAAGTTGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
KRI1	65095	BI	GRCh38	chr19	10555173	10555173	+	Silent	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1713G>A	p.=	p.E571E	ENST00000312962	18/19	92	49	43	139			KRI1,synonymous_variant,p.E571E,ENST00000312962,NM_023008.3,c.1713G>A,LOW,YES,,,-1;ATG4D,downstream_gene_variant,,ENST00000309469,NM_001281504.1&NM_032885.5,,MODIFIER,YES,,,1;KRI1,downstream_gene_variant,,ENST00000432197,,,MODIFIER,,,,-1;ATG4D,downstream_gene_variant,,ENST00000588972,,,MODIFIER,,,,1;ATG4D,downstream_gene_variant,,ENST00000587256,,,MODIFIER,,,,1;KRI1,downstream_gene_variant,,ENST00000539027,,,MODIFIER,,,,-1;ATG4D,downstream_gene_variant,,ENST00000586863,,,MODIFIER,,,,1;ATG4D,downstream_gene_variant,,ENST00000585437,,,MODIFIER,,,,1;MIR1238,downstream_gene_variant,,ENST00000408483,,,MODIFIER,YES,,,1;RNU7-140P,upstream_gene_variant,,ENST00000459546,,,MODIFIER,YES,,,-1;KRI1,intron_variant,,ENST00000618579,,n.122-1566G>A,MODIFIER,,,,-1;KRI1,non_coding_transcript_exon_variant,,ENST00000536689,,n.2461G>A,MODIFIER,,,,-1;KRI1,non_coding_transcript_exon_variant,,ENST00000612875,,n.1831G>A,MODIFIER,,,,-1;KRI1,non_coding_transcript_exon_variant,,ENST00000478863,,n.1753G>A,MODIFIER,,,,-1;KRI1,non_coding_transcript_exon_variant,,ENST00000537363,,n.978G>A,MODIFIER,,,,-1;KRI1,non_coding_transcript_exon_variant,,ENST00000537433,,n.629G>A,MODIFIER,,,,-1;ATG4D,downstream_gene_variant,,ENST00000586417,,,MODIFIER,,,,1;ATG4D,downstream_gene_variant,,ENST00000588667,,,MODIFIER,,,,1;ATG4D,downstream_gene_variant,,ENST00000588857,,,MODIFIER,,,,1;ATG4D,downstream_gene_variant,,ENST00000589753,,,MODIFIER,,,,1;KRI1,downstream_gene_variant,,ENST00000536714,,,MODIFIER,,,,-1;ATG4D,downstream_gene_variant,,ENST00000585752,,,MODIFIER,,,,1;KRI1,downstream_gene_variant,,ENST00000543842,,,MODIFIER,,,,-1	T	ENSG00000129347	ENST00000312962	Transcript	synonymous_variant	synonymous_variant	1733/3023	1713/2130	571/709	E	gaG/gaA		1		-1	KRI1	HGNC	HGNC:25769	protein_coding	YES	CCDS12242.1	ENSP00000320917	Q8N9T8		UPI0000246DCC	NM_023008.3			18/19		Pfam_domain:PF05178																	LOW		SNV	2			1											PASS	AGCTCCTCCTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4073889	True	Unknown
ZNF682	91120	BI	GRCh38	chr19	20007182	20007182	+	Missense_Mutation	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.320G>A	p.Gly107Glu	p.G107E	ENST00000397165	4/4	35	26	9	47			ZNF682,missense_variant,p.G107E,ENST00000397165,NM_033196.2,c.320G>A,MODERATE,YES,tolerated(0.12),benign(0.286),-1;ZNF682,missense_variant,p.G75E,ENST00000397162,NM_001077349.1,c.224G>A,MODERATE,,tolerated(0.13),benign(0.286),-1;ZNF682,missense_variant,p.G75E,ENST00000358523,,c.224G>A,MODERATE,,tolerated(0.13),benign(0.286),-1;ZNF682,missense_variant,p.G31E,ENST00000595736,,c.92G>A,MODERATE,,tolerated(0.13),benign(0.286),-1;ZNF682,missense_variant,p.G113E,ENST00000597972,,c.338G>A,MODERATE,,tolerated(0.12),probably_damaging(0.931),-1;ZNF682,missense_variant,p.G75E,ENST00000601100,,c.224G>A,MODERATE,,tolerated(0.12),benign(0.286),-1;ZNF682,missense_variant,p.G28E,ENST00000594127,,c.81G>A,MODERATE,,tolerated(0.09),probably_damaging(0.956),-1;ZNF682,3_prime_UTR_variant,,ENST00000593468,,c.*72G>A,MODIFIER,,,,-1;ZNF682,intron_variant,,ENST00000596019,,c.227-9919G>A,MODIFIER,,,,-1;ZNF682,intron_variant,,ENST00000602079,,c.147-2435G>A,MODIFIER,,,,-1;ZNF682,3_prime_UTR_variant,,ENST00000595534,,c.*250G>A,MODIFIER,,,,-1;ZNF682,non_coding_transcript_exon_variant,,ENST00000601365,,n.1007G>A,MODIFIER,,,,-1	T	ENSG00000197124	ENST00000397165	Transcript	missense_variant	missense_variant	481/3245	320/1497	107/498	G/E	gGa/gAa		1		-1	ZNF682	HGNC	HGNC:28857	protein_coding	YES	CCDS42533.1	ENSP00000380351	O95780		UPI000007275A	NM_033196.2	tolerated(0.12)	benign(0.286)	4/4																			MODERATE	1	SNV	2			1											PASS	CAAGTCCACAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4076066	True	Unknown
ZNF737	100129842	BI	GRCh38	chr19	20544836	20544836	+	Missense_Mutation	SNP	T	T	C	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1367A>G	p.Glu456Gly	p.E456G	ENST00000427401	4/4	49	28	21	68			ZNF737,missense_variant,p.E456G,ENST00000427401,NM_001159293.1,c.1367A>G,MODERATE,YES,deleterious(0.01),possibly_damaging(0.52),-1;ZNF626,intron_variant,,ENST00000622341,,c.1948+124A>G,MODIFIER,,,,-1;ZNF737,downstream_gene_variant,,ENST00000594419,,,MODIFIER,,,,-1;ZNF737,upstream_gene_variant,,ENST00000596530,,,MODIFIER,,,,-1;ZNF737,downstream_gene_variant,,ENST00000597940,,,MODIFIER,,,,-1	C	ENSG00000237440	ENST00000427401	Transcript	missense_variant	missense_variant	1462/2867	1367/1611	456/536	E/G	gAa/gGa		1		-1	ZNF737	HGNC	HGNC:32468	protein_coding	YES	CCDS54238.1	ENSP00000395733	O75373		UPI0000198506	NM_001159293.1	deleterious(0.01)	possibly_damaging(0.52)	4/4		Pfam_domain:PF00096;PROSITE_profiles:PS50157;SMART_domains:SM00355;Superfamily_domains:SSF57667																	MODERATE	1	SNV	2			1											PASS	ATTCTTCACAT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
ZNF345	25850	BI	GRCh38	chr19	36877443	36877443	+	Missense_Mutation	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.613A>G	p.Ile205Val	p.I205V	ENST00000420450	3/3	61	38	23	79			ZNF345,missense_variant,p.I205V,ENST00000529555,,c.613A>G,MODERATE,YES,deleterious(0.03),benign(0.001),1;ZNF345,missense_variant,p.I205V,ENST00000589046,NM_003419.4,c.613A>G,MODERATE,,deleterious(0.03),benign(0.001),1;ZNF345,missense_variant,p.I205V,ENST00000614069,NM_001242474.1,c.613A>G,MODERATE,,deleterious(0.03),benign(0.001),1;ZNF345,missense_variant,p.I205V,ENST00000612719,NM_001242476.1&NM_001242475.1,c.613A>G,MODERATE,,deleterious(0.03),benign(0.001),1;ZNF345,missense_variant,p.I205V,ENST00000420450,NM_001242472.1,c.613A>G,MODERATE,,deleterious(0.03),benign(0.001),1;ZNF345,intron_variant,,ENST00000586933,,c.46+567A>G,MODIFIER,,,,1;ZNF345,intron_variant,,ENST00000526123,,c.46+567A>G,MODIFIER,,,,1;ZNF345,downstream_gene_variant,,ENST00000585396,,,MODIFIER,,,,1;ZNF345,downstream_gene_variant,,ENST00000532141,,,MODIFIER,,,,1;ZNF345,downstream_gene_variant,,ENST00000586646,,,MODIFIER,,,,1;ZNF345,downstream_gene_variant,,ENST00000331800,,,MODIFIER,,,,1;ZNF345,intron_variant,,ENST00000432005,,n.115-15375A>G,MODIFIER,,,,1;ZNF345,intron_variant,,ENST00000529989,,n.199-15375A>G,MODIFIER,,,,1;ZNF345,intron_variant,,ENST00000525851,,n.161-15375A>G,MODIFIER,,,,1;ZNF345,intron_variant,,ENST00000534729,,n.145-15375A>G,MODIFIER,,,,1	G	ENSG00000251247	ENST00000420450	Transcript	missense_variant	missense_variant	813/1971	613/1467	205/488	I/V	Ata/Gta		1		1	ZNF345	HGNC	HGNC:16367	protein_coding		CCDS12497.1	ENSP00000431216	Q14585		UPI000013C364	NM_001242472.1	deleterious(0.03)	benign(0.001)	3/3		PROSITE_profiles:PS50157;SMART_domains:SM00355;Superfamily_domains:SSF57667																	MODERATE		SNV	1			1											PASS	AATGTATAGAT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4077458	True	Unknown
C19orf33	64073	BI	GRCh38	chr19	38304645	38304645	+	Missense_Mutation	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.160G>A	p.Asp54Asn	p.D54N	ENST00000301246	3/4	27	18	9	43			C19orf33,missense_variant,p.D54N,ENST00000301246,NM_033520.1,c.160G>A,MODERATE,YES,tolerated_low_confidence(0.07),probably_damaging(0.913),1;CTB-102L5.4,synonymous_variant,p.P141P,ENST00000591889,,c.422G>A,LOW,YES,,,1;C19orf33,synonymous_variant,p.P73P,ENST00000588605,,c.219G>A,LOW,,,,1;CTB-102L5.4,synonymous_variant,p.P127P,ENST00000587519,,c.380G>A,LOW,,,,1;YIF1B,downstream_gene_variant,,ENST00000392124,NM_033557.3,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000337679,NM_001145463.1,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000339413,NM_001039673.2&NM_001039672.2,,MODIFIER,YES,,,-1;YIF1B,downstream_gene_variant,,ENST00000592694,,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000591755,,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000329420,NM_001039671.2&NM_001145461.1,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000591784,NM_001145462.1,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000592246,,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000589247,,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000588002,,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000587039,,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000587361,,,MODIFIER,,,,-1;C19orf33,non_coding_transcript_exon_variant,,ENST00000591852,,n.299G>A,MODIFIER,,,,1;C19orf33,non_coding_transcript_exon_variant,,ENST00000589986,,n.262G>A,MODIFIER,,,,1;YIF1B,downstream_gene_variant,,ENST00000589644,,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000585563,,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000586319,,,MODIFIER,,,,-1;YIF1B,downstream_gene_variant,,ENST00000589151,,,MODIFIER,,,,-1	A	ENSG00000167644	ENST00000301246	Transcript	missense_variant	missense_variant	261/467	160/321	54/106	D/N	Gac/Aac		1		1	C19orf33	HGNC	HGNC:16668	protein_coding	YES	CCDS12511.1	ENSP00000301246	Q9GZP8		UPI000006DC1A	NM_033520.1	tolerated_low_confidence(0.07)	probably_damaging(0.913)	3/4		Low_complexity_(Seg):Seg																	MODERATE	1	SNV	1			1											PASS	CTTCCGACTCC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4077686;COSM4077687	True	Unknown
RYR1	6261	BI	GRCh38	chr19	38500638	38500638	+	Silent	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.7356G>A	p.=	p.R2452R	ENST00000359596	46/106	78	65	13	102			RYR1,synonymous_variant,p.R2452R,ENST00000355481,NM_001042723.1,c.7356G>A,LOW,,,,1;RYR1,synonymous_variant,p.R2451R,ENST00000360985,,c.7353G>A,LOW,,,,1;RYR1,synonymous_variant,p.R2452R,ENST00000359596,NM_000540.2,c.7356G>A,LOW,YES,,,1;RYR1,synonymous_variant,p.R270R,ENST00000594335,,c.808G>A,LOW,,,,1	A	ENSG00000196218	ENST00000359596	Transcript	synonymous_variant	synonymous_variant	7356/15117	7356/15117	2452/5038	R	cgG/cgA		1		1	RYR1	HGNC	HGNC:10483	protein_coding	YES	CCDS33011.1	ENSP00000352608	P21817		UPI0000D7E62F	NM_000540.2			46/106																			LOW	1	SNV	5			1											PASS	CTGCGGATCCG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM3222466	True	Unknown
PPP1R13L	10848	BI	GRCh38	chr19	45396620	45396620	+	Missense_Mutation	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.637G>A	p.Ala213Thr	p.A213T	ENST00000360957	4/13	14	4	10	26			PPP1R13L,missense_variant,p.A213T,ENST00000418234,NM_001142502.1,c.637G>A,MODERATE,YES,tolerated(0.3),benign(0.026),-1;PPP1R13L,missense_variant,p.A213T,ENST00000360957,NM_006663.3,c.637G>A,MODERATE,,tolerated(0.3),benign(0.026),-1;PPP1R13L,upstream_gene_variant,,ENST00000612351,,,MODIFIER,,,,-1;PPP1R13L,downstream_gene_variant,,ENST00000593226,,,MODIFIER,,,,-1;PPP1R13L,downstream_gene_variant,,ENST00000592134,,,MODIFIER,,,,-1;PPP1R13L,non_coding_transcript_exon_variant,,ENST00000585905,,n.676G>A,MODIFIER,,,,-1;PPP1R13L,upstream_gene_variant,,ENST00000587270,,,MODIFIER,,,,-1	T	ENSG00000104881	ENST00000360957	Transcript	missense_variant	missense_variant	698/3104	637/2487	213/828	A/T	Gcg/Acg		1		-1	PPP1R13L	HGNC	HGNC:18838	protein_coding		CCDS33050.1	ENSP00000354218	Q8WUF5	A0A024R0Q5	UPI00001400F1	NM_006663.3	tolerated(0.3)	benign(0.026)	4/13		Low_complexity_(Seg):Seg;PROSITE_profiles:PS50099																	MODERATE		SNV	1			1											PASS	TGGCGCGTCGT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4079351	True	Unknown
CLEC11A	6320	BI	GRCh38	chr19	50723502	50723502	+	5'UTR	SNP	T	T	G	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.-24T>G			ENST00000250340	1/4	110	74	36	127			CLEC11A,5_prime_UTR_variant,,ENST00000250340,NM_002975.2,c.-24T>G,MODIFIER,YES,,,1;CLEC11A,5_prime_UTR_variant,,ENST00000617718,,c.-24T>G,MODIFIER,,,,1;SHANK1,upstream_gene_variant,,ENST00000391814,,,MODIFIER,,,,-1;CLEC11A,upstream_gene_variant,,ENST00000599973,,,MODIFIER,,,,1	G	ENSG00000105472	ENST00000250340	Transcript	5_prime_UTR_variant	5_prime_UTR_variant	174/1419	-/972	-/323				1		1	CLEC11A	HGNC	HGNC:10576	protein_coding	YES	CCDS12800.1	ENSP00000250340	Q9Y240	A0A0A6YY95	UPI0000073E53	NM_002975.2			1/4																			MODIFIER	1	SNV	1			1											PASS	GGAACTTTGGG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
AC011453.3	0	BI	GRCh38	chr19	53734908	53734908	+	RNA	SNP	T	T	A	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	n.46T>A			ENST00000385014	1/1	116	90	26	66			AC011453.3,mature_miRNA_variant,,ENST00000385014,,n.46T>A,MODIFIER,YES,,,1;MIR516B1,upstream_gene_variant,,ENST00000385211,,,MODIFIER,YES,,,1;RNU6-980P,upstream_gene_variant,,ENST00000516925,,,MODIFIER,YES,,,-1;MIR518E,downstream_gene_variant,,ENST00000385252,,,MODIFIER,YES,,,1;MIR518A2,upstream_gene_variant,,ENST00000384966,,,MODIFIER,YES,,,1;MIR518A1,downstream_gene_variant,,ENST00000385068,,,MODIFIER,YES,,,1	A	ENSG00000281027	ENST00000385014	Transcript	mature_miRNA_variant	mature_miRNA_variant	46/119						1		1	AC011453.3	Clone_based_ensembl_gene		miRNA	YES									1/1																			MODIFIER	1	SNV				1											PASS	AGCACTTTCTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
PRKCG	5582	BI	GRCh38	chr19	53904708	53904708	+	Missense_Mutation	SNP	C	C	T	rs551805527	by1000G	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1730C>T	p.Ser577Leu	p.S577L	ENST00000263431	16/18	39	34	5	55			PRKCG,missense_variant,p.S577L,ENST00000263431,NM_002739.3,c.1730C>T,MODERATE,YES,tolerated(0.64),possibly_damaging(0.699),1;CACNG7,upstream_gene_variant,,ENST00000391767,,,MODIFIER,YES,,,1;CACNG7,upstream_gene_variant,,ENST00000468076,,,MODIFIER,,,,1	T	ENSG00000126583	ENST00000263431	Transcript	missense_variant	missense_variant	2012/3133	1730/2094	577/697	S/L	tCg/tTg	rs551805527	1		1	PRKCG	HGNC	HGNC:9402	protein_coding	YES	CCDS12867.1	ENSP00000263431	P05129		UPI000000DC69	NM_002739.3	tolerated(0.64)	possibly_damaging(0.699)	16/18		Pfam_domain:PF00069;Pfam_domain:PF07714;PROSITE_profiles:PS50011;SMART_domains:SM00220;SMART_domains:SM00219;Superfamily_domains:SSF56112;PIRSF_domain:PIRSF000550	0.0002	0.0000	0.0000		0.0010	0.0000	0.0000										MODERATE	1	SNV	1			1	1.730e-04	0.00018	0	0	0.0001177	0	0.0002787	0	0.0001278		PASS	CAAGTCGCTTT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4081138;COSM4081139	True	Unknown
LILRB5	10990	BI	GRCh38	chr19	54252104	54252104	+	Missense_Mutation	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1579G>A	p.Ala527Thr	p.A527T	ENST00000449561	12/13	270	206	62	207			LILRB5,missense_variant,p.A526T,ENST00000316219,NM_006840.3,c.1576G>A,MODERATE,,deleterious(0.03),benign(0.059),-1;LILRB5,missense_variant,p.A527T,ENST00000449561,NM_001081442.1,c.1579G>A,MODERATE,YES,deleterious(0.03),possibly_damaging(0.477),-1;LILRB5,missense_variant,p.A427T,ENST00000345866,NM_001081443.1,c.1279G>A,MODERATE,,deleterious(0.03),benign(0.175),-1;LILRB2,intron_variant,,ENST00000612280,,c.714-11068G>A,MODIFIER,,,,-1;LILRB5,splice_region_variant,,ENST00000615654,,n.2592G>A,LOW,,,,-1;LILRB5,non_coding_transcript_exon_variant,,ENST00000621581,,n.3988G>A,MODIFIER,,,,-1;RPS9,downstream_gene_variant,,ENST00000448962,,,MODIFIER,,,,1;AC010492.4,upstream_gene_variant,,ENST00000506567,,,MODIFIER,YES,,,-1	T	ENSG00000105609	ENST00000449561	Transcript	missense_variant	missense_variant;splice_region_variant	1650/2137	1579/1776	527/591	A/T	Gct/Act		1		-1	LILRB5	HGNC	HGNC:6609	protein_coding	YES	CCDS46176.1	ENSP00000406478	O75023		UPI00034F239B	NM_001081442.1	deleterious(0.03)	possibly_damaging(0.477)	12/13																			MODERATE	1	SNV	1			1											PASS	GGCAGCATCTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4081238	True	Unknown
ZSCAN4	201516	BI	GRCh38	chr19	57678009	57678009	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.492A>C	p.Gln164His	p.Q164H	ENST00000318203	4/5	125	106	19	76			ZSCAN4,missense_variant,p.Q164H,ENST00000318203,NM_152677.2,c.492A>C,MODERATE,YES,deleterious(0.02),benign(0.002),1;ZSCAN4,missense_variant,p.Q164H,ENST00000612521,,c.492A>C,MODERATE,,deleterious(0.02),benign(0.002),1;ZNF551,upstream_gene_variant,,ENST00000282296,NM_138347.4,,MODIFIER,YES,,,1;ZNF551,upstream_gene_variant,,ENST00000601064,NM_001270938.1,,MODIFIER,,,,1;AC003006.7,upstream_gene_variant,,ENST00000594684,,,MODIFIER,YES,,,1;ZNF551,upstream_gene_variant,,ENST00000596085,,,MODIFIER,,,,1;ZNF551,upstream_gene_variant,,ENST00000599402,,,MODIFIER,,,,1;AC003006.7,upstream_gene_variant,,ENST00000599221,,,MODIFIER,,,,1	C	ENSG00000180532	ENST00000318203	Transcript	missense_variant	missense_variant	1189/2246	492/1302	164/433	Q/H	caA/caC		1		1	ZSCAN4	HGNC	HGNC:23709	protein_coding	YES	CCDS12958.1	ENSP00000321963	Q8NAM6		UPI000006E923	NM_152677.2	deleterious(0.02)	benign(0.002)	4/5																			MODERATE		SNV	2			1											PASS	GCCCAAACCAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4082176	True	Unknown
NINL	22981	BI	GRCh38	chr20	25498275	25498275	+	Missense_Mutation	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1104G>A	p.Met368Ile	p.M368I	ENST00000278886	9/24	47	36	11	42			NINL,missense_variant,p.M368I,ENST00000278886,NM_025176.4,c.1104G>A,MODERATE,YES,deleterious(0.05),benign(0.109),-1;NINL,missense_variant,p.M368I,ENST00000422516,,c.1104G>A,MODERATE,,tolerated(0.13),benign(0.053),-1;NINL,upstream_gene_variant,,ENST00000461642,,,MODIFIER,,,,-1	T	ENSG00000101004	ENST00000278886	Transcript	missense_variant	missense_variant	1178/4969	1104/4149	368/1382	M/I	atG/atA		1		-1	NINL	HGNC	HGNC:29163	protein_coding	YES	CCDS33452.1	ENSP00000278886	Q9Y2I6		UPI0000206B64	NM_025176.4	deleterious(0.05)	benign(0.109)	9/24																			MODERATE	1	SNV	1			1											PASS	ACTGTCATGAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4097302	True	Unknown
KCNK15	60598	BI	GRCh38	chr20	44745963	44745963	+	Missense_Mutation	SNP	A	A	G			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.53A>G	p.Tyr18Cys	p.Y18C	ENST00000372861	1/2	37	30	7	16			KCNK15,missense_variant,p.Y18C,ENST00000372861,NM_022358.3,c.53A>G,MODERATE,YES,deleterious(0),probably_damaging(1),1;KCNK15-AS1,splice_donor_variant,,ENST00000427303,,n.57+2T>C,HIGH,,,,-1;KCNK15-AS1,splice_donor_variant,,ENST00000445420,,n.31+2T>C,HIGH,,,,-1;RP4-781B1.5,upstream_gene_variant,,ENST00000611368,,,MODIFIER,YES,,,1	G	ENSG00000124249	ENST00000372861	Transcript	missense_variant	missense_variant	184/2599	53/993	18/330	Y/C	tAc/tGc		1		1	KCNK15	HGNC	HGNC:13814	protein_coding	YES	CCDS13337.1	ENSP00000361952	Q9H427		UPI000003EA1C	NM_022358.3	deleterious(0)	probably_damaging(1)	1/2		Cleavage_site_(Signalp):Sigp;Prints_domain:PR01095;Superfamily_domains:SSF81324;PIRSF_domain:PIRSF038061																	MODERATE	1	SNV	1			1											PASS	GTGTTACCTGC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4098731	True	Unknown
TSHZ2	128553	BI	GRCh38	chr20	53253540	53253540	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.82A>C	p.Lys28Gln	p.K28Q	ENST00000371497	2/3	19	6	13	14			TSHZ2,missense_variant,p.K28Q,ENST00000371497,NM_173485.5,c.82A>C,MODERATE,YES,tolerated(0.28),probably_damaging(0.987),1;TSHZ2,missense_variant,p.K25Q,ENST00000603338,NM_001193421.1,c.73A>C,MODERATE,,tolerated(0.35),possibly_damaging(0.607),1;TSHZ2,missense_variant,p.K25Q,ENST00000329613,,c.73A>C,MODERATE,,tolerated(0.35),possibly_damaging(0.607),1;RP4-678D15.1,downstream_gene_variant,,ENST00000606932,,,MODIFIER,YES,,,-1;TSHZ2,upstream_gene_variant,,ENST00000605656,,,MODIFIER,,,,1	C	ENSG00000182463	ENST00000371497	Transcript	missense_variant	missense_variant	969/12187	82/3105	28/1034	K/Q	Aaa/Caa		1		1	TSHZ2	HGNC	HGNC:13010	protein_coding	YES	CCDS33490.1	ENSP00000360552	Q9NRE2		UPI0000206747	NM_173485.5	tolerated(0.28)	probably_damaging(0.987)	2/3		Low_complexity_(Seg):Seg;Coiled-coils_(Ncoils):ncoils																	MODERATE	1	SNV	1			1											PASS	AAATAAAAGAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5	gdc_pon	COSM4099505	True	Unknown
LAMA5	3911	BI	GRCh38	chr20	62338295	62338295	+	Missense_Mutation	SNP	C	C	A	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.1693G>T	p.Gly565Cys	p.G565C	ENST00000252999	13/80	19	14	5	16			LAMA5,missense_variant,p.G565C,ENST00000252999,NM_005560.4,c.1693G>T,MODERATE,YES,,probably_damaging(1),-1;LAMA5,upstream_gene_variant,,ENST00000474128,,,MODIFIER,,,,-1	A	ENSG00000130702	ENST00000252999	Transcript	missense_variant	missense_variant	1760/11426	1693/11088	565/3695	G/C	Ggc/Tgc		1		-1	LAMA5	HGNC	HGNC:6485	protein_coding	YES	CCDS33502.1	ENSP00000252999	O15230		UPI0000161FDC	NM_005560.4		probably_damaging(1)	13/80		Pfam_domain:PF00053;PROSITE_profiles:PS50311;PROSITE_profiles:PS50027;SMART_domains:SM00181;SMART_domains:SM00180;Superfamily_domains:SSF57196																	MODERATE	1	SNV	1			1											PASS	GAAGCCCACTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			True	Unknown
FTCD	10841	BI	GRCh38	chr21	46154222	46154222	+	Silent	SNP	C	C	T	rs143451664	byCluster	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.165G>A	p.=	p.P55P	ENST00000291670	2/15	42	29	13	86			FTCD,synonymous_variant,p.P55P,ENST00000397748,,c.165G>A,LOW,,,,-1;FTCD,synonymous_variant,p.P55P,ENST00000291670,NM_006657.2,c.165G>A,LOW,YES,,,-1;FTCD,synonymous_variant,p.P55P,ENST00000397746,NM_206965.1,c.165G>A,LOW,,,,-1;FTCD,synonymous_variant,p.P55P,ENST00000397743,,c.165G>A,LOW,,,,-1;FTCD-AS1,downstream_gene_variant,,ENST00000446649,,,MODIFIER,YES,,,1;FTCD,non_coding_transcript_exon_variant,,ENST00000498355,,n.209G>A,MODIFIER,,,,-1	T	ENSG00000160282	ENST00000291670	Transcript	synonymous_variant	synonymous_variant	209/1905	165/1626	55/541	P	ccG/ccA	rs143451664	1		-1	FTCD	HGNC	HGNC:3974	protein_coding	YES	CCDS13731.1	ENSP00000291670	O95954			NM_006657.2			2/15		Pfam_domain:PF07837;TIGRFAM_domain:TIGR02024;Superfamily_domains:SSF55116								0.0002	0								LOW	1	SNV	1			1	8.266e-06	8.412e-06	9.889e-05	0	0	0	0	0	0		PASS	CACTCCGGCGG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4102188;COSM4102189	True	Unknown
OR11H1	81061	BI	GRCh38	chr22	15528450	15528450	+	Missense_Mutation	SNP	G	G	A	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.292G>A	p.Val98Ile	p.V98I	ENST00000252835	1/1	13	10	3	19			OR11H1,missense_variant,p.V98I,ENST00000252835,NM_001005239.1,c.292G>A,MODERATE,YES,tolerated(0.07),benign(0.009),1	A	ENSG00000130538	ENST00000252835	Transcript	missense_variant	missense_variant	293/982	292/981	98/326	V/I	Gtc/Atc		1		1	OR11H1	HGNC	HGNC:15404	protein_coding	YES	CCDS74807.1	ENSP00000252835	Q8NG94		UPI000004B1CF	NM_001005239.1	tolerated(0.07)	benign(0.009)	1/1		Pfam_domain:PF00001;Transmembrane_helices:Tmhmm;PROSITE_profiles:PS50262;Superfamily_domains:SSF81321																	MODERATE	1	SNV				1											PASS	TGTTGGTCAAC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			False	Unknown
TTLL1	25809	BI	GRCh38	chr22	43046559	43046559	+	Silent	SNP	C	C	T	rs143499869	byCluster	TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.993G>A	p.=	p.P331P	ENST00000266254	10/11	134	105	29	143			TTLL1,synonymous_variant,p.P331P,ENST00000266254,NM_012263.4,c.993G>A,LOW,YES,,,-1;TTLL1,synonymous_variant,p.P302P,ENST00000331018,,c.906G>A,LOW,,,,-1;AL022476.2,intron_variant,,ENST00000443063,,n.1771+5258C>T,MODIFIER,YES,,,1;TTLL1,3_prime_UTR_variant,,ENST00000440761,,c.*885G>A,MODIFIER,,,,-1;TTLL1,3_prime_UTR_variant,,ENST00000439248,,c.*917G>A,MODIFIER,,,,-1	T	ENSG00000100271	ENST00000266254	Transcript	synonymous_variant	synonymous_variant	1234/1645	993/1272	331/423	P	ccG/ccA	rs143499869	1		-1	TTLL1	HGNC	HGNC:1312	protein_coding	YES	CCDS14043.1	ENSP00000266254	O95922	A0A024R4U6	UPI00001377A7	NM_012263.4			10/11		Pfam_domain:PF03133;Superfamily_domains:SSF56059								0	0.0002								LOW	1	SNV	1			1	1.071e-04	0.0001071	0	0	0	0	0.0001649	0	0.0001211		PASS	AGAGACGGGGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4104598	True	Unknown
RAI2	10742	BI	GRCh38	chrX	17801416	17801416	+	Missense_Mutation	SNP	C	C	T			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.595G>A	p.Gly199Arg	p.G199R	ENST00000331511	3/3	21	10	11	31			RAI2,missense_variant,p.G199R,ENST00000545871,NM_001172739.1&NM_001172743.1,c.595G>A,MODERATE,YES,deleterious(0),unknown(0),-1;RAI2,missense_variant,p.G199R,ENST00000360011,,c.595G>A,MODERATE,,deleterious(0),unknown(0),-1;RAI2,missense_variant,p.G199R,ENST00000331511,,c.595G>A,MODERATE,,deleterious(0),unknown(0),-1;RAI2,missense_variant,p.G199R,ENST00000451717,NM_021785.4,c.595G>A,MODERATE,,deleterious(0),unknown(0),-1;RAI2,missense_variant,p.G149R,ENST00000415486,NM_001172732.1,c.445G>A,MODERATE,,deleterious(0),unknown(0),-1;RAI2,downstream_gene_variant,,ENST00000509491,,,MODIFIER,,,,-1	T	ENSG00000131831	ENST00000331511	Transcript	missense_variant	missense_variant	952/2317	595/1593	199/530	G/R	Ggg/Agg		1		-1	RAI2	HGNC	HGNC:9835	protein_coding		CCDS14183.1	ENSP00000333456	Q9Y5P3		UPI000013CE19		deleterious(0)	unknown(0)	3/3		Low_complexity_(Seg):Seg;PROSITE_profiles:PS50099																	MODERATE		SNV	2			1											PASS	GGGCCCGAGAG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4108445	True	Unknown
MAGEB18	286514	BI	GRCh38	chrX	26139483	26139483	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.498A>C	p.Glu166Asp	p.E166D	ENST00000325250	2/3	13	5	8	10			MAGEB18,missense_variant,p.E166D,ENST00000325250,NM_173699.3,c.498A>C,MODERATE,YES,deleterious(0),probably_damaging(0.997),1	C	ENSG00000176774	ENST00000325250	Transcript	missense_variant	missense_variant	685/1811	498/1032	166/343	E/D	gaA/gaC		1		1	MAGEB18	HGNC	HGNC:28515	protein_coding	YES	CCDS14216.1	ENSP00000314543	Q96M61		UPI00001415E3	NM_173699.3	deleterious(0)	probably_damaging(0.997)	2/3		Pfam_domain:PF01454;PROSITE_profiles:PS50838																	MODERATE	1	SNV	1			1											PASS	AAGGAAGTGGA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM184047	True	Unknown
MAGEB6P1	392433	BI	GRCh38	chrX	26161016	26161016	+	RNA	SNP	C	C	T	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	n.416C>T			ENST00000416929	1/1	40	16	24	65			MAGEB6P1,non_coding_transcript_exon_variant,,ENST00000416929,,n.416C>T,MODIFIER,YES,,,1	T	ENSG00000232030	ENST00000416929	Transcript	non_coding_transcript_exon_variant	non_coding_transcript_exon_variant;non_coding_transcript_variant	416/1296						1		1	MAGEB6P1	HGNC	HGNC:28824	unprocessed_pseudogene	YES									1/1																			MODIFIER	1	SNV				1											PASS	CACCTCCCGTG	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			False	Unknown
NXF5	55998	BI	GRCh38	chrX	101836035	101836035	+	3'UTR	SNP	A	A	T	novel		TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.*153T>A			ENST00000263032	17/19	29	11	18	50			NXF5,3_prime_UTR_variant,,ENST00000537026,,c.*153T>A,MODIFIER,,,,-1;NXF5,intron_variant,,ENST00000473265,NM_032946.2,c.1082+1457T>A,MODIFIER,YES,,,-1;NXF5,3_prime_UTR_variant,,ENST00000263032,,c.*153T>A,MODIFIER,,,,-1;NXF5,3_prime_UTR_variant,,ENST00000372803,,c.*215T>A,MODIFIER,,,,-1;NXF5,3_prime_UTR_variant,,ENST00000493509,,c.*751T>A,MODIFIER,,,,-1;NXF5,3_prime_UTR_variant,,ENST00000332614,,c.*343T>A,MODIFIER,,,,-1;NXF5,3_prime_UTR_variant,,ENST00000361330,,c.*215T>A,MODIFIER,,,,-1	T	ENSG00000126952	ENST00000263032	Transcript	3_prime_UTR_variant	3_prime_UTR_variant;NMD_transcript_variant	1707/2062	-/1194	-/397				1		-1	NXF5	HGNC	HGNC:8075	nonsense_mediated_decay			ENSP00000263032	Q9H1B4		UPI0000130AB2				17/19																			MODIFIER		SNV	1			1											PASS	ACTCTAGTTTC	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5			False	Unknown
IL1RAPL2	26280	BI	GRCh38	chrX	105484354	105484354	+	Missense_Mutation	SNP	G	G	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.739G>A	p.Glu247Lys	p.E247K	ENST00000372582	6/11	51	22	28	47			IL1RAPL2,missense_variant,p.E247K,ENST00000372582,NM_017416.1,c.739G>A,MODERATE,YES,tolerated(0.14),benign(0.135),1	A	ENSG00000189108	ENST00000372582	Transcript	missense_variant	missense_variant	1495/2985	739/2061	247/686	E/K	Gag/Aag		1		1	IL1RAPL2	HGNC	HGNC:5997	protein_coding	YES	CCDS14517.1	ENSP00000361663	Q9NP60		UPI0000073DF7	NM_017416.1	tolerated(0.14)	benign(0.135)	6/11		PROSITE_profiles:PS50835;Superfamily_domains:SSF48726																	MODERATE	1	SNV	1			1											PASS	CCATGGAGAAT	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4105552	True	Unknown
TENM1	10178	BI	GRCh38	chrX	124894345	124894345	+	Silent	SNP	T	T	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.486A>G	p.=	p.K162K	ENST00000371130	3/31	45	22	23	47			TENM1,synonymous_variant,p.K162K,ENST00000422452,NM_001163279.1&NM_001163278.1,c.486A>G,LOW,YES,,,-1;TENM1,synonymous_variant,p.K162K,ENST00000371130,NM_014253.3,c.486A>G,LOW,,,,-1	C	ENSG00000009694	ENST00000371130	Transcript	synonymous_variant	synonymous_variant	550/12875	486/8178	162/2725	K	aaA/aaG		1		-1	TENM1	HGNC	HGNC:8117	protein_coding		CCDS14609.1	ENSP00000360171	Q9UKZ4		UPI0000050EDD	NM_014253.3			3/31		Pfam_domain:PF06484																	LOW		SNV	1			1											PASS	GAGAATTTGAA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4106438;COSM4907568	True	Unknown
ACTRT1	139741	BI	GRCh38	chrX	128051999	128051999	+	Missense_Mutation	SNP	A	A	C			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.208T>G	p.Leu70Val	p.L70V	ENST00000371124	1/1	80	53	27	90			ACTRT1,missense_variant,p.L70V,ENST00000371124,NM_138289.3,c.208T>G,MODERATE,YES,deleterious(0.03),possibly_damaging(0.874),-1	C	ENSG00000123165	ENST00000371124	Transcript	missense_variant	missense_variant	400/1437	208/1131	70/376	L/V	Ttg/Gtg		1		-1	ACTRT1	HGNC	HGNC:24027	protein_coding	YES	CCDS14611.1	ENSP00000360165	Q8TDG2		UPI0000072276	NM_138289.3	deleterious(0.03)	possibly_damaging(0.874)	1/1		Pfam_domain:PF00022;Prints_domain:PR00190;SMART_domains:SM00268;Superfamily_domains:SSF53067																	MODERATE	1	SNV				1											PASS	GTGCAAATGTA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4106515	True	Unknown
FLNA	2316	BI	GRCh38	chrX	154359616	154359616	+	Missense_Mutation	SNP	C	C	A			TCGA-BR-7723-01A-11D-2053-08	TCGA-BR-7723-10A-01D-2053-08									Somatic						Illumina HiSeq 2000	d5946cac-08ce-4512-823d-6c2fa6e73150	daa716c5-0804-49e0-88e8-811cf079546d	c.4010G>T	p.Gly1337Val	p.G1337V	ENST00000369850	24/48	14	4	10	35			FLNA,missense_variant,p.G1337V,ENST00000422373,NM_001456.3,c.4010G>T,MODERATE,,deleterious(0),possibly_damaging(0.578),-1;FLNA,missense_variant,p.G1337V,ENST00000369850,NM_001110556.1,c.4010G>T,MODERATE,YES,deleterious(0),possibly_damaging(0.523),-1;FLNA,missense_variant,p.G1337V,ENST00000360319,,c.4010G>T,MODERATE,,deleterious(0),possibly_damaging(0.578),-1;FLNA,missense_variant,p.G1310V,ENST00000369856,,c.3929G>T,MODERATE,,deleterious(0),possibly_damaging(0.523),-1;FLNA,missense_variant,p.G1337V,ENST00000344736,,c.4010G>T,MODERATE,,deleterious(0),probably_damaging(0.931),-1;FLNA,missense_variant,p.G1310V,ENST00000610817,,c.3929G>T,MODERATE,,deleterious(0),possibly_damaging(0.599),-1;FLNA,upstream_gene_variant,,ENST00000438732,,,MODIFIER,,,,-1;FLNA,upstream_gene_variant,,ENST00000466319,,,MODIFIER,,,,-1;FLNA,3_prime_UTR_variant,,ENST00000420627,,c.*2151G>T,MODIFIER,,,,-1;FLNA,non_coding_transcript_exon_variant,,ENST00000490936,,n.23G>T,MODIFIER,,,,-1;FLNA,upstream_gene_variant,,ENST00000474072,,,MODIFIER,,,,-1	A	ENSG00000196924	ENST00000369850	Transcript	missense_variant	missense_variant	4247/8382	4010/7944	1337/2647	G/V	gGc/gTc		1		-1	FLNA	HGNC	HGNC:3754	protein_coding	YES	CCDS48194.1	ENSP00000358866	P21333		UPI000013C596	NM_001110556.1	deleterious(0)	possibly_damaging(0.523)	24/48		Pfam_domain:PF00630;PROSITE_profiles:PS50194;SMART_domains:SM00557;Superfamily_domains:SSF81296																	MODERATE	1	SNV	1			1											PASS	GACTGCCGTCA	7a43e3f9-b0da-4b99-bc9d-952993860263	ff99c2ca-1bee-4b4f-a0ef-44dc7d6c1f31	e2b34fb9-d7af-4449-bd41-0414ea5c8087	bb3729fe-2fa2-47fc-afde-c14036cb84f5		COSM4108075;COSM4108076	True	Unknown
TTLL10	254173	BI	GRCh38	chr1	1182380	1182380	+	Frame_Shift_Del	DEL	T	T	-	novel		TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.854delT	p.Phe285SerfsTer107	p.F285Sfs*107	ENST00000379289	10/16	134	95	39	184			TTLL10,frameshift_variant,p.F285Sfs*107,ENST00000379290,,c.854delT,HIGH,YES,,,1;TTLL10,frameshift_variant,p.F285Sfs*107,ENST00000379289,NM_001130045.1,c.854delT,HIGH,,,,1;TTLL10,frameshift_variant,p.F212Sfs*107,ENST00000379288,NM_153254.2,c.635delT,HIGH,,,,1;TTLL10-AS1,upstream_gene_variant,,ENST00000379317,,,MODIFIER,YES,,,-1;TTLL10,non_coding_transcript_exon_variant,,ENST00000460998,,n.476delT,MODIFIER,,,,1;TTLL10,upstream_gene_variant,,ENST00000486379,,,MODIFIER,,,,1;TTLL10,downstream_gene_variant,,ENST00000514695,,,MODIFIER,,,,1	-	ENSG00000162571	ENST00000379289	Transcript	frameshift_variant	frameshift_variant	1001/2259	850/2022	284/673	F/X	Ttt/tt		1		1	TTLL10	HGNC	HGNC:26693	protein_coding		CCDS44036.1	ENSP00000368591	Q6ZVT0		UPI0000205ADB	NM_001130045.1			10/16		Pfam_domain:PF03133;Superfamily_domains:SSF56059																	HIGH		deletion	2	4		1											PASS	GAAGAGTTTTTC	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c			True	Unknown
MXRA8	54587	BI	GRCh38	chr1	1354730	1354730	+	Frame_Shift_Del	DEL	G	G	-	rs764857791	byFrequency	TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.901delC	p.Arg301GlyfsTer107	p.R301Gfs*107	ENST00000309212	5/10	26	22	4	43			MXRA8,frameshift_variant,p.R292Gfs*107,ENST00000477278,NM_001282583.1,c.874delC,HIGH,,,,-1;MXRA8,frameshift_variant,p.R301Gfs*107,ENST00000309212,NM_001282582.1&NM_032348.3,c.901delC,HIGH,,,,-1;MXRA8,frameshift_variant,p.R200Gfs*107,ENST00000342753,NM_001282584.1,c.598delC,HIGH,,,,-1;MXRA8,frameshift_variant,p.R301Gfs*107,ENST00000445648,NM_001282585.1,c.901delC,HIGH,YES,,,-1;MXRA8,non_coding_transcript_exon_variant,,ENST00000476718,,n.287delC,MODIFIER,,,,-1;MXRA8,upstream_gene_variant,,ENST00000474033,,,MODIFIER,,,,-1;MXRA8,upstream_gene_variant,,ENST00000473097,,,MODIFIER,,,,-1;MXRA8,upstream_gene_variant,,ENST00000478517,,,MODIFIER,,,,-1;MXRA8,downstream_gene_variant,,ENST00000464351,,,MODIFIER,,,,-1;MXRA8,downstream_gene_variant,,ENST00000460473,,,MODIFIER,,,,-1	-	ENSG00000162576	ENST00000309212	Transcript	frameshift_variant	frameshift_variant	932/2273	901/1329	301/442	R/X	Cgg/gg	rs764857791	1		-1	MXRA8	HGNC	HGNC:7542	protein_coding		CCDS24.1	ENSP00000307887	Q9BRK3		UPI000003ED26	NM_001282582.1;NM_032348.3			5/10		Low_complexity_(Seg):Seg								0.0087	0.0098								HIGH		deletion	1			1	6.744e-05	7.301e-05	0	0.0001477	0.0003962	0	5.371e-05	0	0		PASS	AGCCCCGGGGGG	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM1333407	True	Unknown
NPHP4	261734	BI	GRCh38	chr1	5905367	5905367	+	Missense_Mutation	SNP	G	G	A	rs199891059	by1000G;byCluster;byFrequency	TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.1880C>T	p.Thr627Met	p.T627M	ENST00000378156	15/30	162	115	46	229			NPHP4,missense_variant,p.T627M,ENST00000378156,NM_015102.3,c.1880C>T,MODERATE,YES,tolerated(0.1),benign(0.045),-1;NPHP4,missense_variant,p.T626M,ENST00000622020,,c.1877C>T,MODERATE,,tolerated(0.1),possibly_damaging(0.646),-1;NPHP4,non_coding_transcript_exon_variant,,ENST00000478423,,n.1612C>T,MODIFIER,,,,-1;NPHP4,missense_variant,p.T626M,ENST00000489180,,c.1877C>T,MODERATE,,tolerated(0.1),possibly_damaging(0.646),-1;NPHP4,3_prime_UTR_variant,,ENST00000378169,,c.*781C>T,MODIFIER,,,,-1;NPHP4,upstream_gene_variant,,ENST00000466897,,,MODIFIER,,,,-1	A	ENSG00000131697	ENST00000378156	Transcript	missense_variant	missense_variant	2146/4994	1880/4281	627/1426	T/M	aCg/aTg	rs199891059	1		-1	NPHP4	HGNC	HGNC:19104	protein_coding	YES	CCDS44052.1	ENSP00000367398	O75161		UPI00001303E5	NM_015102.3	tolerated(0.1)	benign(0.045)	15/30			0.0006	0.0000	0.0014		0.0000	0.0000	0.0020										MODERATE	1	SNV	1		1	1	3.060e-04	0.0003064	0	0.0004319	0	0	0.0001199	0.002222	0.001332		PASS	TAAACGTCACA	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c	common_in_exac	COSM4009118	True	Unknown
NPHP4	261734	BI	GRCh38	chr1	5905411	5905411	+	Silent	SNP	G	G	T			TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.1836C>A	p.=	p.A612A	ENST00000378156	15/30	92	82	10	141			NPHP4,synonymous_variant,p.A612A,ENST00000378156,NM_015102.3,c.1836C>A,LOW,YES,,,-1;NPHP4,synonymous_variant,p.A611A,ENST00000622020,,c.1833C>A,LOW,,,,-1;NPHP4,non_coding_transcript_exon_variant,,ENST00000478423,,n.1568C>A,MODIFIER,,,,-1;NPHP4,synonymous_variant,p.A611A,ENST00000489180,,c.1833C>A,LOW,,,,-1;NPHP4,3_prime_UTR_variant,,ENST00000378169,,c.*737C>A,MODIFIER,,,,-1;NPHP4,upstream_gene_variant,,ENST00000466897,,,MODIFIER,,,,-1	T	ENSG00000131697	ENST00000378156	Transcript	synonymous_variant	synonymous_variant	2102/4994	1836/4281	612/1426	A	gcC/gcA		1		-1	NPHP4	HGNC	HGNC:19104	protein_coding	YES	CCDS44052.1	ENSP00000367398	O75161		UPI00001303E5	NM_015102.3			15/30																			LOW	1	SNV	1			1											PASS	TTATTGGCATC	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM4009119	True	Unknown
DNAJC11	55735	BI	GRCh38	chr1	6652847	6652847	+	Silent	SNP	C	C	T			TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.612G>A	p.=	p.S204S	ENST00000377577	6/16	95	69	26	133			DNAJC11,synonymous_variant,p.S204S,ENST00000377577,NM_018198.3,c.612G>A,LOW,YES,,,-1;DNAJC11,synonymous_variant,p.S204S,ENST00000294401,,c.612G>A,LOW,,,,-1;DNAJC11,synonymous_variant,p.S180S,ENST00000451196,,c.540G>A,LOW,,,,-1;DNAJC11,synonymous_variant,p.S204S,ENST00000426784,,c.612G>A,LOW,,,,-1;DNAJC11,non_coding_transcript_exon_variant,,ENST00000473993,,n.560G>A,MODIFIER,,,,-1;DNAJC11,downstream_gene_variant,,ENST00000485073,,,MODIFIER,,,,-1;DNAJC11,downstream_gene_variant,,ENST00000460594,,,MODIFIER,,,,-1;DNAJC11,downstream_gene_variant,,ENST00000469318,,,MODIFIER,,,,-1	T	ENSG00000007923	ENST00000377577	Transcript	synonymous_variant	synonymous_variant	736/3311	612/1680	204/559	S	tcG/tcA		1		-1	DNAJC11	HGNC	HGNC:25570	protein_coding	YES	CCDS87.1	ENSP00000366800	Q9NVH1		UPI000020544B	NM_018198.3			6/16																			LOW	1	SNV	1			1											PASS	TTTGCCGAAGT	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM4009546;COSM4009547;COSM4009548	True	Unknown
SPSB1	80176	BI	GRCh38	chr1	9356327	9356327	+	Missense_Mutation	SNP	C	C	T	rs751984624		TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.436C>T	p.Arg146Cys	p.R146C	ENST00000328089	2/3	62	47	14	99			SPSB1,missense_variant,p.R146C,ENST00000328089,NM_025106.3,c.436C>T,MODERATE,YES,deleterious(0),probably_damaging(0.997),1;SPSB1,missense_variant,p.R146C,ENST00000357898,,c.436C>T,MODERATE,,deleterious(0),probably_damaging(0.997),1;SPSB1,missense_variant,p.R146C,ENST00000377399,,c.436C>T,MODERATE,,deleterious(0),probably_damaging(0.997),1;SPSB1,missense_variant,p.R146C,ENST00000450402,,c.436C>T,MODERATE,,deleterious(0),probably_damaging(0.997),1	T	ENSG00000171621	ENST00000328089	Transcript	missense_variant	missense_variant	777/3120	436/822	146/273	R/C	Cgc/Tgc	rs751984624	1		1	SPSB1	HGNC	HGNC:30628	protein_coding	YES	CCDS102.1	ENSP00000330221	Q96BD6	A0A024R4G8	UPI000006D00B	NM_025106.3	deleterious(0)	probably_damaging(0.997)	2/3		Pfam_domain:PF00622;PROSITE_profiles:PS50188;SMART_domains:SM00449;Superfamily_domains:SSF49899																	MODERATE	1	SNV	1			1	8.236e-06	8.259e-06	0	0	0	0	1.504e-05	0	0		PASS	TGGGGCGCAAC	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM4010678	True	Unknown
PEX14	5195	BI	GRCh38	chr1	10629960	10629960	+	Silent	SNP	C	C	T	rs781098256	byFrequency	TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.1107C>T	p.=	p.G369G	ENST00000356607	9/9	49	38	10	82			PEX14,synonymous_variant,p.G369G,ENST00000356607,NM_004565.2,c.1107C>T,LOW,YES,,,1	T	ENSG00000142655	ENST00000356607	Transcript	synonymous_variant	synonymous_variant	1187/1985	1107/1134	369/377	G	ggC/ggT	rs781098256	1		1	PEX14	HGNC	HGNC:8856	protein_coding	YES	CCDS30582.1	ENSP00000349016	O75381		UPI000013170A	NM_004565.2			9/9																			LOW	1	SNV	1			1	4.622e-04	0.0004747	0	0.004668	0	0	1.543e-05	0	0.000122		PASS	GAGGGCGCCAG	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c	common_in_exac	COSM4020080	True	Unknown
MTOR	2475	BI	GRCh38	chr1	11115469	11115469	+	Splice_Site	SNP	C	C	A			TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.7017-1G>T		p.X2339_splice	ENST00000361445		107	82	25	140			MTOR,splice_acceptor_variant,p.X2339_splice,ENST00000361445,NM_004958.3,c.7017-1G>T,HIGH,YES,,,-1;MTOR,splice_acceptor_variant,p.X544_splice,ENST00000376838,,c.1632-1G>T,HIGH,,,,-1;MTOR,5_prime_UTR_variant,,ENST00000455339,,c.-17G>T,MODIFIER,,,,-1;MTOR,non_coding_transcript_exon_variant,,ENST00000490931,,n.59G>T,MODIFIER,,,,-1;MTOR,upstream_gene_variant,,ENST00000473471,,,MODIFIER,,,,-1	A	ENSG00000198793	ENST00000361445	Transcript	splice_acceptor_variant	splice_acceptor_variant	-/8677	7017/7650	2339/2549				1		-1	MTOR	HGNC	HGNC:3942	protein_coding	YES	CCDS127.1	ENSP00000354558	P42345		UPI000012ABD3	NM_004958.3				50/57																		HIGH	1	SNV	1			1											PASS	GGTGTCTTTGA	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM4020603	True	Unknown
MFN2	9927	BI	GRCh38	chr1	11999082	11999082	+	Missense_Mutation	SNP	A	A	C			TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.803A>C	p.Glu268Ala	p.E268A	ENST00000235329	8/19	91	67	24	130			MFN2,missense_variant,p.E268A,ENST00000235329,NM_014874.3,c.803A>C,MODERATE,YES,deleterious(0),probably_damaging(0.986),1;MFN2,missense_variant,p.E268A,ENST00000444836,NM_001127660.1,c.803A>C,MODERATE,,deleterious(0),probably_damaging(0.986),1	C	ENSG00000116688	ENST00000235329	Transcript	missense_variant	missense_variant	1125/4539	803/2274	268/757	E/A	gAg/gCg		1		1	MFN2	HGNC	HGNC:16877	protein_coding	YES	CCDS30587.1	ENSP00000235329	O95140		UPI0000039854	NM_014874.3	deleterious(0)	probably_damaging(0.986)	8/19		Superfamily_domains:SSF52540																	MODERATE	1	SNV	1			1											PASS	GCCCGAGTACA	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM4021331	True	Unknown
PRAMEF11	440560	BI	GRCh38	chr1	12827650	12827650	+	Missense_Mutation	SNP	C	C	G	novel		TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.474G>C	p.Lys158Asn	p.K158N	ENST00000619922	3/4	423	316	106	643			PRAMEF11,missense_variant,p.K158N,ENST00000619922,,c.474G>C,MODERATE,YES,tolerated(0.28),possibly_damaging(0.864),-1;PRAMEF11,missense_variant,p.K116N,ENST00000355096,NM_001146344.1,c.348G>C,MODERATE,YES,tolerated(0.15),possibly_damaging(0.864),-1;RP5-845O24.8,upstream_gene_variant,,ENST00000438401,,,MODIFIER,YES,,,-1	G	ENSG00000239810	ENST00000619922	Transcript	missense_variant	missense_variant	545/1845	474/1437	158/478	K/N	aaG/aaC		1		-1	PRAMEF11	HGNC	HGNC:14086	protein_coding	YES		ENSP00000480027		A0A087WW85	UPI0003EAF149		tolerated(0.28)	possibly_damaging(0.864)	3/4																			MODERATE	1	SNV	1			1											PASS	CTGTTCTTGAG	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c			True	Unknown
PRAMEF20	645425	BI	GRCh38	chr1	13420853	13420853	+	Missense_Mutation	SNP	A	A	C	novel		TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.1023A>C	p.Gln341His	p.Q341H	ENST00000316412	4/4	483	359	124	691			PRAMEF20,missense_variant,p.Q341H,ENST00000316412,NM_001099852.1,c.1023A>C,MODERATE,YES,deleterious(0.05),possibly_damaging(0.905),1;PRAMEF20,missense_variant,p.Q341H,ENST00000602960,,c.1023A>C,MODERATE,,deleterious(0.05),possibly_damaging(0.905),1	C	ENSG00000204478	ENST00000316412	Transcript	missense_variant	missense_variant	1122/1597	1023/1428	341/475	Q/H	caA/caC		1		1	PRAMEF20	HGNC	HGNC:25224	protein_coding	YES	CCDS41265.1	ENSP00000346275	Q5VT98		UPI0004423C14	NM_001099852.1	deleterious(0.05)	possibly_damaging(0.905)	4/4		Superfamily_domains:SSF52047																	MODERATE	1	SNV	5			1											PASS	CTCCAAGTTCT	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c			False	Unknown
PDPN	10630	BI	GRCh38	chr1	13615948	13615948	+	3'UTR	DEL	A	A	-	rs34988689		TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.*43delA			ENST00000621990	6/6	93	73	20	108			PDPN,3_prime_UTR_variant,,ENST00000294489,,c.*43delA,MODIFIER,YES,,,1;PDPN,3_prime_UTR_variant,,ENST00000617617,NM_006474.4,c.*43delA,MODIFIER,,,,1;PDPN,3_prime_UTR_variant,,ENST00000376057,NM_198389.2,c.*43delA,MODIFIER,,,,1;PDPN,3_prime_UTR_variant,,ENST00000621990,,c.*43delA,MODIFIER,,,,1;PDPN,3_prime_UTR_variant,,ENST00000376061,,c.*43delA,MODIFIER,,,,1;PDPN,3_prime_UTR_variant,,ENST00000513143,,c.*43delA,MODIFIER,,,,1;PDPN,3_prime_UTR_variant,,ENST00000475043,NM_001006625.1,c.*43delA,MODIFIER,,,,1;PDPN,3_prime_UTR_variant,,ENST00000509009,,c.*43delA,MODIFIER,,,,1;PDPN,downstream_gene_variant,,ENST00000510906,,,MODIFIER,,,,1;PDPN,downstream_gene_variant,,ENST00000487038,NM_001006624.1,,MODIFIER,,,,1;PDPN,3_prime_UTR_variant,,ENST00000488631,,c.*138delA,MODIFIER,,,,1	-	ENSG00000162493	ENST00000621990	Transcript	3_prime_UTR_variant	3_prime_UTR_variant	729/2738	-/489	-/162			rs34988689	1		1	PDPN	HGNC	HGNC:29602	protein_coding			ENSP00000478125	Q86YL7		UPI000000D8BC				6/6																			MODIFIER		deletion	1	6		1											PASS	GTGCTTAAAAAA	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSN2375000	True	Unknown
PRDM2	7799	BI	GRCh38	chr1	13781256	13781256	+	Missense_Mutation	SNP	C	C	A			TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.3461C>A	p.Ser1154Tyr	p.S1154Y	ENST00000235372	8/10	100	71	29	140			PRDM2,missense_variant,p.S1154Y,ENST00000235372,NM_012231.4,c.3461C>A,MODERATE,YES,,unknown(0),1;PRDM2,missense_variant,p.S1154Y,ENST00000311066,NM_015866.4,c.3461C>A,MODERATE,,,unknown(0),1;PRDM2,missense_variant,p.S953Y,ENST00000413440,NM_001007257.2,c.2858C>A,MODERATE,,,benign(0.27),1;PRDM2,missense_variant,p.S953Y,ENST00000343137,,c.2858C>A,MODERATE,,,benign(0.27),1;PRDM2,intron_variant,,ENST00000376048,NM_001135610.1,c.511+31769C>A,MODIFIER,,,,1;PRDM2,intron_variant,,ENST00000503842,,c.19+8068C>A,MODIFIER,,,,1;PRDM2,intron_variant,,ENST00000505823,,c.19+8068C>A,MODIFIER,,,,1;PRDM2,downstream_gene_variant,,ENST00000487453,,,MODIFIER,,,,1;PRDM2,downstream_gene_variant,,ENST00000407521,,,MODIFIER,,,,1;PRDM2,intron_variant,,ENST00000491134,,c.*413-5259C>A,MODIFIER,,,,1	A	ENSG00000116731	ENST00000235372	Transcript	missense_variant	missense_variant	4317/7957	3461/5157	1154/1718	S/Y	tCt/tAt		1		1	PRDM2	HGNC	HGNC:9347	protein_coding	YES	CCDS150.1	ENSP00000235372	Q13029		UPI000013C9CD	NM_012231.4		unknown(0)	8/10		PROSITE_profiles:PS50157;SMART_domains:SM00355;Superfamily_domains:SSF57667;PIRSF_domain:PIRSF002395																	MODERATE	1	SNV	1			1											PASS	TTTATCTATTC	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM4021554	True	Unknown
KAZN	23254	BI	GRCh38	chr1	15063574	15063574	+	Splice_Region	SNP	C	C	T	rs747019324	byFrequency	TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.1050C>T	p.=	p.G350G	ENST00000376030	7/15	40	31	9	71			KAZN,splice_region_variant,p.G350G,ENST00000376030,NM_201628.2,c.1050C>T,LOW,YES,,,1;KAZN,splice_region_variant,p.G344G,ENST00000361144,NM_001018000.3,c.1032C>T,LOW,,,,1;KAZN,splice_region_variant,p.G256G,ENST00000400798,NM_001018001.2,c.768C>T,LOW,,,,1;KAZN,splice_region_variant,p.G350G,ENST00000503743,NM_015209.2,c.1050C>T,LOW,,,,1;KAZN,splice_region_variant,p.G256G,ENST00000400797,NM_001017999.2,c.768C>T,LOW,,,,1;KAZN,non_coding_transcript_exon_variant,,ENST00000491547,,n.4613C>T,MODIFIER,,,,1	T	ENSG00000189337	ENST00000376030	Transcript	splice_region_variant	splice_region_variant;synonymous_variant	1344/6030	1050/2328	350/775	G	ggC/ggT	rs747019324	1		1	KAZN	HGNC	HGNC:29173	protein_coding	YES	CCDS152.2	ENSP00000365198	Q674X7		UPI0000E1E68A	NM_201628.2			7/15																			LOW	1	SNV	5			1	2.471e-05	2.475e-05	0	8.657e-05	0.0001156	0	1.5e-05	0	0		PASS	CAGGGCGACAG	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c	gdc_pon	COSM2208117;COSM2208118	True	Unknown
SPEN	23013	BI	GRCh38	chr1	15876221	15876221	+	Missense_Mutation	SNP	C	C	T			TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.424C>T	p.Arg142Cys	p.R142C	ENST00000375759	3/15	34	27	7	57			SPEN,missense_variant,p.R142C,ENST00000375759,NM_015001.2,c.424C>T,MODERATE,YES,,probably_damaging(0.997),1;SPEN,missense_variant,p.R101C,ENST00000438066,,c.301C>T,MODERATE,,deleterious_low_confidence(0),possibly_damaging(0.685),1;SPEN,upstream_gene_variant,,ENST00000442985,,,MODIFIER,,,,1;SPEN,non_coding_transcript_exon_variant,,ENST00000471538,,n.914C>T,MODIFIER,,,,1	T	ENSG00000065526	ENST00000375759	Transcript	missense_variant	missense_variant	628/12232	424/10995	142/3664	R/C	Cgt/Tgt		1		1	SPEN	HGNC	HGNC:17575	protein_coding	YES	CCDS164.1	ENSP00000364912	Q96T58			NM_015001.2		probably_damaging(0.997)	3/15		PROSITE_profiles:PS50323;Superfamily_domains:SSF54928																	MODERATE	1	SNV	1			1											PASS	GGGAGCGTGCT	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM4024483;COSM4024484	True	Unknown
SPEN	23013	BI	GRCh38	chr1	15933970	15933970	+	Missense_Mutation	SNP	A	A	G			TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.7730A>G	p.Asp2577Gly	p.D2577G	ENST00000375759	11/15	133	96	37	210			SPEN,missense_variant,p.D2577G,ENST00000375759,NM_015001.2,c.7730A>G,MODERATE,YES,,benign(0.07),1;SPEN,upstream_gene_variant,,ENST00000487496,,,MODIFIER,,,,1	G	ENSG00000065526	ENST00000375759	Transcript	missense_variant	missense_variant	7934/12232	7730/10995	2577/3664	D/G	gAc/gGc		1		1	SPEN	HGNC	HGNC:17575	protein_coding	YES	CCDS164.1	ENSP00000364912	Q96T58			NM_015001.2		benign(0.07)	11/15																			MODERATE	1	SNV	1			1											PASS	AGTTGACTCTA	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM4024564	True	Unknown
EPHA2	1969	BI	GRCh38	chr1	16135161	16135161	+	Missense_Mutation	SNP	C	C	T			TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.1457G>A	p.Arg486His	p.R486H	ENST00000358432	7/17	180	138	40	296			EPHA2,missense_variant,p.R486H,ENST00000358432,NM_004431.3,c.1457G>A,MODERATE,YES,deleterious(0.04),benign(0.408),-1;EPHA2,non_coding_transcript_exon_variant,,ENST00000480202,,n.662G>A,MODIFIER,,,,-1;EPHA2,upstream_gene_variant,,ENST00000462805,,,MODIFIER,,,,-1	T	ENSG00000142627	ENST00000358432	Transcript	missense_variant	missense_variant	1612/3964	1457/2931	486/976	R/H	cGc/cAc		1		-1	EPHA2	HGNC	HGNC:3386	protein_coding	YES	CCDS169.1	ENSP00000351209	P29317	A0A024QZA8	UPI00000731AB	NM_004431.3	deleterious(0.04)	benign(0.408)	7/17		Pfam_domain:PF00041;Pfam_domain:PF09294;PROSITE_profiles:PS50853;SMART_domains:SM00060;Superfamily_domains:SSF49265;PIRSF_domain:PIRSF000666																	MODERATE	1	SNV	1			1											PASS	CGGTGCGGCGC	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM4024689	True	Unknown
PADI3	51702	BI	GRCh38	chr1	17266732	17266732	+	Frame_Shift_Del	DEL	G	G	-	novel		TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.426delG	p.Ser144ValfsTer9	p.S144Vfs*9	ENST00000375460	5/16	99	74	25	137			PADI3,frameshift_variant,p.S144Vfs*9,ENST00000375460,NM_016233.2,c.426delG,HIGH,YES,,,1	-	ENSG00000142619	ENST00000375460	Transcript	frameshift_variant	frameshift_variant	462/3189	422/1995	141/664	W/X	tGg/tg		1		1	PADI3	HGNC	HGNC:18337	protein_coding	YES	CCDS179.1	ENSP00000364609	Q9ULW8		UPI000013D8A0	NM_016233.2			5/16		Pfam_domain:PF08527;PIRSF_domain:PIRSF001247;Superfamily_domains:SSF110083																	HIGH	1	deletion	1	4		1											PASS	GGGTCTGGGGGC	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c			False	Unknown
ARHGEF10L	55160	BI	GRCh38	chr1	17697186	17697186	+	Missense_Mutation	SNP	G	G	A			TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.3646G>A	p.Asp1216Asn	p.D1216N	ENST00000361221	29/29	43	34	9	52			ARHGEF10L,missense_variant,p.D1216N,ENST00000361221,NM_018125.3,c.3646G>A,MODERATE,YES,deleterious(0),probably_damaging(0.998),1;ARHGEF10L,missense_variant,p.D1177N,ENST00000375415,NM_001011722.2,c.3529G>A,MODERATE,,deleterious(0),probably_damaging(0.969),1;ARHGEF10L,missense_variant,p.D989N,ENST00000375408,,c.2965G>A,MODERATE,,deleterious(0),probably_damaging(0.936),1;ARHGEF10L,non_coding_transcript_exon_variant,,ENST00000469726,,n.3911G>A,MODIFIER,,,,1;ARHGEF10L,3_prime_UTR_variant,,ENST00000167825,,c.*500G>A,MODIFIER,,,,1;ARHGEF10L,non_coding_transcript_exon_variant,,ENST00000495593,,n.1573G>A,MODIFIER,,,,1	A	ENSG00000074964	ENST00000361221	Transcript	missense_variant	missense_variant	3805/4488	3646/3840	1216/1279	D/N	Gac/Aac		1		1	ARHGEF10L	HGNC	HGNC:25540	protein_coding	YES	CCDS182.1	ENSP00000355060	Q9HCE6		UPI00004CA9C5	NM_018125.3	deleterious(0)	probably_damaging(0.998)	29/29																			MODERATE	1	SNV	1			1											PASS	CCGACGACCCC	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM4025705;COSM4025706;COSM4025707	True	Unknown
AKR7A2	8574	BI	GRCh38	chr1	19304323	19304323	+	Missense_Mutation	SNP	C	C	T			TCGA-HU-A4GU-01A-11D-A25D-08	TCGA-HU-A4GU-10A-01D-A25E-08									Somatic						Illumina HiSeq 2000	58dd2029-bf64-426c-be2b-cc783ca6d671	9d2a2f5d-8369-40f9-8cc5-99b0c1ff8d88	c.982G>A	p.Ala328Thr	p.A328T	ENST00000235835	7/7	111	87	24	157			AKR7A2,missense_variant,p.A328T,ENST00000235835,NM_003689.3,c.982G>A,MODERATE,YES,tolerated(0.2),benign(0.054),-1;AKR7A2,missense_variant,p.A283T,ENST00000330072,,c.847G>A,MODERATE,,tolerated(0.19),benign(0.049),-1;AKR7A2,missense_variant,p.G190D,ENST00000489286,,c.568G>A,MODERATE,,,unknown(0),-1;RNU6-1099P,downstream_gene_variant,,ENST00000363533,,,MODIFIER,YES,,,-1;AKR7A2,3_prime_UTR_variant,,ENST00000481966,,c.*282G>A,MODIFIER,,,,-1;AKR7A2,downstream_gene_variant,,ENST00000492217,,,MODIFIER,,,,-1	T	ENSG00000053371	ENST00000235835	Transcript	missense_variant	missense_variant	1004/1362	982/1080	328/359	A/T	Gca/Aca		1		-1	AKR7A2	HGNC	HGNC:389	protein_coding	YES	CCDS194.1	ENSP00000235835	O43488	V9HWA2	UPI00001D965B	NM_003689.3	tolerated(0.2)	benign(0.054)	7/7		Pfam_domain:PF00248;Superfamily_domains:SSF51430																	MODERATE	1	SNV	1			1											PASS	TGCTGCCAAGT	4f909fab-4ba5-4cad-90de-f7b238309a94	8db4544c-a50e-4743-acc3-ac24696deb18	3f5bc2ea-c9cc-4431-ad8e-4dff1575ae72	b93221ba-2076-4dd4-9931-179571b7e16c		COSM4026476	True	Unknown
=cut
